unit YofUtils;

{
	HttpApp ̃N[₻̑Gp֐
}
interface

//==================================================
uses
//==================================================

	Classes, SysUtils;

procedure ExtractHttpFields(
	const chrSep : TSysCharSet;
	const chrWhite : TSysCharSet;
	const strValue : string;
	var strResult : TStringList;
	unknownFlag : boolean = false
);

function HtmlEncode(
	const strValue : string
) : string;

function HtmlDecode(
	const strValue : string
) : string;

function HttpEncode(
	const strValue : string
) : string;

function HttpDecode(
	const strValue : string
) : string;

function MatchesMask(
	const filename, mask : string
) : boolean;

// ^LN^𐳋K\ɂȂȂ悤ɒu
function RegExpEncode(
	const text : string
) : string;

//==================================================
const
//==================================================
	kYofKanji : TSysCharSet = [#$80..#$A0, #$E0..#$ff];

//==================================================
implementation
//==================================================

// Ƃ肠̑piȂ̂ chrWhite lĂȂƂɒӁIII
procedure ExtractHttpFields(
	const chrSep : TSysCharSet;
	const chrWhite : TSysCharSet;
	const strValue : string;
	var strResult : TStringList;
	unknownFlag : boolean = false
);
var
	last, p, strLen : Integer;
begin

	strLen := Length( strValue );
	p := 1;
	last := 1;

	while p <= strLen do
	begin

		if strValue[ p ] in chrSep then
		begin
			strResult.Add( Copy( strValue, last, p - last ) );
			last := p + 1;
		end;

		p := p + 1;

	end;

	if last <> p then
		strResult.Add( Copy( strValue, last, strLen - last + 1 ) );

end;

function HtmlEncode(
	const strValue : string
) : string;
var
	i : Integer;
	strLen : Integer;
	strResult : string;
begin

	strLen := Length( strValue );
	i := 1;

	while i <= strLen do
	begin

		case strValue[ i ] of
		'&':
			begin
				strResult := strResult + '&amp;';
			end;
		'<':
			begin
				strResult := strResult + '&lt;';
			end;
		'>':
			begin
				strResult := strResult + '&gt;';
			end;
		'"':
			begin
				strResult := strResult + '&quot;';
			end;
		else
			begin
				if strValue[ i ] in kYofKanji then
				begin
					strResult := strResult + strValue[ i ];
					Inc( i );
				end;
				strResult := strResult + strValue[ i ];
			end;
		end;

		i := i + 1;

	end;

	Result := strResult;

end;

function HtmlDecode(
	const strValue : string
) : string;
var
	strResult : string;
begin

	strResult := StringReplace( strValue, '&lt;', '<', [rfReplaceAll] );
	strResult := StringReplace( strResult, '&gt;', '>', [rfReplaceAll] );
	strResult := StringReplace( strResult, '&quot;', '"', [rfReplaceAll] );
	strResult := StringReplace( strResult, '&amp;', '&', [rfReplaceAll] );

	Result := strResult;

end;

function HttpEncode(
	const strValue : string
	) : string;
var
	i : Integer;
	strLen : Integer;
	strResult : string;
	b : Integer;
const
	kHexCode : array [0..15] of char = (
				'0', '1', '2', '3', '4', '5', '6', '7',
				'8', '9', 'A', 'B', 'C', 'D', 'E', 'F' );
begin

	strLen := Length( strValue );
	i := 1;

	while i <= strLen do
	begin

		case strValue[ i ] of
		'0' .. '9', 'a' .. 'z', 'A' .. 'Z', '*', '-', '.', '@', '_':
			begin
				strResult := strResult + strValue[ i ];
			end;
		else
			begin
				b := Integer( strValue[ i ] );
				strResult := strResult + '%'
								+ kHexCode[ b div $10 ]
								+ kHexCode[ b mod $10 ];
			end;
		end;

		i := i + 1;

	end;

	Result := strResult;

end;

function	toupper(
	ch : Longword
) : Byte; Register;
asm
	mov	ecx, eax		// ecx = (ch - 'a')
	sub	cl, 'a'
	cmp	ecx, 26			// edx = ecx < 26 (Ȃtrbg)
	sbb	edx, edx
	and	edx, $20		// edx &= 0x20 (Ȃ 0x20)
	xor	eax, edx		// eax ^= edx
end;

function HttpDecode(
	const strValue : string
) : string;
var
	i : Integer;
	strLen : Integer;
	strResult : string;
	b : Integer;
begin

	strLen := Length( strValue );
	i := 1;

	while i <= strLen do
	begin

		if '%' = strValue[ i ] then begin
			Inc( i );
			if strValue[ i ] in ['a' .. 'z', 'A' .. 'Z'] then
				b := (toupper( Longword( strValue[ i ] ) ) - 55) shl 4
			else
				b := (Byte( strValue[ i ] ) - Byte( '0' )) shl 4;
			Inc( i );
			if strValue[ i ] in ['a' .. 'z', 'A' .. 'Z'] then
				b := b or (toupper( Longword( strValue[ i ] ) ) - 55)
			else
				b := b or (Byte( strValue[ i ] ) - Byte( '0' ));

			strResult := strResult + Char( Byte( b ) );
		end else begin
			strResult := strResult + strValue[ i ];
		end;

		Inc( i );

	end;

	Result := strResult;

end;

// Ƃ肠̑piȂ̂ [] gK\lĂȂƂɒӁIII
function MatchesMask(
	const filename, mask : string
	) : boolean;
var
	pName, pMask : Integer;
	ptrName, ptrMask : PChar;
	nameLen, maskLen : Integer;
	chrUpMask : char;
	delimiterPos : Integer;
begin

	nameLen := Length( filename );
	maskLen := Length( mask );
	ptrName := PChar( filename );
	ptrMask := PChar( mask );
	pName := 0;
	pMask := 0;
	delimiterPos := Pos( '\', string( ptrName + pName ) );
	while delimiterPos > 0 do
	begin
		pName := pName + delimiterPos;
		delimiterPos := Pos( '\', string( ptrName + pName ) );
	end;

	while (pMask < maskLen) and (pName < nameLen) do
	begin

		case ptrMask[ pMask ] of
		'?':
			begin
				//  1 ͉Ȃ
			end;
		'*':
			begin
				pMask := pMask + 1;
				// mask 𑖍؂I
				if pMask >= maskLen then
				begin
					Result := true;
					exit;
				end;

				// * ̎̕܂Ŕ΂
				chrUpMask := upcase( ptrMask[ pMask ] );
				while chrUpMask <> UpCase( ptrName[ pName ] ) do
				begin
					pName := pName + 1;
					if pName >= nameLen then
					begin
						Result := true;
						exit;
					end;
				end;

				// * ̎̕ȂI
				if chrUpMask <> UpCase( ptrName[ pName ] ) then
				begin
					Result := false;
					exit;
				end;

				pName := pName + 1;
				pMask := pMask + 1;
			end;
		else
			begin
				//  1 I
				if UpCase( ptrMask[ pMask ] ) <> UpCase( ptrName[ pName ] ) then
				begin
					Result := false;
					exit;
				end;

			end;
		end;

		// ̕
		pName := pName + 1;
		pMask := pMask + 1;

	end;

	if (pMask >= maskLen) and (pName >= nameLen) then
		Result := true
	else
		Result := false;

end;


// ^LN^𐳋K\ɂȂȂ悤ɒu
function RegExpEncode(
	const text : string
) : string;
var
	strResult : string;
begin

	strResult := StringReplace( text, '\', '\\', [rfReplaceAll] );
	strResult := StringReplace( strResult, '[', '\[', [rfReplaceAll] );
	strResult := StringReplace( strResult, ']', '\]', [rfReplaceAll] );
	strResult := StringReplace( strResult, '(', '\(', [rfReplaceAll] );
	strResult := StringReplace( strResult, ')', '\)', [rfReplaceAll] );
	strResult := StringReplace( strResult, '[', '\[', [rfReplaceAll] );
	strResult := StringReplace( strResult, ']', '\]', [rfReplaceAll] );
	strResult := StringReplace( strResult, '*', '\*', [rfReplaceAll] );
	strResult := StringReplace( strResult, '?', '\?', [rfReplaceAll] );
	strResult := StringReplace( strResult, '.', '\.', [rfReplaceAll] );
	strResult := StringReplace( strResult, '+', '\+', [rfReplaceAll] );
	strResult := StringReplace( strResult, '|', '\|', [rfReplaceAll] );
	strResult := StringReplace( strResult, '^', '\^', [rfReplaceAll] );
	strResult := StringReplace( strResult, '$', '\$', [rfReplaceAll] );

	Result := strResult;

end;

end.
