unit Sort;

interface
uses
	Windows, Messages, SysUtils, Classes, Controls, Forms,
	BoardGroup,DateUtils;

	function CategorySortProc(Item1, Item2: Pointer): integer;
	function BoardSortProc(List: TStringList; Item1, Item2: Integer): integer;
	function ThreadItemSortProc(List: TStringList; Item1, Item2: Integer): integer;
	function CompareBool(Item1, Item2: Boolean): integer;
	function CompareInt(Item1, Item2: Integer): Integer;
	function CompareDate(Item1, Item2: TDateTime): Integer;

var
	SortOrder: Boolean;
	SortIndex: Integer;
	SortNoFlag: Boolean;

implementation

function CategorySortProc(Item1, Item2: Pointer): integer;
var
	CategoryItem1: TCategory;
	CategoryItem2: TCategory;
begin
	CategoryItem1 := TCategory(Item1);
	CategoryItem2 := TCategory(Item2);

	if SortNoFlag then
		Result := CompareInt(CategoryItem1.No, CategoryItem2.No)
	else
		Result := AnsiCompareText(CategoryItem1.Title, CategoryItem2.Title);

	if not SortOrder then
		Result := Result * -1;
end;

function BoardSortProc(List: TStringList; Item1, Item2: Integer): integer;
var
	BoardItem1: TBoard;
	BoardItem2: TBoard;
begin
	BoardItem1 := TBoard(List.Objects[Item1]);
	BoardItem2 := TBoard(List.Objects[Item2]);
	if SortIndex = 0 then
		if SortNoFlag then
			Result := CompareInt(BoardItem1.No, BoardItem2.No)
		else
			Result := AnsiCompareText(BoardItem1.Title, BoardItem2.Title)
	else if SortIndex = 1 then
		Result := CompareInt(BoardItem1.Count, BoardItem2.Count)
    else
		Result := CompareDate(BoardItem1.RoundDate, BoardItem2.RoundDate);

	if not SortOrder then
		Result := Result * -1;
end;

function ThreadItemSortProc(List: TStringList; Item1, Item2: Integer): integer;
var
	ThreadItem1: TThreadItem;
	ThreadItem2: TThreadItem;
begin
	ThreadItem1 := TThreadItem(List.Objects[ Item1 ]);
	ThreadItem2 := TThreadItem(List.Objects[ Item2 ]);
	case SortIndex of
		0:
			begin
				if SortNoFlag then
					Result := CompareInt(ThreadItem1.No, ThreadItem2.No)
				else
					Result := AnsiCompareText(ThreadItem1.Title, ThreadItem2.Title)
			end;
		1: Result := CompareInt(ThreadItem1.AllResCount, ThreadItem2.AllResCount);
		2: Result := CompareInt(ThreadItem1.Count, ThreadItem2.Count);
		3: Result := CompareInt(ThreadItem1.NewResCount, ThreadItem2.NewResCount);
		4: Result := 0;
		5: Result := AnsiCompareText(ThreadItem1.RoundName, ThreadItem2.RoundName);
		6: Result := CompareDateTime(ThreadItem1.RoundDate, ThreadItem2.RoundDate);
        7: Result := CompareDateTime(ThreadItem1.CreateDate, ThreadItem2.CreateDate);
    else
    	Result := 0;
	end;

{	if SortIndex = 0 then
		if SortNoFlag then
			Result := CompareInt(ThreadItem1.No, ThreadItem2.No)
		else
			Result := CompareText(ThreadItem1.Title, ThreadItem2.Title)
	else if SortIndex = 1 then
		Result := CompareInt(ThreadItem1.Count, ThreadItem2.Count)
	else if SortIndex = 2 then
//		Result := CompareInt(ThreadItem1.RoundNo, ThreadItem2.RoundNo)
		Result := CompareText(ThreadItem1.RoundName, ThreadItem2.RoundName)
	else
		Result := CompareDate(ThreadItem1.LastModified, ThreadItem2.LastModified);
}
	if not SortOrder then
		Result := Result * -1;
end;

function CompareBool(Item1, Item2: Boolean): Integer;
begin
	if (Item1 = True) and (Item2 = False) then
		Result := 1
	else if (Item2 = False) and (Item2 = True) then
		Result := -1
	else
		Result := 0;
end;

function CompareInt(Item1, Item2: Integer): Integer;
begin
	if Item1 > Item2 then
		Result := 1
	else if Item1 < Item2 then
		Result := -1
	else
		Result := 0;
end;

function CompareDate(Item1, Item2: TDateTime): Integer;
begin
	if Item1 > Item2 then
		Result := 1
	else if Item1 < Item2 then
		Result := -1
	else
		Result := 0;
end;

end.
