unit MojuUtils;
//******************************************************************************
//	̏Au֐ CustomStringReplace@B
//  ǵA
//@CustomStringReplace(
//@	̕iStringTStringList),
//@	iString),
//		uiString),
//      啶iBoolean)True:ʂȂ@false or ȗ:ʂ
//
// Delphi-ML̋L69334ɍڂĂR[hۃpN܂B
//******************************************************************************

interface

uses
	Windows, Classes, SysUtils;

    function StrPosEx(StrStart, StrEnd, SubstrStart, SubstrEnd: PChar): PChar;
    function AnsiStrPosEx(StrStart, StrEnd, SubstrStart, SubstrEnd: PChar): PChar;
    function ReplaceString(const S, OldPattern, NewPattern: string): string;
    function IgnoCaseReplaceString(const S, OldPattern, NewPattern: string): string;

    function CustomStringReplace(S , OldPattern: String;const  NewPattern: string): String; overload;
    function CustomStringReplace(S , OldPattern: String;const  NewPattern: string; IgnoreCase : Boolean): String; overload;
    procedure CustomStringReplace(var S : TStringList; OldPattern: String;const  NewPattern: string);overload;
    procedure CustomStringReplace(var S : TStringList; OldPattern: String;const  NewPattern: string; IgnoreCase : Boolean);overload;


implementation

function StrPosEx(StrStart, StrEnd, SubstrStart, SubstrEnd: PChar): PChar;
asm
        PUSH    EBX
        PUSH    ESI
        PUSH    EDI

        MOV    ESI,ECX        { Point ESI to substr                  }
        MOV    EDI,EAX        { Point EDI to s                        }

        MOV    ECX,EDX        { ECX = search length                  }
        SUB    ECX,EAX

        MOV    EDX,SubstrEnd
        SUB    EDX,ESI

        DEC    EDX            { EDX = Length(substr) - 1              }
        JS      @@fail        { < 0 ? return 0                        }
        MOV    AL,[ESI]      { AL = first char of substr            }
        INC    ESI            { Point ESI to 2'nd char of substr      }

        SUB    ECX,EDX        { #positions in s to look at            }
                              { = Length(s) - Length(substr) + 1      }
        JLE    @@fail
@@loop:
        REPNE  SCASB
        JNE    @@fail
        MOV    EBX,ECX        { save outer loop counter              }
        PUSH    ESI            { save outer loop substr pointer        }
        PUSH    EDI            { save outer loop s pointer            }

        MOV    ECX,EDX
        REPE    CMPSB
        POP    EDI            { restore outer loop s pointer          }
        POP    ESI            { restore outer loop substr pointer    }
        JE      @@found
        MOV    ECX,EBX        { restore outer loop counter            }
        JMP    @@loop

@@fail:
        XOR    EAX,EAX
        JMP    @@exit

@@found:
        MOV    EAX,EDI        { EDI points of char after match        }
        DEC    EAX
@@exit:
        POP    EDI
        POP    ESI
        POP    EBX
end;

function AnsiStrPosEx(StrStart, StrEnd, SubstrStart, SubstrEnd: PChar): PChar;
var
    L2: Cardinal;
    ByteType : TMbcsByteType;
begin
    Result := nil;
    if (StrStart = nil) or (StrStart^ = #0) or
    	(SubstrStart = nil) or (SubstrStart^ = #0) then Exit;

    L2 := SubstrEnd - SubstrStart;
    Result := StrPosEx(StrStart, StrEnd, SubstrStart, SubstrEnd);

    while (Result <> nil) and (StrEnd - Result >= L2) do begin
    	ByteType := StrByteType(StrStart, Integer(Result-StrStart));
    	if (ByteType <> mbTrailByte) and
    		(CompareString(LOCALE_USER_DEFAULT, SORT_STRINGSORT, Result, L2, SubstrStart, L2) = 2)
    	then Exit;
    	if (ByteType = mbLeadByte) then Inc(Result);
    	Inc(Result);
    	Result := StrPosEx(Result, StrEnd, SubStrStart, SubStrEnd);
    end;
    Result := nil;
end;

{$R-}
function ReplaceString(const S, OldPattern, NewPattern: string): string;
var
    ReplaceCount: Integer;
    DestIndex: Integer;
    i, l: Integer;
    p, e, ps, pe: PChar;
    Count: Integer;
begin
    Result := S;
    if OldPattern = '' then Exit;
    p := PChar(S);
    e := p + Length(S);
    ps := PChar(OldPattern);
    pe := ps + Length(OldPattern);
    ReplaceCount := 0;
    while p < e do begin
        p := AnsiStrPosEx(p, e, ps, pe);
        if p = nil then Break;
        Inc(ReplaceCount);
        Inc(p, Length(OldPattern));
    end;
    if ReplaceCount = 0 then Exit;
    SetString(Result, nil, Length(S) +
    (Length(NewPattern) - Length(OldPattern)) * ReplaceCount);
    p := PChar(S);
    DestIndex := 1;
    l := Length( NewPattern );
    for i := 0 to ReplaceCount - 1 do begin
        Count := AnsiStrPosEx(p, e, ps, pe) - p;
        Move(p^, Result[DestIndex], Count);
        Inc(p, Count);//p := pp;
        Inc(DestIndex, Count);
        Move(NewPattern[1], Result[DestIndex], l);
        Inc(p, Length(OldPattern));
        Inc(DestIndex, l);
    end;
    Move(p^, Result[DestIndex], e - p);
end;

function IgnoCaseReplaceString(const S, OldPattern, NewPattern: string): string;
var
    ReplaceCount: Integer;
    DestIndex: Integer;
    i, l: Integer;
    p, e{, ps, pe}: PChar;
    p2, e2, ps2, pe2: PChar;
    Count: Integer;
    bufferS : String;
    bufferOldPattern : String;
begin
    Result := S;
    bufferS := AnsiLowerCase(S);
    bufferOldPattern := AnsiLowerCase(OldPattern);

    if OldPattern = '' then Exit;
    p	:= PChar(S);
    p2	:= PChar(bufferS);
    e	:= p + Length(S);
    e2	:= p2 + Length(bufferS);
    //ps	:= PChar(OldPattern);
    ps2	:= PChar(bufferOldPattern);
    //pe	:= ps + Length(OldPattern);
    pe2	:= ps2 + Length(bufferOldPattern);

    ReplaceCount := 0;
    while p2 < e2 do begin
        p2 := AnsiStrPosEx(p2, e2, ps2, pe2);
        if p2 = nil then Break;
        Inc(ReplaceCount);
        Inc(p2, Length(bufferOldPattern));
    end;
    if ReplaceCount = 0 then Exit;
    SetString(Result, nil, Length(bufferS) +
    (Length(NewPattern) - Length(bufferOldPattern)) * ReplaceCount);
    p2 := PChar(bufferS);
    DestIndex := 1;
    l := Length( NewPattern );
    for i := 0 to ReplaceCount - 1 do begin
        Count := AnsiStrPosEx(p2, e2, ps2, pe2) - p2;
        Move(p^, Result[DestIndex], Count);
        Inc(p, Count);//p := pp;
        Inc(p2, Count);//p := pp;
        Inc(DestIndex, Count);
        Move(NewPattern[1], Result[DestIndex], l);
        Inc(p, Length(OldPattern));
        Inc(p2, Length(OldPattern));
        Inc(DestIndex, l);
    end;
    Move(p^, Result[DestIndex], e - p);
end;
{$IFDEF DEBUG}
{$R+}
{$ENDIF}

function CustomStringReplace(
	S ,OldPattern: String;
    const NewPattern: string
): String;

begin
    Result := ReplaceString(S,OldPattern,NewPattern);
end;


function CustomStringReplace(
	S , OldPattern: String;
    const  NewPattern: string;
    IgnoreCase : Boolean
): String;
begin
    Result := '';
    if not IgnoreCase then begin
        Result := ReplaceString(S,OldPattern,NewPattern);
    end else begin
        Result := IgnoCaseReplaceString(S,OldPattern,NewPattern);
    end;
end;


procedure CustomStringReplace(
	var S : TStringList;
    OldPattern: String;
    const  NewPattern: string;
    IgnoreCase : Boolean
);
var
    i : Integer;
begin
    S.BeginUpdate;
    if not IgnoreCase then begin
        for i := 0 to S.Count - 1 do begin
            S.Strings[i] := ReplaceString(S.Strings[i], OldPattern,NewPattern);
        end;
    end else begin
        for i := 0 to S.Count - 1 do begin
            S.Strings[i] := IgnoCaseReplaceString(S.Strings[i], OldPattern,NewPattern);
        end;
    end;
    S.EndUpdate;
end;


procedure CustomStringReplace(
	var S : TStringList;
    OldPattern: String;
    const  NewPattern: string
);
var
    i : Integer;
begin
    S.BeginUpdate;
	for i := 0 to S.Count - 1 do begin
		S.Strings[i] := ReplaceString(S.Strings[i], OldPattern,NewPattern);;
    end;
    S.EndUpdate;
end;


end.
