unit FavoriteArrange;

interface

uses
	Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
	Dialogs, ComCtrls, StdCtrls, ExtCtrls, Favorite, ImgList, NewFavoriteFolder,
	GikoSystem, GikoUtil;

type
  TFavoriteArrangeDialog = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Label1: TLabel;
    DeleteButton: TButton;
    RenameButton: TButton;
    NewFolderButton: TButton;
    FolderTreeView: TTreeView;
    Panel4: TPanel;
    CloseButton: TButton;
    procedure CloseButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure NewFolderButtonClick(Sender: TObject);
    procedure RenameButtonClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure FolderTreeViewEdited(Sender: TObject; Node: TTreeNode;
      var S: String);
    procedure FolderTreeViewDragOver(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
		procedure FolderTreeViewDragDrop(Sender, Source: TObject; X,
			Y: Integer);
		procedure FormDestroy(Sender: TObject);
	private
		{ Private 錾 }
//		FDragNode: TTreeNode;
		FDeleteList: TList;
//		procedure PrepareFavoriteTree(Favo: TFavoriteItem; Node: TTreeNode);
		procedure SetDeleteItemList(Node: TTreeNode);
	public
		{ Public 錾 }
	end;

var
	FavoriteArrangeDialog: TFavoriteArrangeDialog;

implementation

uses Giko;

{$R *.dfm}

procedure TFavoriteArrangeDialog.CloseButtonClick(Sender: TObject);
begin
	Close;
end;

procedure TFavoriteArrangeDialog.FormCreate(Sender: TObject);
begin
	FDeleteList := TList.Create;
	FolderTreeView.Items := FavoriteDM.TreeView.Items;

	if FolderTreeView.Items.GetFirstNode <> nil then begin
		FolderTreeView.Items.GetFirstNode.Expanded := True;
		FolderTreeView.Items.GetFirstNode.Selected := True;
	end;


{	Node := FolderTreeView.Items.AddChild(nil, GikoForm.Favorite.Root.Title);
	Node.ImageIndex := 0;
	Node.Data := GikoForm.Favorite.Root;
	PrepareFavoriteTree(GikoForm.Favorite.Root, Node);
	Node.Expanded := True;
	Node.Selected := True;}
end;

{procedure TFavoriteArrangeDialog.PrepareFavoriteTree(Favo: TFavoriteItem; Node: TTreeNode);
var
	i: Integer;
	ChildFavo: TFavoriteItem;
	ChildNode: TTreeNode;
begin
{	for i := 0 to TFavoriteFolder(Favo).Count - 1 do begin

		ChildFavo := TFavoriteFolder(Favo).Items[i];
		if ChildFavo is TFavoriteFolder then begin
			ChildNode := FolderTreeView.Items.AddChild(Node, ChildFavo.Title);
			ChildNode.ImageIndex := 0;
			ChildNode.SelectedIndex := 0;
			ChildNode.Data := ChildFavo;
			PrepareFavoriteTree(ChildFavo, ChildNode);
		end else if ChildFavo is TFavoriteBoardItem then begin
			ChildNode := FolderTreeView.Items.AddChild(Node, ChildFavo.Title);
			ChildNode.ImageIndex := 1;
			ChildNode.SelectedIndex := 1;
			ChildNode.Data := ChildFavo;
		end else if ChildFavo is TFavoriteThreadItem then begin
			ChildNode := FolderTreeView.Items.AddChild(Node, ChildFavo.Title);
			ChildNode.ImageIndex := 2;
			ChildNode.SelectedIndex := 2;
			ChildNode.Data := ChildFavo;
		end;
	end;
end;  }

procedure TFavoriteArrangeDialog.NewFolderButtonClick(Sender: TObject);
var
	Dlg: TNewFavoriteFolderDialog;
	NewFavFolder: TFavoriteFolder;
	Node: TTreeNode;
begin
	if FolderTreeView.Selected = nil then
		Exit;
	Dlg := TNewFavoriteFolderDialog.Create(Self);
	try
		Dlg.ShowModal;
		if Dlg.ModalResult = mrOK then begin
			if Length(Dlg.FolderEdit.Text) = 0 then
				Exit;
			if not (TObject(FolderTreeView.Selected.Data) is TFavoriteFolder) then
				FolderTreeView.Selected := FolderTreeView.Selected.Parent;

			NewFavFolder := TFavoriteFolder.Create;
			Node := FolderTreeView.Items.AddChildObject(FolderTreeView.Selected, Dlg.FolderEdit.Text, NewFavFolder);
			Node.ImageIndex := 14;
			Node.SelectedIndex := 14;
//			FolderTreeView.Selected.Expanded := True;
			FolderTreeView.Selected := Node;
		end;
	finally
		Dlg.Release;
	end;
end;

procedure TFavoriteArrangeDialog.RenameButtonClick(Sender: TObject);
begin
	if FolderTreeView.Selected = nil then
		Exit;
	if FolderTreeView.Selected.IsFirstNode then
		Exit;
	if FolderTreeView.Selected.Text = Favorite.FAVORITE_LINK_NAME then
		Exit;
	FolderTreeView.ReadOnly := False;
	FolderTreeView.Selected.EditText;
end;

procedure TFavoriteArrangeDialog.DeleteButtonClick(Sender: TObject);
const
	DEL_LINK_MSG = 'gNh̓No[ptH_łB폜Ă낵łH';
	DEL_MSG = 'g^0h폜܂B낵łH';
	DEL_TITLE = '폜mF';
begin
	if FolderTreeView.Selected = nil then
		Exit;
	if FolderTreeView.Selected.IsFirstNode then
		Exit;
	if FolderTreeView.Selected.Text = Favorite.FAVORITE_LINK_NAME then begin
		if MsgBox(Handle, DEL_LINK_MSG, DEL_TITLE, MB_YESNO or MB_ICONQUESTION) <> ID_YES then
			Exit;
	end else if (GetKeyState( VK_SHIFT ) and $80000000) = 0 then begin
		if MsgBox(Handle, StringReplace( DEL_MSG, '^0', FolderTreeView.Selected.Text, [rfReplaceAll] ) , DEL_TITLE, MB_YESNO or MB_ICONQUESTION) <> ID_YES then
			Exit;
	end;

	FDeleteList.Add(FolderTreeView.Selected.Data);
	SetDeleteItemList(FolderTreeView.Selected);

	FolderTreeView.Selected.Delete;
end;

procedure TFavoriteArrangeDialog.FolderTreeViewEdited(Sender: TObject;
	Node: TTreeNode; var S: String);
begin
	FolderTreeView.ReadOnly := True;
end;

procedure TFavoriteArrangeDialog.FolderTreeViewDragOver(Sender,
	Source: TObject; X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
	if Source = FolderTreeView then begin
		if FolderTreeView.Selected = FolderTreeView.Items.GetFirstNode then begin
			Accept := False;
			Exit;
		end;
		Accept := True;
	end else
		Accept := False;
end;

procedure TFavoriteArrangeDialog.FolderTreeViewDragDrop(Sender,
	Source: TObject; X, Y: Integer);
begin
	if FolderTreeView.GetNodeAt(X, Y) = nil then
		Exit;
	if Source <> FolderTreeView then
		Exit;
	if FolderTreeView.Selected = FolderTreeView.GetNodeAt(X, Y) then
		Exit;

	if TObject(FolderTreeView.GetNodeAt(X, Y).Data) is TFavoriteFolder then
		FolderTreeView.Selected.MoveTo(FolderTreeView.GetNodeAt(X, Y), naAddChild)
	else if TObject(FolderTreeView.GetNodeAt(X, Y).Data) is TFavoriteBoardItem then
		FolderTreeView.Selected.MoveTo(FolderTreeView.GetNodeAt(X, Y), naInsert)
	else if TObject(FolderTreeView.GetNodeAt(X, Y).Data) is TFavoriteThreadItem then
		FolderTreeView.Selected.MoveTo(FolderTreeView.GetNodeAt(X, Y), naInsert);
end;

procedure TFavoriteArrangeDialog.FormDestroy(Sender: TObject);
var
	i: Integer;
begin
	FavoriteDM.TreeView.Items := FolderTreeView.Items;

	for i := FDeleteList.Count - 1 downto 0 do
		TObject(FDeleteList[i]).Free;
    FDeleteList.Free;
	FavoriteDM.WriteFavorite;
end;

procedure TFavoriteArrangeDialog.SetDeleteItemList(Node: TTreeNode);
var
	i: Integer;
begin
	for i := 0 to Node.Count - 1 do begin
		FDeleteList.Add(Node.Item[i].Data);
		if Node.Item[i].Count > 0 then
			SetDeleteItemList(Node.item[i]);
	end;
end;

end.
