unit ExternalBoardManager;

interface

uses
	Windows, Classes, SysUtils,
	IdHTTP, IdComponent, IdGlobal, IdException,
	ExternalBoardPlugInMain, ExternalFilePath, ExternalThreadItem, ExternalBoardItem;

type
	// =========================================================================
	// vOCǗ TBoardPlugin NX
	// =========================================================================
	TBoardPlugIn = class( TObject )
	private
		FFilePath						: string;		// vOCpX
		FModule							: HMODULE;	// vOC̃W[nh

		FLoad								: TOnLoad;
		FVersionInfo				: TOnVersionInfo;
		FAcceptURL					: TOnAcceptURL;
		FPlugInMenu					: TOnPlugInMenu;

		FCreateThreadItem		: TThreadItemCreate;
		FDisposeThreadItem	: TThreadItemDispose;
		FDownloadThread			: TThreadItemOnDownload;
		FWriteThread				: TThreadItemOnWrite;
		FGetRes							: TThreadItemOnGetRes;
		FGetDat							: TThreadItemOnGetDat;
		FGetHeader					: TThreadItemOnGetHeader;
		FGetFooter					: TThreadItemOnGetFooter;
		FGetBoardURL				: TThreadItemOnGetBoardURL;

 		FCreateBoardItem		: TBoardItemCreate;
		FDisposeBoardItem		: TBoardItemDispose;
		FDownloadBoard			: TBoardItemOnDownload;
		FCreateThread				: TBoardItemOnCreateThread;
		FEnumThread					: TBoardItemOnEnumThread;
		FFileName2ThreadURL	: TBoardItemOnFileName2ThreadURL;

	public
		// RXgN^
		constructor	Create;
		// vOC̃pXw肵č쐬
		constructor	CreateFromPath( inPath : string );
		// vOCw肵č쐬
		constructor	CreateFromName( inName : string );
		// W[nhw肵č쐬
		constructor	CreateFromModule( inModule : HMODULE );
		// fXgN^
		destructor	Destroy; override;

		// vOC̃pXw肵ă[h
		procedure	LoadFromPath( inPath : string );
		// vOCw肵ă[h
		procedure	LoadFromName( inName : string );
		// W[nhw肵ă[h
		procedure	LoadFromModule( inModule : HMODULE );

		//===== PlugInMain ֘A
		// vOC()[hꂽ
		procedure	Loaded;
		// o[W
		procedure	VersionInfo(	var outAgent : string;
			var outMajor : DWORD; var outMinor : DWORD;
			var outRelease : string; var outRevision : DWORD );
		// w肵 URL ̃vOCŎ󂯕t邩ǂ
		function	AcceptURL( inURL : string ) : TAcceptType;
		// j[nh
		procedure	PlugInMenu( inHandle : HMENU );

		//===== TThreadItem ֘A
		// TThreadItem ꂽ
		procedure	CreateThreadItem( threadItem : DWORD );
		// TThreadItem jꂽ
		procedure	DisposeThreadItem( threadItem : DWORD );
		// _E[hw
		function	DownloadThread( threadItem : DWORD ) : TDownloadState;
		// ݂w
		function	WriteThread( threadItem : DWORD; inName : string; inMail : string; inMessage : string ) : TDownloadState;
		// Xԍ n ɑ΂ html v
		function	GetRes( threadItem : DWORD; inNo : DWORD ) : string;
		// Xԍ n ɑ΂ Dat v
		function	GetDat( threadItem : DWORD; inNo : DWORD ) : string;
		// Xbh̃wb_ html v
		function	GetHeader( threadItem : DWORD; inOptionalHeader : string ) : string;
		// Xbh̃tb^ html v
		function	GetFooter( threadItem : DWORD; inOptionalFooter : string ) : string;
		//  ThreadItem  URL v
		function	GetBoardURL( threadItem : DWORD ) : string;

		//===== TBoardItem ֘A
		// TBoard ꂽ
		procedure	CreateBoardItem( boardItem : DWORD );
		// TBoardItem jꂽ
		procedure	DisposeBoardItem( boardItem : DWORD );
		// _E[hw
		function	DownloadBoard( boardItem : DWORD ) : TDownloadState;
		// XĂw
		function	CreateThread( boardItem : DWORD; inSubject : string; inName : string; inMail : string; inMessage : string ) : TDownloadState;
		// ̔ɕۗLĂX
		procedure EnumThread( boardItem : DWORD; inCallBack : TBoardItemEnumThreadCallBack );
		// t@CXbh URL v
		function	FileName2ThreadURL( boardItem : DWORD; inFileName : string ) : string;

	private
		procedure	LoadPlugInAPI;

	public
		property	FilePath	: string	read FFilePath;
		property	Module		: HMODULE	read FModule;
	end;

var
	OnWork				: TWorkEvent;
	OnWorkBegin		: TWorkBeginEvent;
	OnWorkEnd			: TWorkEndEvent;

	BoardPlugIns	: array of TBoardPlugIn;

procedure InitializeBoardPlugIns;

implementation

uses GikoSystem;

// *************************************************************************
// BoardPlugin tH_ɂvOCSă[h
// *************************************************************************
procedure InitializeBoardPlugIns;
var
	i, bound		: Integer;
	pluginNames	: TStringList;
begin

	pluginNames := TStringList.Create;
	try
		GikoSys.GetFileList( GikoSys.Setting.GetBoardPlugInDir, '*', pluginNames, False, False );
		SetLength( BoardPlugIns, pluginNames.Count );

		bound := pluginNames.Count - 1;
		for i := 0 to bound do begin
			try
				BoardPlugIns[ i ] := TBoardPlugIn.CreateFromName( pluginNames.Strings[ i ] );
				BoardPlugIns[ i ].Loaded;
			except end;
		end;
	finally
		pluginNames.Free;
	end;

end;



// =========================================================================
// vOCǗ TBoardPlugin NX
// =========================================================================

// *************************************************************************
// RXgN^
// *************************************************************************
constructor	TBoardPlugIn.Create;
begin

	inherited;

	FLoad								:= nil;
	FVersionInfo				:= nil;
	FAcceptURL					:= nil;
	FPlugInMenu					:= nil;

	FCreateThreadItem		:= nil;
	FDisposeThreadItem	:= nil;
	FDownloadThread			:= nil;
	FWriteThread				:= nil;
	FGetRes							:= nil;
	FGetDat							:= nil;
	FGetHeader					:= nil;
	FGetFooter					:= nil;

	FCreateBoardItem		:= nil;
	FDisposeBoardItem		:= nil;
	FDownloadBoard			:= nil;
	FCreateThread				:= nil;
	FEnumThread					:= nil;
	FFileName2ThreadURL	:= nil;

end;

// *************************************************************************
// vOC̃pXw肵č쐬
// *************************************************************************
constructor	TBoardPlugIn.CreateFromPath(
	inPath : string
);
begin

	Create;

	LoadFromPath( inPath );

end;

// *************************************************************************
// vOCw肵č쐬
// *************************************************************************
constructor	TBoardPlugIn.CreateFromName(
	inName : string
);
begin

	Create;

	LoadFromName( inName );

end;

// *************************************************************************
// W[nhw肵č쐬
// *************************************************************************
constructor	TBoardPlugIn.CreateFromModule(
	inModule : HMODULE
);
begin

	inherited Create;

	LoadFromModule( inModule );

end;

// *************************************************************************
// fXgN^
// *************************************************************************
destructor	TBoardPlugIn.Destroy;
begin

	FreeLibrary( FModule );

	inherited;

end;

// *************************************************************************
// vOC̃pXw肵ă[h
// *************************************************************************
procedure TBoardPlugIn.LoadFromPath(
	inPath : string
);
begin

	FFilePath := inPath;
	if FileExists( inPath ) then
		FModule := LoadLibrary( PChar( inPath ) )
	else if FileExists( inPath + '.dll' ) then
		FModule := LoadLibrary( PChar( inPath + '.dll' ) );

	LoadPlugInAPI;

end;

// *************************************************************************
// vOCw肵ă[h
// *************************************************************************
procedure TBoardPlugIn.LoadFromName(
	inName : string
);
begin

	LoadFromPath( GikoSys.Setting.GetBoardPlugInDir + inName );

end;

// *************************************************************************
// W[nhw肵ă[h
// *************************************************************************
procedure TBoardPlugIn.LoadFromModule(
	inModule	: HMODULE
);
var
	tmp				: array [0..MAX_PATH] of Char;
begin

	GetModuleFileName( inModule, tmp, SizeOf( tmp ) );
	FFilePath	:= tmp;
	FModule		:= inModule;

	LoadPlugInAPI;

end;

// *************************************************************************
// vOC()[hꂽ
// *************************************************************************
procedure TBoardPlugIn.Loaded;
begin

	if Assigned( FLoad ) then
		FLoad( DWORD( Self ) );

end;

// *************************************************************************
// o[W
// *************************************************************************
procedure TBoardPlugIn.VersionInfo(
	var outAgent		: string;		// o[W؊܂܂ȂȖ
	var outMajor		: DWORD;		// W[o[W
	var outMinor		: DWORD;		// }Ci[o[W
	var outRelease	: string;		// [XiK
	var outRevision	: DWORD			// rWio[
);
var
	agent						: PChar;
	release					: PChar;
begin

	if Assigned( FVersionInfo ) then begin
		FVersionInfo( agent, outMajor, outMinor, release, outRevision );
		outAgent		:= string( agent );
		outRelease	:= string( release );
		DisposeResultString( agent );
		DisposeResultString( release );
	end;

end;

// *************************************************************************
// w肵 URL ̃vOCŎ󂯕t邩ǂ
// *************************************************************************
function	TBoardPlugIn.AcceptURL(
	inURL : string
) : TAcceptType;
begin

	if Assigned( FAcceptURL ) then
		Result := FAcceptURL( PChar( inURL ) )
	else
		Result := atNoAccept;

end;

// *************************************************************************
// j[nh
// *************************************************************************
procedure TBoardPlugIn.PlugInMenu(
	inHandle : HMENU					// j[nh
);
begin

	if Assigned( FPlugInMenu ) then
		FPlugInMenu( inHandle );

end;

// *************************************************************************
// TThreadItem ꂽ
// *************************************************************************
procedure	TBoardPlugIn.CreateThreadItem(
	threadItem : DWORD	// ThreadItem ̃CX^X
);
begin

	if Assigned( FCreateThreadItem ) then
		FCreateThreadItem( threadItem );

end;

// *************************************************************************
// TThreadItem jꂽ
// *************************************************************************
procedure	TBoardPlugIn.DisposeThreadItem(
	threadItem : DWORD	// ThreadItem ̃CX^X
);
begin

	if Assigned( FDisposeThreadItem ) then
		FDisposeThreadItem( threadItem );

end;

// *************************************************************************
// _E[hw
// *************************************************************************
function	TBoardPlugIn.DownloadThread(
	threadItem : DWORD	// ThreadItem ̃CX^X
) : TDownloadState;
begin

	if Assigned( FDownloadThread ) then
		Result := FDownloadThread( threadItem )
	else
		Result := dsError;

end;

// *************************************************************************
// ݂w
// *************************************************************************
function	TBoardPlugIn.WriteThread(
	threadItem	: DWORD;	// ThreadItem ̃CX^X
	inName			: string;	// O(nh)
	inMail			: string;	// [AhX
	inMessage		: string	// {
) : TDownloadState;			// ݂ǂ
begin

	if Assigned( FWriteThread ) then
		Result := FWriteThread( threadItem, PChar( inName ), PChar( inMail ), PChar( inMessage ) )
	else
		Result := dsError;

end;

// *************************************************************************
// Xԍ n ɑ΂ html v
// *************************************************************************
function TBoardPlugIn.GetRes(
	threadItem	: DWORD;		// ThreadItem ̃CX^X
	inNo				: DWORD			// \郌Xԍ
) : string; 							// \ HTML
var
	tmp					: PChar;
begin

	if Assigned( FGetRes ) then begin
		tmp			:= FGetRes( threadItem, inNo );
		try
			Result	:= string( tmp );
		finally
			DisposeResultString( tmp );
		end;
	end;

end;

// *************************************************************************
// Xԍ n ɑ΂ Dat v
// *************************************************************************
function TBoardPlugIn.GetDat(
	threadItem	: DWORD;		// ThreadItem ̃CX^X
	inNo				: DWORD			// \郌Xԍ
) : string; // Q˂dat`
var
	tmp :	PChar;
begin

	if Assigned( FGetDat ) then begin
		tmp := FGetDat( threadItem, inNo );
		try
			Result := string( tmp );
		finally
			DisposeResultString(tmp);  end;
	end;

end;

// *************************************************************************
// Xbh̃wb_ html v
// *************************************************************************
function TBoardPlugIn.GetHeader(
	threadItem				: DWORD;	// ThreadItem ̃CX^X
	inOptionalHeader	: string	// ǉ̃wb_
) : string;										// `ꂽ HTML
var
	tmp								: PChar;
begin

	if Assigned( FGetHeader ) then begin
		tmp			:= FGetHeader( threadItem, PChar( inOptionalHeader ) );
		try
			Result	:= string( tmp );
		finally
			DisposeResultString( tmp );
		end;
	end;

end;

// *************************************************************************
// Xbh̃tb^ html v
// *************************************************************************
function TBoardPlugIn.GetFooter(
	threadItem				: DWORD;	// ThreadItem ̃CX^X
	inOptionalFooter	: string	// ǉ̃tb^
) : string;										// `ꂽ HTML
var
	tmp								: PChar;
begin

	if Assigned( FGetFooter ) then begin
		tmp			:= FGetFooter( threadItem, PChar( inOptionalFooter ) );
		Result	:= string( tmp );
		DisposeResultString( tmp );
	end;

end;

// *************************************************************************
//  ThreadItem  URL v
// *************************************************************************
function	TBoardPlugIn.GetBoardURL(
	threadItem	: DWORD	// ThreadItem ̃CX^X
) : string;
var
	tmp					: PChar;
begin

	if Assigned( FGetBoardURL ) then begin
		tmp			:= FGetBoardURL( threadItem );
		Result	:= string( tmp );
		DisposeResultString( tmp );
	end;

end;

// *************************************************************************
// TBoardItem ꂽ
// *************************************************************************
procedure	TBoardPlugIn.CreateBoardItem(
	boardItem : DWORD	// BoardItem ̃CX^X
);
begin

	if Assigned( FCreateBoardItem ) then
		FCreateBoardItem( boardItem );

end;

// *************************************************************************
// TBoardItem jꂽ
// *************************************************************************
procedure	TBoardPlugIn.DisposeBoardItem(
	boardItem : DWORD	// BoardItem ̃CX^X
);
begin

	if Assigned( FDisposeBoardItem ) then
		FDisposeBoardItem( boardItem );

end;

// *************************************************************************
// _E[hw
// *************************************************************************
function	TBoardPlugIn.DownloadBoard(
	boardItem : DWORD	// BoardItem ̃CX^X
) : TDownloadState;
begin

	if Assigned( FDownloadBoard ) then
		Result := FDownloadBoard( boardItem )
	else
		Result := dsError;

end;

// *************************************************************************
// XĂw
// *************************************************************************
function	TBoardPlugIn.CreateThread(
	boardItem		: DWORD;	// BoardItem ̃CX^X
	inSubject		: string;	// X^C
	inName			: string;	// O(nh)
	inMail			: string;	// [AhX
	inMessage		: string	// {
) : TDownloadState;			// ݂ǂ
begin

	if Assigned( FCreateThread ) then
		Result := FCreateThread( boardItem, PChar( inSubject ), PChar( inName ), PChar( inMail ), PChar( inMessage ) )
	else
		Result := dsError;

end;

// *************************************************************************
// ̔ɕۗLĂX
// *************************************************************************
procedure TBoardPlugIn.EnumThread(
	boardItem		: DWORD;	// BoardItem ̃CX^X
	inCallBack	: TBoardItemEnumThreadCallBack
);
begin

	if Assigned( FEnumThread ) then
		FEnumThread( boardItem, inCallBack );

end;

// *************************************************************************
// t@CXbh URL v
// *************************************************************************
function	TBoardPlugIn.FileName2ThreadURL(
	boardItem		: DWORD;	// BoardItem ̃CX^X
	inFileName	: string
) : string;
var
	tmp								: PChar;
begin

	if Assigned( FFileName2ThreadURL ) then begin
		tmp			:= FFileName2ThreadURL( boardItem, PChar( inFileName ) );
		Result	:= string( tmp );
		DisposeResultString( tmp );
	end;

end;

// *************************************************************************
// vOC API 擾
// *************************************************************************
procedure TBoardPlugIn.LoadPlugInAPI;
begin

	try
		if Assigned( Pointer( FModule ) ) then begin
			FLoad								:= GetProcAddress( FModule, 'OnLoad' );
			FVersionInfo				:= GetProcAddress( FModule, 'OnVersionInfo' );
			FAcceptURL					:= GetProcAddress( FModule, 'OnAcceptURL' );
			FPlugInMenu					:= GetProcAddress( FModule, 'OnPlugInMenu' );

			FCreateThreadItem		:= GetProcAddress( FModule, 'ThreadItemCreate' );
			FDisposeThreadItem	:= GetProcAddress( FModule, 'ThreadItemDispose' );
			FDownloadThread			:= GetProcAddress( FModule, 'ThreadItemOnDownload' );
			FWriteThread				:= GetProcAddress( FModule, 'ThreadItemOnWrite' );
			FGetRes							:= GetProcAddress( FModule, 'ThreadItemOnGetRes' );
			FGetDat							:= GetProcAddress( FModule, 'ThreadItemOnGetDat' );
			FGetHeader					:= GetProcAddress( FModule, 'ThreadItemOnGetHeader' );
			FGetFooter					:= GetProcAddress( FModule, 'ThreadItemOnGetFooter' );
			FGetBoardURL				:= GetProcAddress( FModule, 'ThreadItemOnGetBoardURL' );

			FCreateBoardItem		:= GetProcAddress( FModule, 'BoardItemCreate' );
			FDisposeBoardItem		:= GetProcAddress( FModule, 'BoardItemDispose' );
			FDownloadBoard			:= GetProcAddress( FModule, 'BoardItemOnDownload' );
			FCreateThread				:= GetProcAddress( FModule, 'BoardItemOnCreateThread' );
			FEnumThread					:= GetProcAddress( FModule, 'BoardItemOnEnumThread' );
			FFileName2ThreadURL	:= GetProcAddress( FModule, 'BoardItemOnFileName2ThreadURL' );
		end;
	except
	end;

end;

end.

