library MachiBBSPlugIn;

{
	MachiBBSBoardPlugIn
	܂BBSjbg
}

uses
	Windows, SysUtils, Classes, Math, DateUtils,
	IdURI,
	PlugInMain in 'PlugInMain.pas',
	ThreadItem in 'ThreadItem.pas',
	BoardItem in 'BoardItem.pas',
	FilePath in 'FilePath.pas',
    MojuUtils in '..\..\MojuUtils.pas';

{$R *.res}

type
	// =========================================================================
	// TMachiBBSThreadItem
	// =========================================================================
	TMachiBBSThreadItem = class(TThreadItem)
	private
		FIsTemporary	: Boolean;
		FDat					: TStringList;
		//FFilePath		: String;
	public
		constructor	Create( inInstance : DWORD );
		destructor	Destroy; override;

	private
		function	Download : TDownloadState;
		function	Write( inName : string; inMail : string; inMessage : string ) : TDownloadState;
		function	GetRes( inNo : Integer ) : string;
		function	GetDat( inNo : Integer ) : string;
		function	GetHeader( inOptionalHeader : string ) : string;
		function	GetFooter( inOptionalFooter : string ) : string;
		function	GetBoardURL : string;

		procedure	To2chDat( ioHTML : TStringList; inStartNo : Integer = 1 );
		procedure	LoadDat;
		procedure	FreeDat;
		function	ReadURL : string;
		//property	FilePath : string read FFilePath;
	end;

	// =========================================================================
	// TMachiBBSBoardItem
	// =========================================================================
	TMachiBBSBoardItem = class(TBoardItem)
	private
		FIsTemporary	: Boolean;
		FDat					: TStringList;

	public
		constructor	Create( inInstance : DWORD );
		destructor	Destroy; override;

	private
		function	Download : TDownloadState;
		function	CreateThread( inSubject : string; inName : string; inMail : string; inMessage : string ) : TDownloadState;
		function	ToThreadURL( inFileName : string ) : string;
		procedure	EnumThread( inCallBack : TBoardItemEnumThreadCallBack );

		function	SubjectURL : string;
	end;

	// =========================================================================
	// TuWFNgR[h
	// =========================================================================
	TSubjectRec = record
		FFileName: string;
		FTitle: string;
		FCount: Integer;
	end;

const
	LOG_DIR						= 'MachiBBS\';
	SUBJECT_NAME			= 'subject.txt';

	PLUGIN_NAME				= 'MachiBBSPlugIn';
	MAJOR_VERSION			= 1;
	MINOR_VERSION			= 0;
	RELEASE_VERSION		= 'beta';
	REVISION_VERSION	= 21;

// =========================================================================
// Gp֐
// =========================================================================

// *************************************************************************
// e|ȃpX̎擾
// *************************************************************************
function TemporaryFile : string;
var
	tempPath : array [0..MAX_PATH] of	char;
begin

	GetTempPath( SizeOf(tempPath), tempPath );
	repeat
		Result := tempPath + IntToStr( Random( $7fffffff ) );
	until not FileExists( Result );

end;

// *************************************************************************
// ܂BBSpOtH_擾
// *************************************************************************
function MyLogFolder : string;
var
	folder : PChar;
begin

	folder := LogFolder;
	if Length( folder ) = 0 then
		Result := ''
	else
		Result := folder + LOG_DIR;
    DisposeResultString(folder);

end;

(*************************************************************************
 *fBNg݂邩`FbN
 *************************************************************************)
function DirectoryExistsEx(const Name: string): Boolean;
var
	Code: Integer;
begin
	Code := GetFileAttributes(PChar(Name));
	Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

(*************************************************************************
 *fBNg쐬iKwΉj
 *************************************************************************)
function ForceDirectoriesEx(Dir: string): Boolean;
begin
	Result := True;
	if Length(Dir) = 0 then
		raise Exception.Create('tH_쐬o܂');
	Dir := ExcludeTrailingPathDelimiter(Dir);
	if (Length(Dir) < 3) or DirectoryExistsEx(Dir)
		or (ExtractFilePath(Dir) = Dir) then Exit; // avoid 'xyz:\' problem.
	Result := ForceDirectoriesEx(ExtractFilePath(Dir)) and CreateDir(Dir);
end;

// Ƃ肠̑piȂ̂ chrWhite lĂȂƂɒӁIII
procedure ExtractHttpFields(
	const chrSep : TSysCharSet;
	const chrWhite : TSysCharSet;
	const strValue : string;
	var strResult : TStringList;
	unknownFlag : boolean = false
);
var
	last, p, strLen : Integer;
begin

	strLen := Length( strValue );
	p := 1;
	last := 1;

	while p <= strLen do
	begin

		if strValue[ p ] in chrSep then
		begin
			strResult.Add( Copy( strValue, last, p - last ) );
			last := p + 1;
		end;

		p := p + 1;

	end;

	if last <> p then
		strResult.Add( Copy( strValue, last, strLen - last + 1 ) );

end;


function HttpEncode(

	const strValue : string
) : string;
var
	i : Integer;
	strLen : Integer;
	strResult : string;
	b : Integer;
const
	kHexCode : array [0..15] of char = (
				'0', '1', '2', '3', '4', '5', '6', '7',
				'8', '9', 'A', 'B', 'C', 'D', 'E', 'F' );
begin

	strLen := Length( strValue );
	i := 1;

	while i <= strLen do
	begin

		case strValue[ i ] of
		'0' .. '9', 'a' .. 'z', 'A' .. 'Z', '*', '-', '.', '@', '_':
			begin
				strResult := strResult + strValue[ i ];
			end;
		else
			begin
				b := Integer( strValue[ i ] );
				strResult := strResult + '%'
								+ kHexCode[ b div $10 ]
								+ kHexCode[ b mod $10 ];
			end;
		end;

		i := i + 1;

	end;

	Result := strResult;

end;



// =========================================================================
// PlugIn
// =========================================================================

// *************************************************************************
// vOC̃o[Wvꂽ
// *************************************************************************
procedure OnVersionInfo(
	var outAgent		: PChar;	// o[W؊܂܂ȂȖ
	var outMajor		: DWORD;	// W[o[W
	var outMinor		: DWORD;	// }Ci[o[W
	var outRelease	: PChar;	// [XiK
	var outRevision	: DWORD		// rWio[
); stdcall;
begin

	try
		outAgent		:= CreateResultString( PChar( PLUGIN_NAME ) );
		outMajor		:= MAJOR_VERSION;
		outMinor		:= MINOR_VERSION;
		outRelease	:= CreateResultString( PChar( RELEASE_VERSION ) );
		outRevision	:= REVISION_VERSION;
	except
		outAgent		:= nil;
		outMajor		:= 0;
		outMinor		:= 0;
		outRelease	:= nil;
		outRevision	:= 0;
	end;

end;

// *************************************************************************
// w肵 URL ̃vOCŎ󂯕t邩ǂ
// *************************************************************************
function OnAcceptURL(
	inURL			: PChar				// fł URL
): TAcceptType; stdcall;	// URL ̎
var
	uri				: TIdURI;
	uriList		: TStringList;
	foundPos	: Integer;
const
	BBS_HOST		= 'machi.to';
	BBS_HOST2		= 'machibbs.com';    
	THREAD_MARK	= '/bbs/read.pl';
    THREAD_MARK2= '/bbs/read.cgi';
begin

	try
		// zXg machi.to ŏIꍇ͎󂯕t悤ɂĂ
		uri			:= TIdURI.Create( inURL );
		uriList	:= TStringList.Create;
		try
			ExtractHttpFields( ['/'], [], uri.Path, uriList );
			foundPos := AnsiPos( BBS_HOST, uri.Host );
			if (foundPos > 0) and (Length( uri.Host ) - foundPos + 1 = Length( BBS_HOST )) then begin
				foundPos := Pos( THREAD_MARK, inURL );
                if (foundPos = 0) then begin
                    // VURLΉ
                    foundPos := Pos( THREAD_MARK2, inURL );
                end;
				if foundPos > 0 then
					Result := atThread
				else if (uriList.Count > 1) and (uri.Path <> '/') then	// Ōオ '/' ŕ߂ĂȂ 3
					Result := atBoard
				else
					Result := atBBS;
			end else begin
                foundPos := AnsiPos( BBS_HOST2, uri.Host );
                if (foundPos > 0) and (Length( uri.Host ) - foundPos + 1 = Length( BBS_HOST2 )) then begin
                    foundPos := Pos( THREAD_MARK, inURL );
                    if (foundPos = 0) then begin
                        // VURLΉ
                        foundPos := Pos( THREAD_MARK2, inURL );
                    end;
                    if foundPos > 0 then
                        Result := atThread
                    else if (uriList.Count > 1) and (uri.Path <> '/') then	// Ōオ '/' ŕ߂ĂȂ 3
                        Result := atBoard
                    else
                        Result := atBBS;
                end else begin

                    Result := atNoAccept;
                end;
			end;
		finally
			uri.Free;
			uriList.Free;
		end;
	except
		Result := atNoAccept;
	end;

end;

// *************************************************************************
// w肵 URL BoardURLɕϊ
// *************************************************************************
procedure OnExtractBoardURL(
	inURL	: PChar;
	var outURL	: PChar
); stdcall;
var
	uri			: TIdURI;
	uriList		: TStringList;
	URL         : String;
const
	THREAD_MARK	= '/bbs/read.pl';
    THREAD_MARK2= '/bbs/read.cgi';
begin
	URL := string(inURL);
	if AnsiPos(THREAD_MARK, URL) > 0 then begin
		if Copy( inURL, Length( inURL ), 1 ) = '/' then
			uri := TIdURI.Create( URL )
		else
			uri := TIdURI.Create( URL + '/' );

		uriList := TStringList.Create;
		try
			ExtractHttpFields(
				['&'], [],
				Copy( uri.Params, AnsiPos( '?', uri.Params ) + 1, Length( uri.Params ) ),uriList );
			// http://hokkaido.machi.to/bbs/read.pl?BBS=hokkaidou&KEY=1061764446
			// http://hokkaido.machi.to/hokkaidou/
			URL := uri.Protocol + '://' + uri.Host + '/' + uriList.Values[ 'BBS' ] + '/';
			outURL := CreateResultString(URL);
		finally
			uri.Free;
			uriList.Free;
		end;
    end else if AnsiPos(THREAD_MARK2, URL) > 0 then begin
		if Copy( inURL, Length( inURL ), 1 ) = '/' then
			uri := TIdURI.Create( URL )
		else
			uri := TIdURI.Create( URL + '/' );

        uriList := TStringList.Create;
		try
			// http://kanto.machi.to/bbs/read.cgi/kana/1215253035/l50
			// http://kanto.machi.to/kana/
            uriList.Delimiter := '/';
            uriList.DelimitedText  := uri.Path;
			URL := uri.Protocol + '://' + uri.Host + '/';
            if (uriList.Count >= 4) then begin
                URL := URL + uriList[3] + '/';
            end;
			outURL := CreateResultString(URL);
		finally
			uri.Free;
            uriList.Free;
		end;
	end else begin
    	outURL := CreateResultString(URL);
	end;

end;


// =========================================================================
// TMachiBBSThreadItem
// =========================================================================

// *************************************************************************
// RXgN^
// *************************************************************************
constructor TMachiBBSThreadItem.Create(
	inInstance	: DWORD
);
var
	uri					: TIdURI;
	uriList			: TStringList;
	FilePath		: String;
begin

	inherited;

	OnDownload		:= Download;
	OnWrite				:= Write;
	OnGetRes			:= GetRes;
	OnGetDat			:= GetDat;
	OnGetHeader		:= GetHeader;
	OnGetFooter		:= GetFooter;
	OnGetBoardURL	:= GetBoardURL;

	//FFilePath			:= '';
	FIsTemporary	:= False;
	FDat					:= nil;
	URL						:= ReadURL + '&LAST=50';

	uri			:= TIdURI.Create( URL );
	uriList	:= TStringList.Create;
	try
		// http://hokkaido.machi.to/bbs/read.pl?BBS=hokkaidou&KEY=1061764446&LAST=50
		ExtractHttpFields(
			['&'], [],
			Copy( uri.Params, AnsiPos( '?', uri.Params ) + 1, Length( uri.Params ) ), uriList );
		FileName	:= uriList.Values[ 'KEY' ] + '.dat';
		FilePath	:= MyLogFolder + uriList.Values[ 'BBS' ] + '\' + uriList.Values[ 'KEY' ] + '.dat';
		IsLogFile	:= FileExists( FilePath );
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// fXgN^
// *************************************************************************
destructor TMachiBBSThreadItem.Destroy;
begin

	FreeDat;

	// ꎞt@C̏ꍇ͍폜
	if FIsTemporary then
		DeleteFile( FilePath );

	inherited;

end;

// *************************************************************************
// w肵 URL ̃Xbh̃_E[hwꂽ
// *************************************************************************
function TMachiBBSThreadItem.Download : TDownloadState;
var
	modified			: Double;
	tmp						: PChar;
	downResult		: TStringList;
	content				: TStringList;
	responseCode	: Longint;
	logStream			: TFileStream;
	uri						: TIdURI;
	uriList				: TStringList;
	datURL				: string;
	foundPos			: Integer;
	FilePath			: String;
	procedure	downAndParse;
	begin
		responseCode := InternalDownload( PChar( datURL ), modified, tmp, 0 );

		try
			if responseCode = 200 then begin
				downResult	:= TStringList.Create;
				try
					downResult.Text	:= string( tmp );

					// ^Cg̎擾
 					foundPos				:= AnsiPos( '<title>', downResult.Text ) + Length( '<title>' );
					Title						:= Copy(
						downResult.Text,
						foundPos,
						AnsiPos( '</title>', downResult.Text ) - foundPos );

					// X̊Jnʒu
					foundPos				:= AnsiPos( '<dt', downResult.Text );
					downResult.Text	:= Copy( downResult.Text, foundPos, Length( downResult.Text ) );
					if foundPos > 0 then begin
						// X̏Iʒu
						foundPos := AnsiPos( '<table', downResult.Text ) - 1;
						if foundPos > 0 then
							downResult.Text := Copy( downResult.Text, 1, foundPos );
						// ܂BBS dat ǂ݂oȂAcgi ȊOɍǂݍ݂̕@킯ł̂
						// f̂܂܂𖳗ɕۂƂƂ͂ 2ch  dat `ɕϊ̂ۑĂ܂
						To2chDat( downResult, Count + 1 );
						content.Text := content.Text + downResult.Text;
					end;
				finally
					downResult.Free;
				end;
			end else begin
				Result := dsNotModify;
				Exit;
			end;
		finally
			DisposeResultString( tmp );
		end;
	end;
begin

	Result := dsError;

	uri			:= TIdURI.Create( URL );
	uriList := TStringList.Create;
	content	:= TStringList.Create;
	try
		ExtractHttpFields(
			['&'], [],
			Copy( uri.Params, AnsiPos( '?', uri.Params ) + 1, Length( uri.Params ) ), uriList );
		FileName := uriList.Values[ 'KEY' ] + '.dat';
		if MyLogFolder = '' then begin
			// ǂɕۑĂ̂Ȃ̂ňꎞt@Cɕۑ
			FilePath 			:= TemporaryFile;
			FIsTemporary	:= True;
		end else begin
			FilePath	:= MyLogFolder + uriList.Values[ 'BBS' ] + '\' + uriList.Values[ 'KEY' ] + '.dat';
			FIsTemporary	:= False;
		end;

		// ۑp̃fBNg@
		ForceDirectoriesEx( Copy( FilePath, 1, LastDelimiter( '\', FilePath ) ) );

		// ƎɃ_E[htB^OsȂꍇ
		// InternalDownload ɔC邱Ƃo
		modified	:= LastModified;
		if Count = 0 then
			// 1`
			datURL		:=
				uri.Protocol + '://' + uri.Host + '/bbs/read.cgi?' +
				'BBS=' + uriList.Values[ 'BBS' ] + '&KEY=' + uriList.Values[ 'KEY' ] +
				'&START=' + IntToStr( 1 )
		else
			// V̂
			datURL		:=
				uri.Protocol + '://' + uri.Host + '/bbs/read.cgi?' +
				'BBS=' + uriList.Values[ 'BBS' ] + '&KEY=' + uriList.Values[ 'KEY' ] +
				'&START=' + IntToStr( Count + 1 ) + '&NOFIRST=TRUE';
		// _E[h
		downAndParse;

		if content.Count > 0 then begin
			if Count <= 0 then begin
				Result := dsComplete;
				// VK
				content[ 0 ]	:= content[ 0 ] + Title;
				logStream			:= TFileStream.Create( FilePath, fmCreate or fmShareDenyWrite );
				try
					logStream.Position	:= logStream.Size;
					logStream.Write( PChar( content.Text )^, Length( content.Text ) );
				finally
					logStream.Free;
				end;
				NewReceive	:= 1;
				Count				:= content.Count;
			end else begin
                if (content.Count > 1) or (Trim(content.Text) <> '') then begin
    				Result := dsDiffComplete;
                    // ǋL
                    logStream := TFileStream.Create( FilePath, fmOpenReadWrite or fmShareDenyWrite );
                    try
                        logStream.Position	:= logStream.Size;
                        logStream.Write( PChar( content.Text )^, Length( content.Text ) );
                    finally
                        logStream.Free;
                    end;
                    NewReceive	:= Count + 1;
                    Count				:= Count + content.Count;
                end else begin
                    Result := dsNotModify;
                end;
			end;
            if (Result <> dsNotModify) then begin
    			// CGI ͐tȂ̂Ō݂ɐݒ
	    		LastModified	:= Now;
		    	NewResCount		:= content.Count;
            end;
		end else begin
			Result := dsNotModify;
		end;
	finally
		uri.Free;
		uriList.Free;
		content.Free;
	end;

end;

// *************************************************************************
// ݂wꂽ
// *************************************************************************
function	TMachiBBSThreadItem.Write(
	inName				: string;	// O(nh)
	inMail				: string;	// [AhX
	inMessage			: string	// {
) : TDownloadState;				// ݂ǂ
var
	postURL				: string;
	postData			: string;
	postResult		: PChar;
	uri						: TIdURI;
	uriList				: TStringList;
begin

	uri			:= TIdURI.Create( URL );
	uriList	:= TStringList.Create;
	try
		ExtractHttpFields(
			['&'], [],
			Copy( uri.Params, AnsiPos( '?', uri.Params ) + 1, Length( uri.Params ) ), uriList );

		postURL		:= uri.Protocol + '://' + uri.Host + '/bbs/write.cgi';
		postData	:=
			'NAME='			+ HttpEncode( inName ) +
			'&MAIL='		+ HttpEncode( inMail ) +
			'&MESSAGE='	+ HttpEncode( inMessage ) +
			'&BBS='			+ uriList.Values[ 'BBS' ] +
			'&KEY='			+ uriList.Values[ 'KEY' ] +
			'&TIME='		+ IntToStr( DateTimeToUnix( Now ) ) +
			'&submit='	+ HttpEncode( '' );

		// ƎɒʐMȂꍇ InternalPost ɔC邱Ƃo
		InternalPost( PChar( postURL ), PChar( postData ),PChar(URL), postResult );
		DisposeResultString( postResult );

		Result := dsComplete
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// Xԍ inNo ɑ΂ html vꂽ
// *************************************************************************
function TMachiBBSThreadItem.GetRes(
	inNo		: Integer		// vꂽXԍ
) : string;						// Ή HTML
var
	res		 	: string;
	tmp			: PChar;
begin

	// ƎɃtB^OsȂꍇ
	// InternalAbon  Dat2HTML ɔC邱Ƃo
	LoadDat;
	if (FDat = nil) or (inNo - 1 < 0 ) or (inNo - 1 >= FDat.Count) then begin
		// Oɑ݂Ȃ̂ł̂܂܏I
		Result := '';
		Exit;
	end;
	res			:= FDat[ inNo - 1 ];
	tmp			:= InternalAbonForOne( PChar( res ), PChar(FilePath), inNo);
    try
		Result	:= Dat2HTML( string( tmp ), inNo );
	finally
		DisposeResultString( tmp );
	end;

end;

// *************************************************************************
// Xԍ inNo ɑ΂ Dat vꂽ
// *************************************************************************
function TMachiBBSThreadItem.GetDat(
	inNo		: Integer		// vꂽXԍ
) : string;						// Q˂Dat`
var
	//res: string;
	tmp: PChar;
begin
	//Result	:= '';
	// ƎɃtB^OsȂꍇ
	LoadDat;
	if (FDat = nil) or (inNo - 1 < 0 ) or (inNo - 1 >= FDat.Count)  then begin
		// Oɑ݂Ȃ̂ł̂܂܏I
		tmp := CreateResultString('');
		Result := tmp;
		DisposeResultString(tmp);
		Exit;
	end;
	tmp := CreateResultString(FDat[ inNo - 1]);
	try
		Result := string(tmp);
	finally
		DisposeResultString(tmp);
	end;

end;

// *************************************************************************
// Xbh̃wb_ html vꂽ
// *************************************************************************
function TMachiBBSThreadItem.GetHeader(
	inOptionalHeader	: string
) : string;
begin

	// ƎɃtB^OsȂꍇ
	// InternalHeader ɔC邱Ƃo
	Result := InternalHeader(
		'<meta http-equiv="Content-type" content="text/html; charset=Shift_JIS">' +
		inOptionalHeader );


	// GetRes Ă΂邱Ƃ\ẑ FDat 𐶐Ă
	try
		FreeDat;
		LoadDat;
	except
	end;

end;

// *************************************************************************
// Xbh̃tb^ html vꂽ
// *************************************************************************
function TMachiBBSThreadItem.GetFooter(
	inOptionalFooter : string
) : string;
begin

	// ƎɃtB^OsȂꍇ
	// InternalFooter ɔC邱Ƃo
	Result := InternalFooter( inOptionalFooter );

	//  GetRes ͌Ă΂ȂƎv̂ FDat JĂ
	try
		FreeDat;
	except
	end;

end;

// *************************************************************************
//  ThreadItem  URL vꂽ
// *************************************************************************
function	TMachiBBSThreadItem.GetBoardURL : string;
var
	uri						: TIdURI;
	uriList				: TStringList;
	tmp: PChar;
begin
    tmp := nil;
	if Copy( URL, Length( URL ), 1 ) = '/' then
		uri := TIdURI.Create( URL )
	else
		uri := TIdURI.Create( URL + '/' );
	uriList := TStringList.Create;
	try
		ExtractHttpFields(
			['&'], [],
			Copy( uri.Params, AnsiPos( '?', uri.Params ) + 1, Length( uri.Params ) ), uriList );
		FileName := uriList.Values[ 'KEY' ] + '.dat';
		// http://hokkaido.machi.to/bbs/read.pl?BBS=hokkaidou&KEY=1061764446
		// http://hokkaido.machi.to/hokkaidou/
		tmp		:= CreateResultString(
			uri.Protocol + '://' + uri.Host + '/' + uriList.Values[ 'BBS' ] + '/' );
		Result := string(tmp);
	finally
		DisposeResultString(tmp);
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// ܂BBS HTML  2ch  dat `
// *************************************************************************
procedure	TMachiBBSThreadItem.To2chDat(
	ioHTML				: TStringList;
	inStartNo			: Integer = 1
);
var
	i, bound			: Integer;
	foundPos,foundPos2			: Integer;
	strTmp				: string;
	res						: TStringList;
	no						: Integer;
const
	MAIL_TAG			= '<a href="mailto:';
begin

	//===== 2ch  dat `ɕϊ
	// zXǧŉsĂ肷̂ŉsׂĎ菜
	ioHTML.Text	:= CustomStringReplace( ioHTML.Text, #13#10, '');
	//StringReplace( ioHTML.Text, #13#10, '', [rfReplaceAll] );
	//  <dt> s̋؂ɂ
	ioHTML.Text	:= CustomStringReplace( ioHTML.Text, '<dt>', #10 );
	//StringReplace( ioHTML.Text, '<dt>', #10, [rfReplaceAll] );
	// <dt> n܂Ă̂ōŏ͋̂͂
	if Length( ioHTML[ 0 ] ) = 0 then
		ioHTML.Delete( 0 );

	// yځ[`FbN
	// Gc炿ƏoĂȂ
	try
		i			:= 0;
		while i < ioHTML.Count do begin
			foundPos := AnsiPos( ' ', ioHTML[ i ] );
			if foundPos > 0 then begin
				no := StrToInt( Copy( ioHTML[ i ], 1, foundPos - 1 ) );
				if inStartNo < no then
					ioHTML.Insert( i, '<><><><>' );
			end;
			Inc( i );
			Inc( inStartNo );
		end;
	except
		// ځ[`FbNŖ肪Ă֐i߂̂
	end;


	// gbv̌ '<b> </b>' 
    if AnsiPos('</b>', ioHTML.Text) <> 0 then begin
    	ioHTML.Text	:= CustomStringReplace( ioHTML.Text, '<b> </b></font>', '</b></font>', true );
        ioHTML.Text	:= CustomStringReplace( ioHTML.Text, '<b> </B></a>', '</b></a>', true );
    end;
	//ioHTML.Text	:= CustomStringReplace( ioHTML.Text, '<b> </b>', '', true );
	//StringReplace( ioHTML.Text, '<b> </b>', '', [rfReplaceAll, rfIgnoreCase] );
	// '<b>' ̓[ƖŐ؂
	ioHTML.Text	:= CustomStringReplace( ioHTML.Text, '<b>', '<>', true );
	//StringReplace( ioHTML.Text, '<b>', '<>', [rfReplaceAll, rfIgnoreCase] );
	// [ƖOɂĂ^O𓊍eƂ̋؂
	ioHTML.Text	:= CustomStringReplace( ioHTML.Text, '</b></a>', '<>', true );
	//StringReplace( ioHTML.Text, '</b></a>', '<>', [rfReplaceAll, rfIgnoreCase] );
	ioHTML.Text	:= CustomStringReplace( ioHTML.Text, '</b>', '<>', true );
    ioHTML.Text	:= CustomStringReplace( ioHTML.Text, '<>', '</b>', true );
	//StringReplace( ioHTML.Text, '</b>', '<>', [rfReplaceAll, rfIgnoreCase] );
	// '<dd>' {Ƃ̋؂
	ioHTML.Text	:= CustomStringReplace( ioHTML.Text, '<dd>', '<>', true );
	//StringReplace( ioHTML.Text, '<dd>', '<>', [rfReplaceAll, rfIgnoreCase] );

	res := TStringList.Create;
	try
		bound := ioHTML.Count - 1;
		for i := 0 to bound do begin
            // XNvg܂܂Ă폜iL΍j
			res.Text := CustomStringReplace( ioHTML[ i ], '<>', #10 );
						//StringReplace( ioHTML[ i ], '<>', #10, [rfReplaceAll] );
			if res.Count >= 3 then begin	// 3 ͂肦ȂƎvǈŜ
				foundPos := AnsiPos( MAIL_TAG, res[ 0 ] );
				if foundPos > 0 then begin
					// [AhX𔲂o
					foundPos	:= foundPos + Length( MAIL_TAG );
					res[ 0 ]	:= Copy( res[ 0 ], foundPos, Length( res[ 0 ] ) );
					strTmp		:= Copy( res[ 0 ], 1, AnsiPos( '">', res[ 0 ] ) - 1 );
					// [ƖOtȂ̂łЂԂĖ߂
					res[ 0 ]	:= res[ 1 ];
					res[ 1 ]	:= strTmp;
				end else begin
					// [ƖOtȂ̂łЂԂ
					res[ 0 ]	:= res[ 1 ];
					res[ 1 ]	:= '';
				end;
				res[ 2 ] := StringReplace( res[ 2 ], '[', 'IP:', [] );
				res[ 2 ] := StringReplace( res[ 2 ], ']', '', [] );

                if AnsiPos('</font> eF', res[ 2 ]) = 1 then begin
                	res[ 2 ] := StringReplace( res[ 2 ], '</font> eF', '', [] );
                end else if AnsiPos(' eF', res[ 2 ]) = 1 then begin
                    res[ 2 ] := StringReplace( res[ 2 ], ' eF', '', [] );
                end;
			end;
			ioHTML[ i ] := CustomStringReplace( res.Text, #13#10, '<>');
            // LXNvg΍
            foundPos := Pos( '<script', ioHTML[ i ] );
            if foundPos > 0 then begin
                foundPos2 := Pos( '</script>', ioHTML[ i ] );
                if (foundPos2 > foundPos) then begin
                    ioHTML[ i ] := Copy(ioHTML[ i ], 1, foundPos-1) +
                                   Copy(ioHTML[ i ], foundPos2 + 9, Length(ioHTML[ i ]));
                end;
            end;
		end;
	finally
		res.Free;
	end;

end;

// *************************************************************************
// FDat ̐
// *************************************************************************
procedure	TMachiBBSThreadItem.LoadDat;
begin

	if FDat = nil then begin
		if IsLogFile then begin
			// dat ̓ǂݍ
			FDat := TStringList.Create;
			FDat.LoadFromFile( FilePath );
		end;
	end;

end;

// *************************************************************************
// FDat ̊J
// *************************************************************************
procedure	TMachiBBSThreadItem.FreeDat;
begin

	if FDat <> nil then begin
		FDat.Free;
		FDat := nil;
	end;

end;

// *************************************************************************
// S( '/' ŏI )ǂݍ݂ URL
// *************************************************************************
function	TMachiBBSThreadItem.ReadURL : string;
var
	uri				: TIdURI;
	uriList		: TStringList;
	foundPos	: Integer;
const
    THREAD_MARK2= '/bbs/read.cgi';
begin

	foundPos := AnsiPos( '?', URL );
	if foundPos > 0 then begin
		uri := TIdURI.Create( URL );
		uriList := TStringList.Create;
		try
			ExtractHttpFields( ['&'], [], Copy( URL, foundPos + 1, MaxInt ), uriList );
			Result :=
				uri.Protocol + '://' + uri.Host + '/bbs/read.pl?' +
				'BBS=' + uriList.Values[ 'BBS' ] + '&KEY=' + uriList.Values[ 'KEY' ];
		finally
			uri.Free;
			uriList.Free;
		end;
	end else begin
        // V` ?
        foundPos := AnsiPos(THREAD_MARK2, URL);
    	if (foundPos > 0) then begin
            uri := TIdURI.Create( URL );
            uriList := TStringList.Create;
            try
                uriList.Delimiter := '/';
                uriList.DelimitedText  := uri.Path;
                if (uriList.Count >= 5) then begin
    			    Result :=
	    			    uri.Protocol + '://' + uri.Host + '/bbs/read.pl?' +
		    		    'BBS=' + uriList[3] + '&KEY=' + uriList[4];
                end;
            finally
    			uri.Free;
	    		uriList.Free;
            end;
        end;
    end;

end;

// *************************************************************************
// TThreadItem ꂽꍇ̏u(TMachiBBSThreadItem 𐶐)
// *************************************************************************
procedure ThreadItemOnCreateOfTMachiBBSThreadItem(
	inInstance : DWORD
);
var
	threadItem : TMachiBBSThreadItem;
begin

	threadItem := TMachiBBSThreadItem.Create( inInstance );
	ThreadItemSetLong( inInstance, tipContext, DWORD( threadItem ) );

end;

// *************************************************************************
// TThreadItem jꂽꍇ̏u(TMachiBBSThreadItem j)
// *************************************************************************
procedure ThreadItemOnDisposeOfTMachiBBSThreadItem(
	inInstance : DWORD
);
var
	threadItem : TMachiBBSThreadItem;
begin

	threadItem := TMachiBBSThreadItem( ThreadItemGetLong( inInstance, tipContext ) );
	threadItem.Free;

end;

// =========================================================================
// TMachiBBSBoardItem
// =========================================================================

// *************************************************************************
// RXgN^
// *************************************************************************
constructor TMachiBBSBoardItem.Create(
	inInstance	: DWORD
);
var
	uri					: TIdURI;
	uriList			: TStringList;
begin

	inherited;

	OnDownload						:= Download;
	OnCreateThread				:= CreateThread;
	OnEnumThread					:= EnumThread;
	OnFileName2ThreadURL	:= ToThreadURL;

	FilePath			:= '';
	FIsTemporary	:= False;
	FDat					:= nil;
    Is2ch			:= False;

	uri			:= TIdURI.Create( SubjectURL );
	uriList	:= TStringList.Create;
	try
		ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
		// http://hokkaido.machi.to/hokkaidou/subject.txt
		FilePath	:= MyLogFolder + uriList[ 1 ] + '\' + uri.Document;
		IsLogFile	:= FileExists( FilePath );
	finally
		uri.Free;
		uriList.Free;
	end;

end;
 
// *************************************************************************
// fXgN^
// *************************************************************************
destructor TMachiBBSBoardItem.Destroy;
begin

	if FDat <> nil then begin
		try
			FDat.Free;
			FDat := nil;
		except
		end;
	end;

	// ꎞt@C̏ꍇ͍폜
	if FIsTemporary then
		DeleteFile( FilePath );

	inherited;

end;

// *************************************************************************
// w肵Xꗗ̃_E[hvꂽ
// *************************************************************************
function TMachiBBSBoardItem.Download : TDownloadState;
var
	modified			: Double;
	downResult		: PChar;
	responseCode	: Longint;
	uri						: TIdURI;
	uriList				: TStringList;
begin

	Result := dsError;

	if FDat <> nil then begin
		try
			FDat.Free;
			FDat := nil;
		except
		end;
	end;
	FDat		:= TStringList.Create;
	uri			:= TIdURI.Create( SubjectURL );
	uriList	:= TStringList.Create;
	// ƎɃ_E[htB^OsȂꍇ
	// InternalDownload ɔC邱Ƃo
	modified			:= LastModified;
	responseCode	:= InternalDownload( PChar( uri.URI ), modified, downResult );
	try
		if responseCode = 200 then begin
			try
				// pXZo
				ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
				if MyLogFolder = '' then begin
					// ǂɕۑĂ̂Ȃ̂ňꎞt@Cɕۑ
					FilePath 			:= TemporaryFile;
					FIsTemporary	:= True;
				end else begin
					FilePath			:= MyLogFolder + uriList[ 1 ] + '\' + uri.Document;
					FIsTemporary	:= False
				end;

				// ۑp̃fBNg@
				ForceDirectoriesEx( Copy( FilePath, 1, LastDelimiter( '\', FilePath ) ) );

				FDat.Text := string( downResult );
				// ۑ
				FDat.SaveToFile( FilePath );

				IsLogFile			:= True;
				RoundDate			:= Now;
				LastModified	:= modified;
				LastGetTime		:= Now;
			finally
				uri.Free;
				uriList.Free;
			end;
			Result := dsComplete;
		end;
	finally
		DisposeResultString( downResult );
	end;

end;

// *************************************************************************
// XĂwꂽ
// *************************************************************************
function	TMachiBBSBoardItem.CreateThread(
	inSubject			: string;	// X^C
	inName				: string;	// O(nh)
	inMail				: string;	// [AhX
	inMessage			: string	// {
) : TDownloadState;				// ݂ǂ
var
	postURL				: string;
	postData			: string;
	postResult		: PChar;
	uri						: TIdURI;
	uriList				: TStringList;
begin

	uri			:= TIdURI.Create( URL );
	uriList	:= TStringList.Create;
	try
		ExtractHttpFields(
			['&'], [],
			Copy( uri.Params, AnsiPos( '?', uri.Params ) + 1, Length( uri.Params ) ), uriList );

		postURL		:= uri.Protocol + '://' + uri.Host + '/bbs/write.cgi';
		postData	:=
			'SUBJECT='	+ HttpEncode( inSubject ) +
			'&NAME='		+ HttpEncode( inName ) +
			'&MAIL='		+ HttpEncode( inMail ) +
			'&MESSAGE='	+ HttpEncode( inMessage ) +
			'&BBS='			+ uriList[ 1 ] +
			'&TIME='		+ IntToStr( DateTimeToUnix( Now ) ) +
			'&submit='	+ HttpEncode( 'VK' );

		// ƎɒʐMȂꍇ InternalPost ɔC邱Ƃo
		InternalPost( PChar( postURL ), PChar( postData ),PChar(URL), postResult );
		DisposeResultString( postResult );

		Result := dsComplete
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// Xꗗ URL Xbh URL 𓱂o
// *************************************************************************
function TMachiBBSBoardItem.ToThreadURL(
	inFileName	: string	// Xbht@C
) : string;							// Xbh URL
var
	threadURL		: string;
	uri					: TIdURI;
	uriList			: TStringList;
	found				: Integer;
begin

	found := AnsiPos( '.', inFileName );
	if found > 0 then
		inFileName := Copy( inFileName, 1, found - 1 );

	uri			:= TIdURI.Create( SubjectURL );
	uriList	:= TStringList.Create;
	try
		try
			// http://hokkaido.machi.to/hokkaidou/
			// http://hokkaido.machi.to/bbs/read.pl?BBS=hokkaidou&KEY=1061764446&LAST=50
			ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
			threadURL	:= uri.Protocol + '://' + uri.Host + '/bbs/read.pl?' +
				'BBS=' + uriList[ 1 ] + '&KEY=' + inFileName + '&LAST=50';
			Result		:= threadURL;
		finally
			uri.Free;
			uriList.Free;
		end;
	except
		Result := '';
	end;

end;

// *************************************************************************
// ̔ɂ̃X邩vꂽ
// *************************************************************************
procedure	TMachiBBSBoardItem.EnumThread(
	inCallBack	: TBoardItemEnumThreadCallBack
);
var
	uri		 			: TIdURI;
	uriList			: TStringList;
begin

	try
		if FDat = nil then begin
			FDat := TStringList.Create;

			uri			:= TIdURI.Create( SubjectURL );
			uriList	:= TStringList.Create;
			try
				// pXZo
				ExtractHttpFields( ['/', '?'], [], uri.Path, uriList );
				// http://hokkaido.machi.to/hokkaidou/subject.txt
				FilePath	:= MyLogFolder + uriList[ 1 ] + '\' + uri.Document;
				if FileExists( FilePath ) then
					// ǂݍ
					FDat.LoadFromFile( FilePath );
			finally
				uri.Free;
				uriList.Free;
			end;
		end;

		// ƎɃtB^OsȂꍇ EnumThread ɔC邱Ƃo
		inherited EnumThread( inCallBack, CustomStringReplace( FDat.Text, ',', '<>' ) );
	except
	end;

end;

// *************************************************************************
// Xꗗ URL ߂
// *************************************************************************
function	TMachiBBSBoardItem.SubjectURL : string;
var
	uri		 	: TIdURI;
	uriList	: TStringList;
begin

	uri			:= TIdURI.Create( URL );
	uriList	:= TStringList.Create;
	try
		if uri.Document <> SUBJECT_NAME then begin
			if Copy( URL, Length( URL ), 1 ) = '/' then
				Result := URL + SUBJECT_NAME
			else
				Result := URL + '/' + SUBJECT_NAME;
		end else begin
			// ɂ͗ȂƎv
			Result := URL;
		end;
	finally
		uri.Free;
		uriList.Free;
	end;

end;

// *************************************************************************
// TBoardItem ꂽꍇ̏u(TMachiBBSBoardItem 𐶐)
// *************************************************************************
procedure BoardItemOnCreateOfTMachiBBSBoardItem(
	inInstance : DWORD
);
var
	boardItem : TMachiBBSBoardItem;
begin

	boardItem := TMachiBBSBoardItem.Create( inInstance );
	BoardItemSetLong( inInstance, bipContext, DWORD( boardItem ) );

end;

// *************************************************************************
// TBoardItem jꂽꍇ̏u(TMachiBBSBoardItem j)
// *************************************************************************
procedure BoardItemOnDisposeOfTMachiBBSBoardItem(
	inInstance : DWORD
);
var
	boardItem : TMachiBBSBoardItem;
begin

	boardItem := TMachiBBSBoardItem( BoardItemGetLong( inInstance, bipContext ) );
	boardItem.Free;

end;



// =========================================================================
// Gg|Cg
// =========================================================================
procedure DLLEntry(
	ul_reason_for_call : DWORD
);
var
	module : HMODULE;
begin

	case ul_reason_for_call of
		DLL_PROCESS_ATTACH:
		begin
			Randomize;

			module := GetModuleHandle( nil );

			LoadInternalAPI( module );
			LoadInternalFilePathAPI( module );
			LoadInternalThreadItemAPI( module );
			LoadInternalBoardItemAPI( module );

			// ===== CX^X̎舵 TThreadItem  TMachiBBSThreadItem ɕύX
			ThreadItemOnCreate	:= ThreadItemOnCreateOfTMachiBBSThreadItem;
			ThreadItemOnDispose	:= ThreadItemOnDisposeOfTMachiBBSThreadItem;
			// ===== CX^X̎舵 TBoardItem  TMachiBBSBoardItem ɕύX
			BoardItemOnCreate		:= BoardItemOnCreateOfTMachiBBSBoardItem;
			BoardItemOnDispose	:= BoardItemOnDisposeOfTMachiBBSBoardItem;
		end;
		DLL_PROCESS_DETACH:
			;
		DLL_THREAD_ATTACH:
			;
		DLL_THREAD_DETACH:
			;
	end;

end;

exports
	OnVersionInfo,
	OnAcceptURL,
    OnExtractBoardURL;
begin

	try
		DllProc := @DLLEntry;
		DLLEntry( DLL_PROCESS_ATTACH );
	except end;

end.
