unit ShitarabaJBBSAcquireBoard;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TShitarabaJBBSAcquireBoardDialog = class(TForm)
	CategoryLabel: TLabel;
	CategoryComboBox: TComboBox;
	BoardNameLabel: TLabel;
	BoardNameEdit: TEdit;
	AcquireButton: TButton;
	SaveButton: TButton;
	LogEdit: TMemo;
	SaveCategoryLabel: TLabel;
	SaveCategoryComboBox: TComboBox;
	procedure SaveButtonClick(Sender: TObject);
	procedure AcquireButtonClick(Sender: TObject);
	private
		{ Private 錾 }
		FBoardList		: TStringList;	//!< 擾ς݂̔Xg
	public
		{ Public 錾 }
		constructor Create( AOwner : TComponent ); override;
		destructor Destroy; override;
	end;

var
  ShitarabaJBBSAcquireBoardDialog: TShitarabaJBBSAcquireBoardDialog;

implementation

uses Math, IniFiles,
	PlugInMain, FilePath, Y_TextConverter, MojuUtils;

const
	SYNCRONIZE_MENU_CAPTION	= 'JBBSXV';

{$R *.dfm}

function HttpEncode(

	const strValue : string
) : string;
var
	i : Integer;
	strLen : Integer;
	strResult : string;
	b : Integer;
const
	kHexCode : array [0..15] of char = (
				'0', '1', '2', '3', '4', '5', '6', '7',
				'8', '9', 'A', 'B', 'C', 'D', 'E', 'F' );
begin

	strLen := Length( strValue );
	i := 1;

	while i <= strLen do
	begin

		case strValue[ i ] of
		'0' .. '9', 'a' .. 'z', 'A' .. 'Z', '*', '-', '.', '@', '_':
			begin
				strResult := strResult + strValue[ i ];
			end;
		else
			begin
				b := Integer( strValue[ i ] );
				strResult := strResult + '%'
								+ kHexCode[ b div $10 ]
								+ kHexCode[ b mod $10 ];
			end;
		end;

		i := i + 1;

	end;

	Result := strResult;

end;

function BoardFileName : string;
var
	savepath			: string;
	success				: Boolean;
	initdir				: string;
	filter				: string;

	agent					: PChar;
	major					: DWORD;
	minor					: DWORD;
	release				: PChar;
	revision			: DWORD;
const
	SAVEPATH_SELECT	= 'ۑt@C͂Ă';
	BOARD_FILE_NAME = 'JBBS';
begin

	VersionInfo( agent, major, minor, release, revision );
	try
		initdir	:= PreferencesFolder;
		if agent = 'gikoNavi' then begin
			savepath := initdir + 'Board\' + BOARD_FILE_NAME + '.txt';
		end else begin
			filter	:= 'Ẵׂt@C (*.*)|*.*';
			savepath := BOARD_FILE_NAME;
			success	:= PromptForFileName(
				savepath, filter, 'txt', SYNCRONIZE_MENU_CAPTION, initdir, True );
		end;
	finally
		DisposeResultString( agent );
		DisposeResultString( release );
	end;

	Result := savepath;

end;

constructor TShitarabaJBBSAcquireBoardDialog.Create( AOwner : TComponent );
var
	ini							: TMemIniFile;
	saveCategories	: TStringList;
	i								: Integer;
begin

	inherited;

	FBoardList := TStringList.Create;
	FBoardList.Duplicates := dupIgnore;


	ini := TMemIniFile.Create( BoardFileName );
	saveCategories := TStringList.Create;
	try
		ini.ReadSections( saveCategories );
		for i := 0 to saveCategories.Count - 1 do
			SaveCategoryComboBox.AddItem( saveCategories[ i ], nil );
		SaveCategoryComboBox.ItemIndex := 0;
	finally
		saveCategories.Free;
		ini.Free;
	end;

end;

destructor TShitarabaJBBSAcquireBoardDialog.Destroy;
begin

	FBoardList.Free;

	inherited;

end;

procedure TShitarabaJBBSAcquireBoardDialog.SaveButtonClick(
  Sender: TObject);
var
	ini						: TMemIniFile;
	i							: Integer;
	name					: string;
	saveCategory	: string;
begin

	saveCategory := SaveCategoryComboBox.Text;
	if saveCategory = '' then
		saveCategory := CategoryComboBox.Text;
	ini := TMemIniFile.Create( BoardFileName );
	try
		ini.CaseSensitive := False;
		for i := 0 to FBoardList.Count - 1 do begin
			name := FBoardList.Names[ i ];
			ini.WriteString( saveCategory, name, FBoardList.Values[ name ] );
		end;
		ini.UpdateFile;
	finally
		ini.Free;
	end;

	Close;

end;

procedure TShitarabaJBBSAcquireBoardDialog.AcquireButtonClick(
  Sender: TObject);
var
	boardName				: string;
	category				: string;

	url							: string;
	modified	 			: Double;
	tmp							: PChar;
	downResult			: string;
	responseCode		: Longint;

	board						: string;

	key							: string;
	htmlList					: TStringList;
	i							: Integer;

    resultArea                  : Boolean;
    pos                         : Integer;
const
    //http://rentalbbs.livedoor.com/jbbs/search/?word=%C2%E7%B3%D8&category=auto
	BBS_HOST	 			= 'http://rentalbbs.livedoor.com/';
    BOARD_HOST              = 'http://jbbs.livedoor.jp/';
	CATEGORIES : array[0..14]	of string = (
		'auto', 'computer', 'game', 'movie', 'music', 'shop', 'sports', 'travel',
		'business', 'study', 'news', 'otaku', 'anime', 'comic', 'school' );
    MSG_CONTENTAREA  = '<!--contents_area-->';
label
	NextBoard;
begin
    responseCode := 0;
	category := CATEGORIES[ CategoryComboBox.ItemIndex ];
	boardname := BoardNameEdit.Text;

	LogEdit.SelLength := 0;
	LogEdit.SelStart := Length( LogEdit.Text );
	LogEdit.SelText :=
		'擾ł( "' + category + '", "' + boardname + '" )' + #13#10;
	try
		url :=
			BBS_HOST + 'jbbs/search/?CATEGORY=' + category +
			'&WORD=' + HttpEncode( SJIStoEUC( boardname ) );

		responseCode := InternalDownload( PChar( url ), modified, tmp );
		try
			if (responseCode = 200) or (responseCode = 206) then begin
				downResult := EUCtoSJIS( tmp );
                if (AnsiPos(MSG_CONTENTAREA, downResult) > 0) then begin
                    downResult := Copy(downResult,
                                    AnsiPos(MSG_CONTENTAREA, downResult) + Length(MSG_CONTENTAREA),
                                    Length(downResult));
                end;
				htmlList := TStringList.Create();
				try
					htmlList.Text	:= CustomStringReplace(downResult, '<br>', #13#10);
                    resultArea := False;
					for i := 0 to htmlList.Count - 1 do begin
						downResult := htmlList[i];
						try
                            //<div class="searchResults">
                            //<h2><span class="ranking">[1]</span><a href="http://jbbs.livedoor.jp/auto/5497/">MIT-MCC BBS</a><span class="point"><span class="all">4750pt</span><span class="yesterday">(Yesterday40 pt)</span></span></h2>
                            //<p>HƑw@[^TCNBBSłBe`FbN悤ɂ܂傤(&amp;gt;_&amp;lt;)b</p>
                            //</div>
                            if (not resultArea) and (AnsiPos('class="searchResults"', downResult) > 0) then begin
                                resultArea := True;
                            end else if (resultArea) then begin
                                pos := AnsiPos('<a href="', downResult);
                                if (pos > 0) then begin
                                    resultArea := False;
                                    downResult := Copy(downResult, pos + 9, Length(downResult));
                                    key := Copy(downResult, 1, AnsiPos('"', downResult)-1);
                                    downResult := Copy(downResult, AnsiPos('>', downResult) + 1, Length(downResult));

                                    board	  := Copy(downResult, 1, AnsiPos('</a>', downResult) -1);

                                    board	:=  CustomStringReplace(board, '=', '') + '=' + key;
                                    LogEdit.SelText := board + #13#10;
                                    FBoardList.Add( board );
                                end;
							end;
						except
						end;
					end;
				finally
					htmlList.free;
				end;
			end else begin
				LogEdit.SelText :=
					'̎擾Ɏs܂(' +
					IntToStr( responseCode ) + ')' + #13#10;
			end;
		finally
			DisposeResultString( tmp );
		end;
		LogEdit.SelText := '擾' + #13#10;
		SaveButton.Enabled := True;
	except
		LogEdit.SelText :=
			'̎擾Ɏs܂(' + IntToStr( responseCode ) + ')' + #13#10;
	end;

end;

end.
