unit HTMLCreate;

interface

uses
	Windows, Messages, SysUtils, Classes, {Graphics,} Controls, {Forms,}
	ComCtrls, IniFiles, ShellAPI, Math, GikoSystem, ActiveX,
{$IF Defined(DELPRO) }
	SHDocVw,
	MSHTML,
{$ELSE}
	SHDocVw_TLB,
	MSHTML_TLB,
{$IFEND}
	{HttpApp,} YofUtils, {URLMon,} BoardGroup, {gzip,} {Dolib,}
	{bmRegExp,} AbonUnit,	MojuUtils, Setting,
	ExternalBoardManager, ExternalBoardPlugInMain{,}
	{Sort,} ,GikoBayesian;

type
	THTMLCreate = class(TObject)
	private
		{ Private 錾 }
		anchorLen			: Integer;
		pURLCHARs,pURLCHARe : PChar;
		pANCHORs, pANCHORe  : PChar;
		pCTAGLs,  pCTAGLe   : PChar;
		pCTAGUs,  pCTAGUe   : PChar;
		pREF_MARKSs : array[0..9] of PChar;
		pREF_MARKSe : array[0..9] of PChar;
		constructor Create;

		function AddBeProfileLink(AID : string; ANum: Integer):string ;
		procedure CreateUsePluginHTML(html: TStringList; ThreadItem: TThreadItem; var sTitle: string);
		procedure CreateUseSKINHTML(html: TStringList; ThreadItem: TThreadItem; ReadList: TStringList);
		procedure CreateUseCSSHTML(html: TStringList; ThreadItem: TThreadItem; ReadList: TStringList; sTitle: string );
		procedure CreateDefaultHTML (html: TStringList; ThreadItem: TThreadItem; ReadList: TStringList; sTitle: string );
		function ConvertResAnchor(res: string): string;
		procedure separateNumber(var st: String; var et: String; const Text, Separator: String);
	public
		{ Public 錾 }
		function AddAnchorTag(s: string): string;
		function LoadFromSkin(fileName: string; ThreadItem: TThreadItem; SizeByte: Integer): string;
		function SkinedRes(skin: string; Res: TResRec; No: string): string;
		function ConvRes(const Body, Bbs, Key,	ParamBBS, ParamKey, ParamStart, ParamTo, ParamNoFirst, ParamTrue : string; DatToHTML: boolean = false): string; overload;
		procedure CreateHTML2(doc: IDispatch; ThreadItem: TThreadItem; var sTitle: string);
		procedure CreateHTML3(var html: TStringList; ThreadItem: TThreadItem; var sTitle: string);
	end;

var
	HTMLCreater: THTMLCreate;

implementation

const
	URL_CHAR: string = '0123456789'
									 + 'abcdefghijklmnopqrstuvwxyz'
									 + 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
									 + '#$%&()*+,-./:;=?@[]^_`{|}~!''\';
	ANCHOR_REF	= 'href=';
	CLOSE_TAGAL = '</a>';
	CLOSE_TAGAU = '</A>';
	RES_REF			= '&gt;&gt;';
	REF_MARK: array[0..9] of string = ('http://', 'ttp://', 'tp://',
									 'ms-help://','p://', 'https://',
									 'www.', 'ftp://','news://','rtsp://');

constructor THTMLCreate.Create;
var
	j : Integer;
begin
	// + 3  'href="' ('"')Ȃǂ̃oG[Vɗ]T邽
	anchorLen := Length( ANCHOR_REF ) + 3;
	pANCHORs  := PChar(ANCHOR_REF);
	pANCHORe  := pANCHORs + Length(ANCHOR_REF);
	pURLCHARs := PChar(URL_CHAR);
	pURLCHARe := pURLCHARs + Length(URL_CHAR);
	pCTAGLs	  := PChar(CLOSE_TAGAL);
	pCTAGLe   := pCTAGLs + 4;
	pCTAGUs   := PChar(CLOSE_TAGAU);
	pCTAGUe   := pCTAGUs + 4;
	for j := 0 to 9 do begin
		pREF_MARKSs[j] := PChar(REF_MARK[j]);
		pREF_MARKSe[j] := pREF_MARKSs[j] + Length(REF_MARK[j]);
	end;
end;
// XLǂݍ݁Alu
function THTMLCreate.LoadFromSkin(
	fileName: string;
	ThreadItem: TThreadItem;
	SizeByte: Integer
): string;
var
	Skin: TStringList;
begin

	Skin := TStringList.Create;
	try
		if FileExists( fileName ) then begin
			Skin.LoadFromFile( fileName );

			// 肩ꂵǁAIvV_CAÕvr[p try
			try
				if ThreadItem.ParentBoard <> nil then
					if ThreadItem.ParentBoard.ParentCategory <> nil then
						CustomStringReplace( Skin, '<BBSNAME/>', ThreadItem.ParentBoard.ParentCategory.ParenTBBS.Title);
					CustomStringReplace( Skin, '<THREADURL/>', ThreadItem.URL);
			except end;
			CustomStringReplace( Skin, '<BOARDNAME/>', ThreadItem.ParentBoard.Title);
			CustomStringReplace( Skin, '<BOARDURL/>', ThreadItem.ParentBoard.URL);
			CustomStringReplace( Skin, '<THREADNAME/>', ThreadItem.Title);
			CustomStringReplace( Skin, '<SKINPATH/>', GikoSys.Setting.CSSFileName);
			CustomStringReplace( Skin, '<GETRESCOUNT/>', IntToStr( ThreadItem.Count - ThreadItem.NewResCount ));
			CustomStringReplace( Skin, '<NEWRESCOUNT/>', IntToStr( ThreadItem.NewResCount ));
			CustomStringReplace( Skin, '<ALLRESCOUNT/>', IntToStr( ThreadItem.Count ));

			CustomStringReplace( Skin, '<NEWDATE/>',FormatDateTime('yyyy/mm/dd(ddd) hh:mm', ThreadItem.RoundDate));
			CustomStringReplace( Skin, '<SIZEKB/>', IntToStr( Floor( SizeByte / 1024 ) ));
			CustomStringReplace( Skin, '<SIZE/>', IntToStr( SizeByte ));


			//----- Ƃ肠`݊pBRgAEgĂ悵
			if GikoSys.Setting.UseKatjushaType then begin
				// 肩ꂵǁAIvV_CAÕvr[p try
				try
					if ThreadItem.ParentBoard <> nil then
						if ThreadItem.ParentBoard.ParentCategory <> nil then
							CustomStringReplace( Skin, '&BBSNAME', ThreadItem.ParentBoard.ParentCategory.ParenTBBS.Title);
						CustomStringReplace( Skin, '&THREADURL', ThreadItem.URL);
				except end;
				CustomStringReplace( Skin, '&BOARDNAME', ThreadItem.ParentBoard.Title);
				CustomStringReplace( Skin, '&BOARDURL', ThreadItem.ParentBoard.URL);
				CustomStringReplace( Skin, '&THREADNAME', ThreadItem.Title);
				CustomStringReplace( Skin, '&SKINPATH', GikoSys.Setting.CSSFileName);
				CustomStringReplace( Skin, '&GETRESCOUNT', IntToStr( ThreadItem.NewReceive - 1 ));
				CustomStringReplace( Skin, '&NEWRESCOUNT', IntToStr( ThreadItem.NewResCount ));
				CustomStringReplace( Skin, '&ALLRESCOUNT', IntToStr( ThreadItem.AllResCount ));

				CustomStringReplace( Skin, '&NEWDATE', FormatDateTime('yyyy/mm/dd(ddd) hh:mm', ThreadItem.RoundDate));
				CustomStringReplace( Skin, '&SIZEKB', IntToStr( Floor( SizeByte / 1024 ) ));
				CustomStringReplace( Skin, '&SIZE', IntToStr( SizeByte ));
				//----- ܂
			end;
		end;
		Result := Skin.Text;
	finally
		Skin.Free;
	end;
end;

// X̒lu
function THTMLCreate.SkinedRes(
	skin: string;
	Res: TResRec;
	No: string
): string;
var
	spamminess	: Extended;
	wordCount		: TWordCount;
begin

	wordCount := TWordCount.Create;
	try
		spamminess := Floor( GikoSys.SpamParse(
			Res.FName + '<>' + Res.FMailTo + '<>' + Res.FBody, wordCount ) * 100 );

		Skin := CustomStringReplace( Skin, '<NUMBER/>',
			'<a href="menu:' + No + '" name="' + No + '">' + No + '</a>');
		Skin := CustomStringReplace( Skin, '<PLAINNUMBER/>', No);
		Skin := CustomStringReplace( Skin, '<NAME/>', '<b>' + Res.FName + '</b>');
		Skin := CustomStringReplace( Skin, '<MAILNAME/>',
			'<a href="mailto:' + Res.FMailTo + '"><b>' + Res.FName + '</b></a>');
		Skin := CustomStringReplace( Skin, '<MAIL/>', Res.FMailTo);
		Skin := CustomStringReplace( Skin, '<DATE/>', Res.FDateTime);
		Skin := CustomStringReplace( Skin, '<MESSAGE/>', Res.FBody);
		Skin := CustomStringReplace( Skin, '<SPAMMINESS/>', FloatToStr( spamminess ) );
		Skin := CustomStringReplace( Skin, '<NONSPAMMINESS/>', FloatToStr( 100 - spamminess ) );

		//----- `݊pBRgAEgĂ悵
		if GikoSys.Setting.UseKatjushaType then begin
			Skin := CustomStringReplace( Skin, '&NUMBER',
				'<a href="menu:' + No + '" name="' + No + '">' + No + '</a>');
			Skin := CustomStringReplace( Skin, '&PLAINNUMBER', No);
			Skin := CustomStringReplace( Skin, '&NAME', '<b>' + Res.FName + '</b>');
			Skin := CustomStringReplace( Skin, '&MAILNAME',
				'<a href="mailto:' + Res.FMailTo + '"><b>' + Res.FName + '</b></a>');
			Skin := CustomStringReplace( Skin, '&MAIL', Res.FMailTo);
			Skin := CustomStringReplace( Skin, '&DATE', Res.FDateTime);
			Skin := CustomStringReplace( Skin, '&MESSAGE', Res.FBody);
			Skin := CustomStringReplace( Skin, '&SPAMMINESS', FloatToStr( spamminess ) );
			Skin := CustomStringReplace( Skin, '&NONSPAMMINESS', FloatToStr( 100 - spamminess ) );
        end;
		//----- ܂

		Result := Skin;
	finally
		wordCount.Free;
	end;

end;
(*************************************************************************
 *http://̕anchor^OtɂB
 *************************************************************************)
function THTMLCreate.AddAnchorTag(s: string): string;
var
	url: string;
	href: string;
	i, j, b: Integer;
	tmp: Integer;
	idx, idx2: Integer;
	pos : PChar;
	pp, pe : PChar;
begin
	Result := '';

	while True do begin
		idx  := MaxInt;
		idx2 := MaxInt;
		pp := PChar(s);
		pe := pp + Length(s);

		for j := 0 to 9 do begin
			pos := AnsiStrPosEx(pp, pe, pREF_MARKSs[j], pREF_MARKSe[j]);
			if pos <> nil then begin
				tmp := pos - pp + 1;
				idx := Min(tmp, idx);
				if idx = tmp then idx2 := j;   //ǂ̃}[Nňۑ
			end;
		end;

		if idx = MaxInt then begin
			//NB
			Result := Result + s;
			Break;
		end;

		if (idx > 1) and (idx > anchorLen) and
			(AnsiStrPosEx(pp + idx - 1 - anchorLen, pp + idx, pANCHORs, pANCHORe) <> nil) then begin
			//ɃN^OĂۂƂ̓V
			//</a></A>TAŌȂΑ啶Ō
			pos := AnsiStrPosEx(pp + idx, pe, pCTAGLs, pCTAGLe);
			if pos = nil then
				pos := AnsiStrPosEx(pp + idx, pe, pCTAGUs, pCTAGUe);
			if pos = nil then
				b := Length(REF_MARK[idx2])
			else
				b := pos - pp + 1;

			Result := Result + Copy(s, 1, idx + b);
			Delete(s, 1, idx + b);
			Continue;
		end;

		Result := Result + Copy(s, 1, idx - 1);
		Delete(s, 1, idx - 1);
		b := Length( s ) + 1;
		pp      := PChar(s);
		for i := 1 to b do begin
			pe := AnsiStrPosEx(pURLCHARs, pURLCHARe, pp, pp + 1);

			if pe = nil then begin
				//URLȂIƂAȂȂB
				url := Copy(s, 1, i - 1);
				case idx2 of
					1 : href := 'h' + url;
					2 : href := 'ht' + url;
					4 : href := 'htt' + url;
					6 : href := 'http://' + url;
				else
					href := url;
				end;

				Result := Result + '<a href="' + href + '" target="_blank">' + url + '</a>';
				Delete(s, 1, i - 1);
				Break;
			end;
			//ꕶi߂B
			Inc(pp);
		end;
	end;
end;

//AAIDFΏۂƂȂtIDAANum:X AURLF̃XbhURL
function THTMLCreate.AddBeProfileLink(AID : string; ANum: Integer):string ;
var
	p : integer;
	BNum, BMark : string;
begin
	p := AnsiPos('BE:', AnsiUpperCase(AID));
	if p > 0 then begin
		BNum := Copy(AID, p, Length(AID));
		AID := Copy(AID, 1, p - 1);
		p := AnsiPos('-', BNum);
		if p > 0 then begin
			BMark := '?' + Trim(Copy(BNum, p + 1, Length(BNum)));
			BNum := Copy(BNum, 1, p - 1);
		end;
		BNum := Trim(BNum);
		Result := AID + ' <a href="'  + BNum + '/' + IntToStr(ANum)
			+ '" target=_blank>' + BMark + '</a>';
	end else
		Result := AID;
end;
procedure THTMLCreate.separateNumber(var st: String; var et: String; const Text, Separator: String);
var
	p : Integer;
begin
	p := Pos(Separator,Text);
	if (p > 0 ) then begin
		st := Copy(Text, 1, p - 1);
		et := Copy(Text, p + Length(Separator), Length(Text));
	end else begin
		st := Text;
		et := Text;
	end;
end;

(*************************************************************************
 *
 * from HotZonu
 *************************************************************************)
function THTMLCreate.ConvRes(const Body, Bbs, Key,
	ParamBBS, ParamKey, ParamStart, ParamTo, ParamNoFirst, ParamTrue : string;
	DatToHTML: boolean = false): string;
const
	GT	= '&gt;';
	SN	= '0123456789';
	FORMAT_LINK = '<a href="../test/read.cgi?%s=%s&%s=%s&%s=%s&%s=%s&%s=%s" target="_blank">';
var
	i : integer;
	s : string;
	sw: boolean;
	cm: boolean;
	No: string;
	oc	: string;
	pos, pmin : integer;
	j : integer;
	token : array[0..5] of string;
	ch : string;
	db : boolean;
	len : integer;
	rink : string;
	function addResAnchor(const Left :string) : string;
	var
		st,et : string;
	begin
		//I[܂ōsĂ̏I`FbN
		if j <= len then begin
			if db then j := j - 2
			else j := j - 1;
		end;
		//ȂƂ
		if No = '' then begin
			Result := Left + Copy(s, 1, j - 1);
		end else begin
			separateNumber(st, et, No, '-');

			if not DatToHTML then begin
				Result := Left + Format(FORMAT_LINK,
							[ParamBBS, Bbs, ParamKey, Key, ParamStart, st, ParamTo, et, ParamNoFirst, ParamTrue]);
			end else begin
				Result := Left + Format('<a href="#%s">', [st]);
			end;
			Result := Result + Copy(s, 1, j - 1) + '</a>';
		end;
		Delete(s, 1, j - 1);
	end;

	procedure getNumberString;
	begin
		while (j <= len) do begin
			if (ByteType(s, j) = mbSingleByte) then begin
				//1byte
				ch := s[j];
				Inc(j);
				db := false;
			end else begin
				//2byte
				ch := ZenToHan(Copy(s, j, 2));
				Inc(j, 2);
				db := true;
			end;

			if System.Pos(ch, SN) > 0 then begin
				No := No + ch;
			end else if (ch = '-') then begin
				if sw then break;
				if No = '' then break;
				No := No + ch;
				sw := true;
			end else begin
				break;
			end;
		end;
	end;

	function checkComma : boolean;
	begin
		j := 1;
		len := Length(s);
		if ((len > 0) and (s[j] = ',')) or ((len > 1) and (ZenToHan(Copy(s, j ,2)) = ','))  then begin
			Result := true;
			if (ByteType(s, j) = mbSingleByte) then
				Inc(j)
			else
				Inc(j, 2);
			No := '';
		end else begin
			Result := false;
		end;
	end;
begin
	//s ɖ{S
	s	 :=	Body;
	//ʂNA
	Result	 :=	'';
	//Ώۂ̕S
	token[0] := GT + GT;
	token[1] := GT;
	token[2] := '';
	token[3] := '';
	token[4] := '<a ';
	token[5] := '<A ';

	//
	while Length(s) > 2 do begin
		pmin := Length(s) + 1;
		i	:= Length(token);
		for j := 0 to 5 do begin
			pos := AnsiPos(token[j], s);
			if pos <> 0 then begin
				if pos < pmin then begin
					//ǂŃqbgۑ
					i := j;
					//ŏlXV
					pmin := pos;
				end;
			end;
		end;

		//qbg̈O܂ŌʂɃRs[
		Result := Result + Copy(s, 1, pmin - 1);
		Delete(s, 1, pmin - 1);

		if i = 6 then begin
			//qbgȂ
		end else if (i = 4) or (i = 5) then begin
			//'<a ' or '<A' Ńqbg '</a>' or '</A>' ܂ŃRs[
			pmin := AnsiPos('</a>' , s);
			pos := AnsiPos('</A>' , s);
			if (pmin <> 0) and (pos <> 0) then begin
				if (pmin > pos) then begin
					pmin := pos;
				end;
			end else if (pos <> 0) then begin
				pmin := pos;
			end;
			rink := Copy(s, 1, pmin + 3);
			Result := Result + rink;
			Delete(s, 1, pmin + 3);

			pmin := Length(rink);
			i	:= Length(token);
			for j := 0 to 3 do begin
				pos := AnsiPos(token[j], rink);
				if pos <> 0 then begin
					if pos < pmin then begin
						//ǂŃqbgۑ
						i := j;
						//ŏlXV
						pmin := pos;
					end;
				end;
			end;
			// XAJ[܂܂Ă,AJ[ƂĈ
			if i <= 3 then begin
				No := '';
				cm := checkComma;
				len := Length(s);
				while cm do begin
					getNumberString;
					Result := addResAnchor(Result);
					cm := checkComma;
				end;
			end;
		end else begin
			//猩p^[
			j := Length(token[i]) + 1;
			oc := '';
			No := '';
			sw := false;
			db := false;
			len := Length(s);
			getNumberString;
			Result := addResAnchor(Result);
		end;
	end;
	Result := Result + s;
end;

function THTMLCreate.ConvertResAnchor(res: string): string;
const
	_HEAD : string = '<a href="../';
	_TAIL : string = ' target="_blank">';
	_ST: string = '&st=';
	_TO: string = '&to=';
	_STA: string = '&START=';
	_END: string = '&END=';
var
	i, j, k: Integer;
	tmp: string;
begin
	Result := '';
	i := AnsiPos(_HEAD, res);
	while i <> 0 do begin
		Result := Result + Copy(res, 1, i -1);
		Delete(res, 1, i - 1);
		j := AnsiPos(_TAIL, res);
		if j = 0 then begin
			Result := Result + res;
			Exit;
		end;
		tmp := Copy(res, 1, j - 1);
		Delete(res, 1, j + 16);
		if (AnsiPos(_ST, tmp) <> 0) and (AnsiPos(_TO, tmp) <> 0) then begin
			Delete(tmp, 1, AnsiPos(_ST, tmp) + 3);
			Delete(tmp, AnsiPos(_TO, tmp), Length(tmp));
			Result := Result + '<a href="#' + tmp + '">';
		end else if (AnsiPos(_STA, tmp) <> 0) and (AnsiPos(_END, tmp) <> 0) then begin
			Delete(tmp, 1, AnsiPos(_STA, tmp) + 6);
			Delete(tmp, AnsiPos(_END, tmp), Length(tmp));
			Result := Result + '<a href="#' + tmp + '">';
		end else begin
			k := LastDelimiter('/', tmp);
			Delete(tmp, 1, k);
			if AnsiPos('-', tmp) < AnsiPos('"', tmp) then
				Delete(tmp, AnsiPos('-', tmp), Length(tmp))
			else
				Delete(tmp, AnsiPos('"', tmp), Length(tmp));

			Result := Result + '<a href="#' + tmp + '">';
		end;
		i := AnsiPos(_HEAD, res);
	end;
	Result := Result + res;

end;

//Plugin𗘗pBoard̃XbhHTML쐬docɏ
procedure THTMLCreate.CreateUsePluginHTML(html: TStringList; ThreadItem: TThreadItem; var sTitle: string);
var
	i: integer;
	NewReceiveNo: Integer;
	boardPlugIn : TBoardPlugIn;
	UserOptionalStyle: string;
begin
	if ThreadItem <> nil then begin
		if ThreadItem.ParentBoard.IsBoardPlugInAvailable then begin
			//===== vOCɂ\
			boardPlugIn		:= ThreadItem.ParentBoard.BoardPlugIn;
			NewReceiveNo	:= ThreadItem.NewReceive;
			// tHgTCY̐ݒ
			UserOptionalStyle := GikoSys.SetUserOptionalStyle;
			html.BeginUpdate;
			try
				// wb_
				html.Append( boardPlugIn.GetHeader( DWORD( threadItem ),
					'<style type="text/css">body {' + UserOptionalStyle + '}</style>' ));
				html.Add('<p id="idSearch"></p>');
				for i := 0 to threadItem.Count - 1 do begin
					// 1 ͕K\
					if i <> 0 then begin
						// \͈͂
						case GikoSys.ResRange of
						Ord( grrKoko ):
							if ThreadItem.Kokomade > (i + 1) then
								Continue;
						Ord( grrNew ):
							if NewReceiveNo > (i + 1) then
								Continue;
						10..65535:
							if (threadItem.Count - i) > GikoSys.ResRange then
								Continue;
						end;
					end;

					// V}[N
					if (NewReceiveNo = (i + 1)) or ((NewReceiveNo = 0) and (i = 0)) then begin
						try
							if GikoSys.Setting.UseSkin then begin
								if FileExists( GikoSys.GetSkinNewmarkFileName ) then
									html.Append( LoadFromSkin( GikoSys.GetSkinNewmarkFileName, ThreadItem, ThreadItem.Size ))
								else
									//doc.Write( '<a name="new"></a>' + #13#10 );
									html.Append( '<a name="new"></a>' );
							end else if GikoSys.Setting.UseCSS then begin
								html.Append('<a name="new"></a><div class="new">VX <span class="newdate">' + FormatDateTime('yyyy/mm/dd(ddd) hh:mm', ThreadItem.RoundDate) + '</span></div>');
							end else begin
								html.Append('</dl>');
								html.Append('<a name="new"></a>');
								html.Append('<table width="100%" bgcolor="#3333CC" cellpadding="0" cellspacing="1"><tr><td align="center" bgcolor="#6666FF" valign="middle"><font size="-1" color="#ffffff"><b>VX ' + FormatDateTime('yyyy/mm/dd(ddd) hh:mm', ThreadItem.RoundDate) + '</b></font></td></tr></table>');
								html.Append('<dl>');
							end;
						except
							html.Append( '<a name="new"></a>');
						end;
					end;

					// X
					html.Append( boardPlugIn.GetRes( DWORD( threadItem ), i + 1 ) );

					if ThreadItem.Kokomade = (i + 1) then begin
						// ܂œǂ
						try
							if GikoSys.Setting.UseSkin then begin
								if FileExists( GikoSys.GetSkinBookmarkFileName ) then
									html.Append( LoadFromSkin( GikoSys.GetSkinBookmarkFileName, ThreadItem, ThreadItem.Size ) )
								else
									html.Append( '<a name="koko"></a>' );
							end else if GikoSys.Setting.UseCSS then begin
								html.Append('<a name="koko"></a><div class="koko">RR܂œǂ</div>' );
							end else begin
								html.Append('</dl>');
								html.Append('<a name="koko"></a><table width="100%" bgcolor="#55AA55" cellpadding="0" cellspacing="1"><tr><td align="center" bgcolor="#77CC77" valign="middle"><font size="-1" color="#ffffff"><b>RR܂œǂ</b></font></td></tr></table>');
								html.Append('<dl>' );
							end;
						except
							html.Append( '<a name="koko"></a>' );
						end;
					end;
				end;


				// XL(tb^)
				html.Append( boardPlugIn.GetFooter( DWORD( threadItem ), '<a name="bottom"></a>' ) );
			finally
				html.EndUpdate;
			end;

		end;
	end;
end;


procedure THTMLCreate.CreateUseSKINHTML(html : TStringList; ThreadItem: TThreadItem; ReadList: TStringList);
var
	i: integer;
	No: string;
	CSSFileName: string;
	NewReceiveNo: Integer;
	Res: TResRec;
	UserOptionalStyle: string;
	SkinHeader: string;
	SkinNewRes: string;
	SkinRes: string;
	strTmp : string;
	threadKey : string;
begin
	if ThreadItem <> nil then begin
		// XLgp
		if GikoSys.Setting.UseSkin then begin
			NewReceiveNo := ThreadItem.NewReceive;
			// tHgTCY̐ݒ
			UserOptionalStyle := GikoSys.SetUserOptionalStyle;
			CSSFileName := GikoSys.GetStyleSheetDir + GikoSys.Setting.CSSFileName;

			threadKey := ChangeFileExt(ThreadItem.FileName, '');
			html.BeginUpdate;
			try
				//doc.charset := 'Shift_JIS';

				// XL̐ݒ
				try
					SkinHeader := LoadFromSkin( GikoSys.GetSkinHeaderFileName, ThreadItem, ThreadItem.Size);
					if Length( UserOptionalStyle ) > 0 then
						SkinHeader := CustomStringReplace( SkinHeader, '</head>',
							'<style type="text/css">body {' + UserOptionalStyle + '}</style></head>');
					html.Append( SkinHeader);
				except
				end;

				try
					SkinNewRes := LoadFromSkin( GikoSys.GetSkinNewResFileName, ThreadItem, ThreadItem.Size);
				except
				end;

				try
					SkinRes := LoadFromSkin( GikoSys.GetSkinResFileName, ThreadItem, ThreadItem.Size );
				except
				end;

				html.Append('<p id="idSearch"></p>');
				html.Append('<a name="top"></a>');

				for i := 0 to ReadList.Count - 1 do begin
					// 1 ͕K\
					if i <> 0 then begin
						// \͈͂
						case GikoSys.ResRange of
						Ord( grrKoko ):
							if ThreadItem.Kokomade > (i + 1) then
								Continue;
						Ord( grrNew ):
							if NewReceiveNo > (i + 1) then
								Continue;
						10..65535:
							if (threadItem.Count - i) > GikoSys.ResRange then
								Continue;
						end;
					end;
					// V}[N
					if (NewReceiveNo = i + 1) or ((NewReceiveNo = 0) and (i = 0)) then begin
						try
							if FileExists( GikoSys.GetSkinNewmarkFileName ) then
								html.Append( LoadFromSkin( GikoSys.GetSkinNewmarkFileName, ThreadItem, ThreadItem.Size ) )
							else
								html.Append( '<a name="new"></a>' );
						except
							html.Append( '<a name="new"></a>' );
						end;
					end;

					if (Trim(ReadList[i]) <> '') then begin
						No := IntToStr(i + 1);

						Res := DivideStrLine(ReadList[i]);
						Res.FBody := ConvRes(AddAnchorTag(Res.FBody), ThreadItem.ParentBoard.BBSID, threadKey, 'bbs', 'key', 'st', 'to', 'nofirst', 'true');
						Res.FDateTime := AddBeProfileLink(Res.FDateTime, i + 1);

						try
							if NewReceiveNo <= (i + 1) then
								// VX
								strTmp := SkinedRes( SkinNewRes, Res, No )
							else
								// ʏ̃X
								strTmp := SkinedRes( SkinRes, Res, No  );

							html.Append( strTmp );
						except
						end;
					end;

					if ThreadItem.Kokomade = (i + 1) then begin
						// ܂œǂ
						try
							if FileExists( GikoSys.GetSkinBookmarkFileName ) then
								html.Append( LoadFromSkin( GikoSys.GetSkinBookmarkFileName, ThreadItem, ThreadItem.Size ) )
							else
								html.Append( '<a name="koko"></a>' );
						except
							html.Append( '<a name="koko"></a>' );
						end;
					end;
				end;

				html.Append('<a name="bottom"></a>' );
				// XL(tb^)
				try
					html.Append( LoadFromSkin( GikoSys.GetSkinFooterFileName, ThreadItem, ThreadItem.Size ) );
				except
				end;
			finally
				html.EndUpdate;
			end;
		end;
	end;
end;

procedure THTMLCreate.CreateUseCSSHTML(html: TStringList; ThreadItem: TThreadItem; ReadList: TStringList; sTitle: string );
var
	i: integer;
	No: string;
	CSSFileName: string;
	NewReceiveNo: Integer;
	Res: TResRec;
	UserOptionalStyle: string;
begin
	if ThreadItem <> nil then begin
		//doc.open;
		html.BeginUpdate;
		try
			//doc.charset := 'Shift_JIS';
			NewReceiveNo := ThreadItem.NewReceive;
			// tHgTCY̐ݒ
			UserOptionalStyle := GikoSys.SetUserOptionalStyle;
			CSSFileName := GikoSys.GetStyleSheetDir + GikoSys.Setting.CSSFileName;
			if GikoSys.Setting.UseCSS and FileExists(CSSFileName) then begin
				//CSSgp
				html.Append('<html><head>');
				html.Append('<meta http-equiv="Content-type" content="text/html; charset=Shift_JIS">');
				html.Append('<title>' + sTitle + '</title>');
				html.Append('<link rel="stylesheet" href="'+CSSFileName+'" type="text/css">');
				if Length( UserOptionalStyle ) > 0 then
					html.Append('<style type="text/css">body {' + UserOptionalStyle + '}</style>');
				html.Append('</head>');
				html.Append('<body>');
				html.Append('<a name="top"></a>');
				html.Append('<p id="idSearch"></p>');
				html.Append('<div class="title">' + sTitle + '</div>');
				for i := 0 to ReadList.Count - 1 do begin
					// 1 ͕K\
					if i <> 0 then begin
						// \͈͂
						case GikoSys.ResRange of
						Ord( grrKoko ):
							if ThreadItem.Kokomade > (i + 1) then
								Continue;
						Ord( grrNew ):
							if NewReceiveNo > (i + 1) then
								Continue;
						10..65535:
							if (threadItem.Count - i) > GikoSys.ResRange then
								Continue;
						end;
					end;

					if (NewReceiveNo = (i + 1)) or ((NewReceiveNo = 0) and (i = 0)) then begin
						html.Append('<a name="new"></a><div class="new">VX <span class="newdate">' + FormatDateTime('yyyy/mm/dd(ddd) hh:mm', ThreadItem.RoundDate) + '</span></div>');
					end;

					if (Trim(ReadList[i]) <> '') then begin
						No := IntToStr(i + 1);
						Res := DivideStrLine(ReadList[i]);
						Res.FBody := ConvRes(AddAnchorTag(Res.FBody), ThreadItem.ParentBoard.BBSID, ChangeFileExt(ThreadItem.FileName, ''), 'bbs', 'key', 'st', 'to', 'nofirst', 'true');
						Res.FDateTime := AddBeProfileLink(Res.FDateTime, i + 1);
						if Res.FMailTo = '' then
							html.Append('<a name="' + No + '"></a>'
										+ '<div class="header"><span class="no"><a href="menu:' + No + '">' + No + '</a></span> '
										+ '<span class="name_label">OF</span> '
										+ '<span class="name"><b>' + Res.FName + '</b></span> '
										+ '<span class="date_label">eF</span> '
										+ '<span class="date">' + Res.FDateTime+ '</span></div>'
										+ '<div class="mes">' + Res.FBody + ' </div>')
						else if GikoSys.Setting.ShowMail then
							html.Append('<a name="' + No + '"></a>'
										+ '<div class="header"><span class="no"><a href="menu:' + No + '">' + No + '</a></span>'
										+ '<span class="name_label"> OF </span>'
										+ '<a class="name_mail" href="mailto:' + Res.FMailTo + '">'
										+ '<b>' + Res.FName + '</b></a><span class="mail"> [' + Res.FMailTo + ']</span>'
										+ '<span class="date_label"> eF</span>'
										+ '<span class="date"> ' + Res.FDateTime+ '</span></div>'
										+ '<div class="mes">' + Res.FBody + ' </div>')
						else
							html.Append('<a name="' + No + '"></a>'
										+ '<div class="header"><span class="no"><a href="menu:' + No + '">' + No + '</a></span>'
										+ '<span class="name_label"> OF </span>'
										+ '<a class="name_mail" href="mailto:' + Res.FMailTo + '">'
										+ '<b>' + Res.FName + '</b></a>'
										+ '<span class="date_label"> eF</span>'
										+ '<span class="date"> ' + Res.FDateTime+ '</span></div>'
										+ '<div class="mes">' + Res.FBody + ' </div>');
					end;

					if ThreadItem.Kokomade = (i + 1) then begin
						html.Append('<a name="koko"></a><div class="koko">RR܂œǂ</div>');
					end;

				end;

				html.Append('<a name="bottom"></a>');
				html.Append('<a name="last"></a>');
				html.Append('</body></html>');
			end;
		finally
			html.EndUpdate;
			//doc.Close;
		end;
	end;
end;

procedure THTMLCreate.CreateDefaultHTML (html: TStringList; ThreadItem: TThreadItem; ReadList: TStringList; sTitle: string );
var
	i: integer;
	No: string;
	NewReceiveNo: Integer;
	Res: TResRec;
begin
	if ThreadItem <> nil then begin
		//doc.open;
		html.BeginUpdate;
		try
			//doc.charset := 'Shift_JIS';
			NewReceiveNo := ThreadItem.NewReceive;
			html.Append('<html><head>');
			html.Append('<meta http-equiv="Content-type" content="text/html; charset=Shift_JIS">');
			html.Append('<title>' + sTitle + '</title></head>');
			html.Append('<body TEXT="#000000" BGCOLOR="#EFEFEF" link="#0000FF" alink="#FF0000" vlink="#660099">');
			html.Append('<a name="top"></a>');
			html.Append('<font size=+1 color="#FF0000">' + sTitle + '</font>');
			html.Append('<dl>');
			html.Append('<p id="idSearch"></p>');
			for i := 0 to ReadList.Count - 1 do begin
				// 1 ͕K\
				if i <> 0 then begin
					// \͈͂
					case GikoSys.ResRange of
					Ord( grrKoko ):
						if ThreadItem.Kokomade > (i + 1) then
							Continue;
					Ord( grrNew ):
						if NewReceiveNo > (i + 1) then
							Continue;
					10..65535:
						if (threadItem.Count - i) > GikoSys.ResRange then
							Continue;
					end;
				end;

				if (NewReceiveNo = (i + 1)) or ((NewReceiveNo = 0) and (i = 0)) then begin
					html.Append('</dl>');
					html.Append('<a name="new"></a>');
					html.Append('<table width="100%" bgcolor="#3333CC" cellpadding="0" cellspacing="1"><tr><td align="center" bgcolor="#6666FF" valign="middle"><font size="-1" color="#ffffff"><b>VX ' + FormatDateTime('yyyy/mm/dd(ddd) hh:mm', ThreadItem.RoundDate) + '</b></font></td></tr></table>');
					html.Append('<dl>');
				end;

				if (Trim(ReadList[i]) <> '') then begin
					No := IntToStr(i + 1);
					Res := DivideStrLine(ReadList[i]);
					Res.FBody := ConvRes(AddAnchorTag(Res.FBody), ThreadItem.ParentBoard.BBSID, ChangeFileExt(ThreadItem.FileName, ''), 'bbs', 'key', 'st', 'to', 'nofirst', 'true');
					Res.FDateTime := AddBeProfileLink(Res.FDateTime, i + 1);
					if Res.FMailTo = '' then
						html.Append('<a name="' + No + '"></a><dt><a href="menu:' + No + '">' + No + '</a> OF<font color="forestgreen"><b> ' + Res.FName + ' </b></font> eF <span class="date">' + Res.FDateTime+ '</span><br><dd>' + Res.Fbody + ' <br><br><br>')
					else if GikoSys.Setting.ShowMail then
						html.Append('<a name="' + No + '"></a><dt><a href="menu:' + No + '">' + No + '</a> OF<a href="mailto:' + Res.FMailTo + '"><b> ' + Res.FName + ' </B></a> [' + Res.FMailTo + '] eF <span class="date">' + Res.FDateTime+ '</span><br><dd>' + Res.Fbody + ' <br><br><br>')
					else
						html.Append('<a name="' + No + '"></a><dt><a href="menu:' + No + '">' + No + '</a> OF<a href="mailto:' + Res.FMailTo + '"><b> ' + Res.FName + ' </B></a> eF <span class="date">' + Res.FDateTime+ '</span><br><dd>' + Res.Fbody + ' <br><br><br>');
				end;
				if ThreadItem.Kokomade = (i + 1) then begin
					html.Append('</dl>');
					html.Append('<a name="koko"></a><table width="100%" bgcolor="#55AA55" cellpadding="0" cellspacing="1"><tr><td align="center" bgcolor="#77CC77" valign="middle"><font size="-1" color="#ffffff"><b>RR܂œǂ</b></font></td></tr></table>');
					html.Append('<dl>');
				end;
			end;
			html.Append('</dl>');
			html.Append('<a name="bottom"></a>');
			html.Append('</body></html>');
		finally
			//doc.Close;
			html.EndUpdate;
		end;
	end;
end;

procedure THTMLCreate.CreateHTML2(doc: IDispatch; ThreadItem: TThreadItem; var sTitle: string);
var
	ReadList: TStringList;
	CSSFileName: string;
	FileName: string;
	Res: TResRec;
	html: TStringList;
	mStream : TMemoryStream;
{$IFDEF DEBUG}
	st, rt: Cardinal;
{$ENDIF}
begin
{$IFDEF DEBUG}
	Writeln('Create HTML');
	st := GetTickCount;
{$ENDIF}
	if ThreadItem <> nil then begin
		html := TStringList.Create;
		try
			if ThreadItem.ParentBoard.IsBoardPlugInAvailable then begin
				CreateUsePluginHTML(html, ThreadItem, sTitle);
			end else begin
				ShortDayNames[1] := '';		ShortDayNames[2] := '';
				ShortDayNames[3] := '';		ShortDayNames[4] := '';
				ShortDayNames[5] := '';		ShortDayNames[6] := '';
				ShortDayNames[7] := 'y';

				ReadList := TStringList.Create;
				try
					ReadList.BeginUpdate;
					if ThreadItem.IsLogFile then begin
						FileName := ThreadItem.GetThreadFileName;
						ReadList.LoadFromFile(FileName);
						GikoSys.FAbon.IndividualAbon(ReadList, ChangeFileExt(FileName,'.NG'));
						GikoSys.FAbon.Execute(ReadList);		//	 ځ`񂵂
						GikoSys.FSelectResFilter.Execute(ReadList); //X̃tB^O
						if ThreadItem.Title = '' then begin
							Res := DivideStrLine(ReadList[0]);
							sTitle := Res.FTitle;
						end else
							sTitle := ThreadItem.Title
					end else begin
						sTitle := CustomStringReplace(ThreadItem.Title, 'M', ',');
					end;

					// tHgTCY̐ݒ
					CSSFileName := GikoSys.GetStyleSheetDir + GikoSys.Setting.CSSFileName;
					if GikoSys.Setting.UseSkin then begin
						CreateUseSKINHTML(html, ThreadItem, ReadList);
					end else if GikoSys.Setting.UseCSS and FileExists(CSSFileName) then begin
						CreateUseCSSHTML(html, ThreadItem, ReadList, sTitle);
					end else begin
						CreateDefaultHTML(html, ThreadItem, ReadList, sTitle);
					end;
				finally
                    ReadList.EndUpdate;
					ReadList.Free;
				end;
			end;
			//WebBrowserɏ
			mStream := TMemoryStream.Create;
			try
				html.SaveToStream(mStream);
				mStream.Seek(soFromBeginning, 0);
				(doc as IPersistStreamInit).Load(TStreamAdapter.Create(mStream));
			finally
				mStream.Free;
			end;
		finally
			html.Free;
		end;
	end;
{$IFDEF DEBUG}
	rt := GetTickCount - st;
	Writeln('Done.');
	Writeln(IntToStr(rt) + ' ms');
{$ENDIF}
end;

procedure THTMLCreate.CreateHTML3(var html: TStringList; ThreadItem: TThreadItem; var sTitle: string);
var
	i: integer;
	No: string;
	//bufList : TStringList;
	ReadList: TStringList;
//	SaveList: TStringList;
	CSSFileName: string;
	BBSID: string;
	FileName: string;
	Res: TResRec;
	boardPlugIn : TBoardPlugIn;

	UserOptionalStyle: string;
	SkinHeader: string;
	SkinRes: string;
	tmp, tmp1: string;
	function LoadSkin( fileName: string ): string;
	begin
		Result := LoadFromSkin( fileName, ThreadItem, ThreadItem.Size );
	end;
	function ReplaceRes( skin: string ): string;
	begin
		Result := SkinedRes( skin, Res, No );
	end;

begin
	if ThreadItem <> nil then begin
		CSSFileName := GikoSys.GetStyleSheetDir + GikoSys.Setting.CSSFileName;
		html.Clear;
		html.BeginUpdate;
		//if ThreadItem.IsBoardPlugInAvailable then begin
		if ThreadItem.ParentBoard.IsBoardPlugInAvailable then begin
			//===== vOCɂ\
			//boardPlugIn		:= ThreadItem.BoardPlugIn;
			boardPlugIn		:= ThreadItem.ParentBoard.BoardPlugIn;
			// tHgTCY̐ݒ
			UserOptionalStyle := GikoSys.SetUserOptionalStyle;
			try
				// R[h̓vOCɔC
				// wb_
				tmp := boardPlugIn.GetHeader( DWORD( threadItem ),
					'<style type="text/css">body {' + UserOptionalStyle + '}</style>' );
				//ΎQƂ瑊ΎQƂ
				if GikoSys.Setting.UseSkin then begin
					tmp1 := './' + GikoSys.Setting.CSSFileName;
					tmp1 := CustomStringReplace(tmp1, GikoSys.GetConfigDir, '');
					tmp1 := CustomStringReplace(tmp1, '\', '/');
					tmp := CustomStringReplace(tmp, ExtractFilePath(GikoSys.Setting.CSSFileName),  tmp1);
				end else if GikoSys.Setting.UseCSS then begin
					tmp1 := './' + CSSFileName;
					tmp1 := CustomStringReplace(tmp1, GikoSys.GetConfigDir, '');
					tmp1 := CustomStringReplace(tmp1, '\', '/');
					tmp := CustomStringReplace(tmp, CSSFileName,  tmp1);
				end;
				html.Append( tmp );

				for i := 0 to threadItem.Count - 1 do begin

					// X
					html.Append( ConvertResAnchor(boardPlugIn.GetRes( DWORD( threadItem ), i + 1 )) );

				end;
				// XL(tb^)
				html.Append( boardPlugIn.GetFooter( DWORD( threadItem ), '<a name="bottom"></a>' ) );
			finally
			end;
			html.EndUpdate;
			//Exit;
		end else begin
			ShortDayNames[1] := '';		ShortDayNames[2] := '';
			ShortDayNames[3] := '';		ShortDayNames[4] := '';
			ShortDayNames[5] := '';		ShortDayNames[6] := '';
			ShortDayNames[7] := 'y';
			BBSID := ThreadItem.ParentBoard.BBSID;
			ReadList := TStringList.Create;
			try
				if ThreadItem.IsLogFile then begin
					FileName := ThreadItem.GetThreadFileName;
					ReadList.LoadFromFile(FileName);
					GikoSys.FAbon.IndividualAbon(ReadList, ChangeFileExt(FileName,'.NG'));
					GikoSys.FAbon.Execute(ReadList);		//	 ځ`񂵂
					GikoSys.FSelectResFilter.Execute(ReadList); //X̃tB^O
					Res := DivideStrLine(ReadList[0]);
					//Res.FTitle := CustomStringReplace(Res.FTitle, 'M', ',');
					sTitle := Res.FTitle;
				end else begin
					sTitle := CustomStringReplace(ThreadItem.Title, 'M', ',');
				end;
				try
					// tHgTCY̐ݒ
					UserOptionalStyle := GikoSys.SetUserOptionalStyle;

					if GikoSys.Setting.UseSkin then begin
						// XLgp
						// XL̐ݒ
						try
							SkinHeader := LoadSkin( GikoSys.GetSkinHeaderFileName );
							if Length( UserOptionalStyle ) > 0 then
								SkinHeader := CustomStringReplace( SkinHeader, '</head>',
									'<style type="text/css">body {' + UserOptionalStyle + '}</style></head>');
							//ΎQƂ瑊ΎQƂ
							tmp1 := './' + GikoSys.Setting.CSSFileName;
							tmp1 := CustomStringReplace(tmp1, GikoSys.GetConfigDir, '');
							tmp1 := CustomStringReplace(tmp1, '\', '/');
							SkinHeader := CustomStringReplace(SkinHeader, ExtractFilePath(GikoSys.Setting.CSSFileName),  tmp1);
							html.Append( SkinHeader );
						except
						end;
						try
							SkinRes := LoadSkin( GikoSys.GetSkinResFileName );
						except
						end;
						html.Append('<a name="top"></a>');
						for i := 0 to ReadList.Count - 1 do begin
							if (Trim(ReadList[i]) <> '') then begin
								No := IntToStr(i + 1);

								Res := DivideStrLine(ReadList[i]);
								Res.FBody := AddAnchorTag(Res.FBody);
								Res.FBody := ConvertResAnchor(ConvRes(Res.FBody, ThreadItem.ParentBoard.BBSID, ChangeFileExt(ThreadItem.FileName, ''), 'bbs', 'key', 'st', 'to', 'nofirst', 'true', true));

								try
									html.Append( ReplaceRes( SkinRes ) );
								except
								end;
							end;

						end;
						html.Append('<a name="bottom"></a>');
						// XL(tb^)
						try
							html.Append( LoadSkin( GikoSys.GetSkinFooterFileName ) );
						except
						end;
					end else if GikoSys.Setting.UseCSS and FileExists(CSSFileName) then begin
						//CSSgp
						//CSSFileName := GetAppDir + CSS_FILE_NAME;
						html.Append('<html><head>');
						html.Append('<meta http-equiv="Content-type" content="text/html; charset=Shift_JIS">');
						html.Append('<title>' + sTitle + '</title>');
						//ΎQƂ瑊ΎQƂ
						tmp1 := './' + CSSFileName;
						tmp1 := CustomStringReplace(tmp1, GikoSys.GetConfigDir, '');
						tmp1 := CustomStringReplace(tmp1, '\', '/');

						html.Append('<link rel="stylesheet" href="'+tmp1+'" type="text/css">');
						if Length( UserOptionalStyle ) > 0 then
							html.Append('<style type="text/css">body {' + UserOptionalStyle + '}</style>');
						html.Append('</head>');
						html.Append('<body>');
						html.Append('<a name="top"></a>');
						html.Append('<div class="title">' + sTitle + '</div>');
						for i := 0 to ReadList.Count - 1 do begin
							if (Trim(ReadList[i]) <> '') then begin
								No := IntToStr(i + 1);
								Res := DivideStrLine(ReadList[i]);
								Res.FBody := AddAnchorTag(Res.FBody);
								Res.FBody := ConvertResAnchor(ConvRes(Res.FBody, ThreadItem.ParentBoard.BBSID, ChangeFileExt(ThreadItem.FileName, ''), 'bbs', 'key', 'st', 'to', 'nofirst', 'true', true));
								if Res.FMailTo = '' then
									html.Append('<a name="' + No + '"></a>'
													+ '<div class="header"><span class="no"><a href="menu:' + No + '">' + No + '</a></span> '
													+ '<span class="name_label">OF</span> '
													+ '<span class="name"><b>' + Res.FName + '</b></span> '
													+ '<span class="date_label">eF</span> '
													+ '<span class="date">' + Res.FDateTime+ '</span></div>'
																								+ '<div class="mes">' + Res.FBody + ' </div>')
								else if GikoSys.Setting.ShowMail then
									html.Append('<a name="' + No + '"></a>'
													+ '<div class="header"><span class="no"><a href="menu:' + No + '">' + No + '</a></span>'
																								+ '<span class="name_label"> OF </span>'
													+ '<a class="name_mail" href="mailto:' + Res.FMailTo + '">'
													+ '<b>' + Res.FName + '</b></a><span class="mail"> [' + Res.FMailTo + ']</span>'
													+ '<span class="date_label"> eF</span>'
													+ '<span class="date"> ' + Res.FDateTime+ '</span></div>'
													+ '<div class="mes">' + Res.FBody + ' </div>')
								else
									html.Append('<a name="' + No + '"></a>'
													+ '<div class="header"><span class="no"><a href="menu:' + No + '">' + No + '</a></span>'
													+ '<span class="name_label"> OF </span>'
													+ '<a class="name_mail" href="mailto:' + Res.FMailTo + '">'
													+ '<b>' + Res.FName + '</b></a>'
													+ '<span class="date_label"> eF</span>'
													+ '<span class="date"> ' + Res.FDateTime+ '</span></div>'
																								+ '<div class="mes">' + Res.FBody + ' </div>');
							end;
						end;
						html.Append('<a name="bottom"></a>');
						html.Append('<a name="last"></a>');
						html.Append('</body></html>');
					end else begin
						//CSSgp
						html.Append('<html><head>');
						html.Append('<meta http-equiv="Content-type" content="text/html; charset=Shift_JIS">');
						html.Append('<title>' + sTitle + '</title></head>');
						html.Append('<body TEXT="#000000" BGCOLOR="#EFEFEF" link="#0000FF" alink="#FF0000" vlink="#660099">');
						html.Append('<a name="top"></a>');
						html.Append('<font size=+1 color="#FF0000">' + sTitle + '</font>');
						html.Append('<dl>');
						for i := 0 to ReadList.Count - 1 do begin
							if (Trim(ReadList[i]) <> '') then begin
								No := IntToStr(i + 1);
								Res := DivideStrLine(ReadList[i]);
								Res.FBody := AddAnchorTag(Res.FBody);
								Res.FBody := ConvertResAnchor(ConvRes(Res.FBody, ThreadItem.ParentBoard.BBSID, ChangeFileExt(ThreadItem.FileName, ''), 'bbs', 'key', 'st', 'to', 'nofirst', 'true', true));
								if Res.FMailTo = '' then
									html.Append('<a name="' + No + '"></a><dt><a href="menu:' + No + '">' + No + '</a> OF<font color="forestgreen"><b> ' + Res.FName + ' </b></font> eF ' + Res.FDateTime+ '<br><dd>' + Res.Fbody + ' <br><br><br>')
								else if GikoSys.Setting.ShowMail then
									html.Append('<a name="' + No + '"></a><dt><a href="menu:' + No + '">' + No + '</a> OF<a href="mailto:' + Res.FMailTo + '"><b> ' + Res.FName + ' </B></a> [' + Res.FMailTo + '] eF ' + Res.FDateTime+ '<br><dd>' + Res.Fbody + ' <br><br><br>')
								else
									html.Append('<a name="' + No + '"></a><dt><a href="menu:' + No + '">' + No + '</a> OF<a href="mailto:' + Res.FMailTo + '"><b> ' + Res.FName + ' </B></a> eF ' + Res.FDateTime+ '<br><dd>' + Res.Fbody + ' <br><br><br>');
							end;
						end;
						html.Append('</dl>');
						html.Append('<a name="bottom"></a>');
						html.Append('</body></html>');
					end;
				finally
					html.EndUpdate;
				end;
			finally
				ReadList.Free;
			end;
		end;
	end;
end;

initialization
	 HTMLCreater := THTMLCreate.Create;

finalization
	if HTMLCreater <> nil then begin
		HTMLCreater.Free;
		HTMLCreater := nil;
	end;

end.
