unit GikoSystem;

interface

uses
	Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
	ComCtrls, IniFiles, ShellAPI, ActnList, Math,
{$IF Defined(DELPRO) }
	SHDocVw,
	MSHTML,
{$ELSE}
	SHDocVw_TLB,
	MSHTML_TLB,
{$IFEND}
	{HttpApp,} YofUtils, URLMon, IdGlobal, IdURI, {Masks,}
	Setting, BoardGroup, gzip, Dolib, bmRegExp, AbonUnit,
	ExternalBoardManager, ExternalBoardPlugInMain,
	Sort, GikoBayesian;

type
	TVerResourceKey = (
		  vrComments,         // Rg
		  vrCompanyName,      // Ж
		  vrFileDescription,  // 
		  vrFileVersion,      // t@Co[W
		  vrInternalName,     // 
		  vrLegalCopyright,   // 쌠
		  vrLegalTrademarks,  // W
		  vrOriginalFilename, // t@C
		  vrPrivateBuild,     // vCx[grh
		  vrProductName,      // i
		  vrProductVersion,   // io[W
		  vrSpecialBuild);     // XyVrh

	//BBS^Cv
	TGikoBBSType = (gbt2ch);
	//O^Cv
	TGikoLogType = (glt2chNew, glt2chOld);
	//bZ[WACR
	TGikoMessageIcon = (gmiOK, gmiSAD, gmiNG, gmiWhat, gmiNone);
	//URLI[vuEU^Cv
	TGikoBrowserType = (gbtIE, gbtUserApp, gbtAuto);


	TStrTokSeparator = set of Char;
	TStrTokRec = record
		Str: string;
		Pos: Integer;
	end;

	//CfbNXt@CR[h
	TIndexRec = record
		FNo: Integer;
		FFileName: string;
		FTitle: string;
		FCount: Integer;
		FSize: Integer;
//		FRoundNo: Integer;
		FRoundDate: TDateTime;
		FLastModified: TDateTime;
		FKokomade: Integer;
		FNewReceive: Integer;
		FMishiyou: Boolean;	//gp
		FUnRead: Boolean;
		FScrollTop: Integer;
		//Index Ver 1.01
		FAllResCount: Integer;
		FNewResCount: Integer;
		FAgeSage: TGikoAgeSage;
	end;

	//TuWFNgR[h
	TSubjectRec = record
		FFileName: string;
		FTitle: string;
		FCount: Integer;
	end;

	//XR[h
	TResRec = record
		FTitle: string;
		FMailTo: string;
		FName: string;
		FDateTime: string;
		FBody: string;
		FType: TGikoLogType;
	end;

	//URLPathR[h
	TPathRec = record
		FBBS: string;				//BBSID
		FKey: string;				//ThreadID
		FSt: Int64;				//JnX
		FTo: Int64;				//IX
		FFirst: Boolean;		//>>1̕\
		FStBegin: Boolean;	//1`\
		FToEnd: Boolean;		//`Ō܂ŕ\
		FDone: Boolean;			//
		FNoParam: Boolean;    		//Xԃp[^Ȃ
	end;

	//MessageList
	TGikoMessageListType = (gmLogout, gmLogin, gmForceLogin, gmSureItiran,
			gmUnKnown, gmSureSyutoku, gmSureDiff, gmNotMod, gmAbort, gmError,
			gmNewRes, gmNewSure, gmResError, gmSureError);

	TGikoSys = class(TObject)
	private
		{ Private 錾 }
		FSetting: TSetting;
		FDolib: TDolib;
		FAWKStr: TAWKStr;
		FResRange : Longint;
		FBayesian	: TGikoBayesian;	//!< xCWAtB^
		FVersion : String;		//t@Co[W
//		FExitWrite: TStringList;
//		function StrToFloatDef(s: string; Default: Double): Double;
	public
		{ Public 錾 }
		FAbon : TAbon;
		FSelectResFilter : TAbon;
		//FBoardURLList: TStringList;
		constructor Create;

		destructor Destroy; override;
		property ResRange : Longint read FResRange write FResRange;
		//o[W
		property Version : String read FVersion;
//		function MsgBox(Msg: string; Title: string; Flags: Longint): integer; overload;
//		function MsgBox(Handle: THandle; Msg: string; Title: string; Flags: Longint): integer; overload;
		function IsNumeric(s: string): boolean;
		function IsFloat(s: string): boolean;
		function DirectoryExistsEx(const Name: string): Boolean;
		function ForceDirectoriesEx(Dir: string): Boolean;
//		function GetVersion: string;

		function GetBoardFileName: string;
		function GetCustomBoardFileName: string;
		function GetHtmlTempFileName: string;
		function GetAppDir: string;
		function GetTempFolder: string;
		function GetSentFileName: string;
		function GetConfigDir: string;
		function GetSkinDir: string;
		function GetSkinHeaderFileName: string;
		function GetSkinFooterFileName: string;
		function GetSkinResFileName: string;
		function GetSkinNewResFileName: string;
		function GetSkinBookmarkFileName: string;
		function GetSkinNewmarkFileName: string;
		function GetStyleSheetDir: string;
		function GetOutBoxFileName: string;
		function GetUserAgent: string;
				function GetSambaFileName : string;

		procedure ReadSubjectFile(Board: TBoard);
		procedure CreateThreadDat(Board: TBoard);
		procedure WriteThreadDat(Board: TBoard);
		function ParseIndexLine(Line: string): TIndexRec;
		procedure GetFileList(Path: string; Mask: string; var List: TStringList; SubDir: Boolean; IsPathAdd: Boolean); overload;
		procedure GetFileList(Path: string; Mask: string; var List: TStringList; IsPathAdd: Boolean); overload;//TutH_͌Ȃ
		procedure GetDirectoryList(Path: string; Mask: string; List: TStringList; SubDir: Boolean);

		function DivideSubject(Line: string): TSubjectRec;
		function DivideStrLine(Line: string): TResRec;

		property Setting: TSetting read FSetting write FSetting;
		property Dolib: TDolib read FDolib write FDolib;

		function UrlToID(url: string): string;
		function UrlToServer(url: string): string;

		function StrTokFirst(const s:string; const sep:TStrTokSeparator; var Rec:TStrTokRec):string;
		function StrTokNext(const sep:TStrTokSeparator; var Rec:TStrTokRec): string;

		function GetFileSize(FileName : string) : longint;
		function GetFileLineCount(FileName : string): longint;
		function Get2chDate(aDate: TDateTime): string;
		function IntToDateTime(val: Int64): TDateTime;
		function DateTimeToInt(ADate: TDateTime): Int64;

		function ReadThreadFile(FileName: string; Line: Integer): string;

		procedure MenuFont(Font: TFont);

		function RemoveToken(var s:string; const delimiter:string):string;
		function GetTokenIndex(s: string; delimiter: string; index: Integer): string;
		function DeleteLink(const s: string): string;

		function GetShortName(const LongName: string; ALength: integer): string;
		function ConvRes(const Body, Bbs, Key,	ParamBBS, ParamKey, ParamStart, ParamTo, ParamNoFirst, ParamTrue : string; DatToHTML: boolean = false): string; overload;
		function ConvRes(const Body, Bbs, Key,	ParamBBS, ParamKey, ParamStart, ParamTo, ParamNoFirst, ParamTrue, FullURL : string): string; overload;
		function BoolToInt(b: Boolean): Integer;
		function IntToBool(i: Integer): Boolean;
		function GzipDecompress(ResStream: TStream; ContentEncoding: string): string;
		procedure LoadKeySetting(ActionList: TActionList);
		procedure SaveKeySetting(ActionList: TActionList);
		procedure LoadEditorKeySetting(ActionList: TActionList);
		procedure SaveEditorKeySetting(ActionList: TActionList);

		procedure CreateProcess(const AppPath: string; const Param: string);
		procedure OpenBrowser(URL: string; BrowserType: TGikoBrowserType);
		function HTMLDecode(const AStr: String): String;
		function GetHRefText(s: string): string;
		function Is2chHost(Host: string): Boolean;
		function Parse2chURL(const url: string; const path: string; const document: string; var BBSID: string; var BBSKey: string): Boolean;
		function Parse2chURL2(URL: string): TPathRec;
		procedure ParseURI(const URL : string; var Protocol, Host, Path, Document, Port, Bookmark: string);
		function GetVersionBuild: Integer;
		function	GetBrowsableThreadURL( inURL : string ) : string;
		function	GetThreadURL2BoardURL( inURL : string ) : string;
		function	Get2chThreadURL2BoardURL( inURL : string ) : string;
		function	Get2chBrowsableThreadURL( inURL : string ) : string;
		function	Get2chBoard2ThreadURL( inBoard : TBoard; inKey : string ) : string;
		procedure ListBoardFile;
		procedure ReadBoardFile( bbs : TBBS );

		function	GetUnknownCategory : TCategory;
		function	GetUnknownBoard( inPlugIn : TBoardPlugIn; inURL : string ) : TBoard;

		procedure GetPopupResNumber(URL : string; var stRes, endRes : Int64);

		//Samba24̃t@C݂邩B݂ȂꍇAdefaultt@Crename
		procedure SambaFileExists();

		property Bayesian : TGikoBayesian read FBayesian write FBayesian;
		function GetSameIDResAnchor(const AID : string; ThreadItem: TThreadItem; limited: boolean):string; overload;
		function GetSameIDResAnchor(AIDNum : Integer; ThreadItem: TThreadItem; limited: boolean):string; overload;
		procedure GetSameIDRes(const AID : string; ThreadItem: TThreadItem;var body: TStringList); overload;
		procedure GetSameIDRes(AIDNum : Integer; ThreadItem: TThreadItem;var body: TStringList); overload;
		function GetSameIDResCount(const AID : string; ThreadItem: TThreadItem):Integer; overload;
		function GetSameIDResCount(AIDNum : Integer; ThreadItem: TThreadItem):Integer; overload;

		//! P
		procedure SpamCountWord( const text : string; wordCount : TWordCount );
		//! wKNA
		procedure SpamForget( wordCount : TWordCount; isSpam : Boolean );
		//! XpwK
		procedure SpamLearn( wordCount : TWordCount; isSpam : Boolean );
		//! Xpx
		function SpamParse( const text : string; wordCount : TWordCount ) : Extended;
		//AtłłȂƂ𒲂ׂ
		function NotDateorTimeString(const AStr : string): boolean;

		//ɑĂt/IDBE̕񂪂Avt@Cւ̃Nǉ
		function AddBeProfileLink(AID : string; ANum: Integer): string;
		//o[W̎擾
		function GetVersionInfo(KeyWord: TVerResourceKey): string;
		//Plugin̏̎擾
		function GetPluginsInfo(): string;
		//IẼo[W̎擾
		function GetIEVersion: string;
		function SetUserOptionalStyle(): string;
	end;

var
	GikoSys: TGikoSys;
const
	//LENGTH_RESTITLE			= 40;
	ZERO_DATE: Integer	= 25569;
	BETA_VERSION_NAME_E = 'beta';
	BETA_VERSION_NAME_J = '';
	BETA_VERSION				= 51;
	BETA_VERSION_BUILD	= '';				//debugłȂ
	APP_NAME						= 'gikoNavi';
	BE_PHP_URL = 'http://be.2ch.net/test/p.php?i=';


implementation

uses
	Giko, RoundData, Favorite, Registry, HTMLCreate, MojuUtils;

const
	FOLDER_INDEX_VERSION					= '1.01';
	USER_AGENT										= 'Monazilla';
	DEFAULT_NGWORD_FILE_NAME : String = 'NGword.txt';
	NGWORDs_DIR_NAME : String 		= 'NGwords';

	READ_PATH: string = 			'/test/read.cgi/';
	OLD_READ_PATH: string =		'/test/read.cgi?';
	KAKO_PATH: string = 			'/kako/';

	KeyWordStr: array [TVerResourceKey] of String = (
		  'Comments',
		  'CompanyName',
		  'FileDescription',
		  'FileVersion',
		  'InternalName',
		  'LegalCopyright',
		  'LegalTrademarks',
		  'OriginalFilename',
		  'PrivateBuild',
		  'ProductName',
		  'ProductVersion',
		  'SpecialBuild');

(*************************************************************************
 *GikoSysRXgN^
 *************************************************************************)
constructor TGikoSys.Create;
begin
	FSetting := TSetting.Create;
	FDolib := TDolib.Create;
	FAWKStr := TAWKStr.Create(nil);
	if DirectoryExists(GetConfigDir) = false then begin
		CreateDir(GetConfigDir);
	end;
	FAbon := TAbon.Create;
    FAbon.IgnoreKana := FSetting.IgnoreKana;
	FAbon.Setroot(GetConfigDir+NGWORDs_DIR_NAME);
	FAbon.GoHome;
	FAbon.ReturnNGwordLineNum := FSetting.ShowNGLinesNum;
	FAbon.SetNGResAnchor := FSetting.AddResAnchor;
	FAbon.DeleteSyria := FSetting.DeleteSyria;
	FAbon.Deleterlo := FSetting.AbonDeleterlo;
	FAbon.Replaceul := FSetting.AbonReplaceul;
	FAbon.AbonPopupRes := FSetting.PopUpAbon;

	FSelectResFilter := TAbon.Create;
    FSelectResFilter.IgnoreKana := True;
	// i荞ނƂ͋ɗ͈ꗗق̂ő͊Sɍ폜
	FSelectResFilter.AbonString := '';
    //
	ResRange := FSetting.ResRange;
	FVersion := Trim(GetVersionInfo(vrFileVersion));
	FBayesian := TGikoBayesian.Create;
	//FBoardURLList := TStringList.Create;
end;

(*************************************************************************
 *GikoSysfXgN^
 *************************************************************************)
destructor TGikoSys.Destroy;
var
	i: Integer;
	FileList: TStringList;
begin
	//Xbhf[^t@CXV
//	FlashExitWrite;

//	FExitWrite.Free;
	FBayesian.Free;
	FAWKStr.Free;
	FSetting.Free;
	FDolib.Free;
	FAbon.Free;
	FSelectResFilter.Free;
	//FBoardURLList.Free;
	//e|HTML폜
	FileList := TStringList.Create;
	try
        FileList.BeginUpdate;
		GetFileList(GetTempFolder, '*.html', FileList, False, True);
        FileList.EndUpdate;
		for i := 0 to FileList.Count - 1 do begin
			DeleteFile(FileList[i]);
		end;
	finally
		FileList.Free;
	end;
	inherited;
end;

(*************************************************************************
 *񐔎`FbN
 *************************************************************************)
{$HINTS OFF}
function TGikoSys.IsNumeric(s: string): boolean;
var
	e: integer;
	v: integer;
begin
	Val(s, v, e);
	Result := e = 0;
end;
{$HINTS ON}

(*************************************************************************
 *񕂓_`FbN
 *************************************************************************)
function TGikoSys.IsFloat(s: string): boolean;
var
	v: Extended;
begin
	Result := TextToFloat(PChar(s), v, fvExtended);
end;

(*************************************************************************
 *{[ht@C擾ipX{t@Cj
 *************************************************************************)
function TGikoSys.GetBoardFileName: string;
begin
	Result := Setting.GetBoardFileName;
end;

(*************************************************************************
 *{[ht@C擾ipX{t@Cj
 *************************************************************************)
function TGikoSys.GetCustomBoardFileName: string;
begin
	Result := Setting.GetCustomBoardFileName;
end;

(*************************************************************************
 *e|tH_[擾
 *************************************************************************)
function TGikoSys.GetHtmlTempFileName: string;
begin
	Result := Setting.GetHtmlTempFileName;
end;


(*************************************************************************
 *st@CtH_擾
 *************************************************************************)
function TGikoSys.GetAppDir: string;
begin
	Result := Setting.GetAppDir;
end;

(*************************************************************************
 *TempHtmlt@C擾ipX{t@Cj
 *************************************************************************)
function TGikoSys.GetTempFolder: string;
begin
	Result := Setting.GetTempFolder;
end;

(*************************************************************************
 *sent.init@C擾ipX{t@Cj
 *************************************************************************)
function TGikoSys.GetSentFileName: string;
begin
	Result := Setting.GetSentFileName;
end;

(*************************************************************************
 *outbox.init@C擾ipX{t@Cj
 *************************************************************************)
function TGikoSys.GetOutBoxFileName: string;
begin
	Result := Setting.GetOutBoxFileName;
end;

(*************************************************************************
 *ConfigtH_擾
 *************************************************************************)
function TGikoSys.GetConfigDir: string;
begin
	Result := Setting.GetConfigDir;
end;

function TGikoSys.GetStyleSheetDir: string;
begin
	Result := Setting.GetStyleSheetDir;
end;

function TGikoSys.GetSkinDir: string;
begin
	Result := Setting.GetSkinDir;
end;

function TGikoSys.GetSkinHeaderFileName: string;
begin
	Result := Setting.GetSkinHeaderFileName;
end;

function TGikoSys.GetSkinFooterFileName: string;
begin
	Result := Setting.GetSkinFooterFileName;
end;

function TGikoSys.GetSkinNewResFileName: string;
begin
	Result := Setting.GetSkinNewResFileName;
end;

function TGikoSys.GetSkinResFileName: string;
begin
	Result := Setting.GetSkinResFileName;
end;

function TGikoSys.GetSkinBookmarkFileName: string;
begin
	Result := Setting.GetSkinBookmarkFileName;
end;

function TGikoSys.GetSkinNewmarkFileName: string;
begin
	Result := Setting.GetSkinNewmarkFileName;
end;

// UserAgent擾
function TGikoSys.GetUserAgent: string;
begin
	if Dolib.Connected then begin
		Result := Format('%s %s/%s%d/%s', [
								Dolib.UserAgent,
								APP_NAME,
								BETA_VERSION_NAME_E,
								BETA_VERSION,
								Version]);
	end else begin
		Result := Format('%s/%s %s/%s%d/%s', [
								USER_AGENT,
								Dolib.Version,
								APP_NAME,
								BETA_VERSION_NAME_E,
								BETA_VERSION,
								Version]);
	end;
end;

(*************************************************************************
 *Q˂擾
 *************************************************************************)
function TGikoSys.Get2chDate(aDate: TDateTime): string;
var
	d2: TDateTime;
begin
	d2 := aDate - EncodeTime(9, 0, 0, 0);
	Result := FloatToStr(Trunc((d2 - ZERO_DATE) * 86400));
end;

//vaĺA1970/1/1/ 00:00:00 ̌oߎ
function TGikoSys.IntToDateTime(val: Int64): TDateTime;
begin
	Result := ZERO_DATE + val / 86400.0;
end;
//ADate1970/1/1/ 00:00:00 ̌oߎԂɕϊ
function TGikoSys.DateTimeToInt(ADate: TDateTime): Int64;
begin
	Result := Trunc((ADate - ZERO_DATE) * 86400);
end;


(*************************************************************************
 *Subjectt@CRead
 *************************************************************************)
procedure TGikoSys.ReadSubjectFile(Board: TBoard);
var
	ThreadItem: TThreadItem;
	FileName: string;
	FileList: TStringList;
	TmpFileList: TStringList;
	Index: Integer;
	sl: TStringList;
	i: Integer;
	Rec: TIndexRec;
	UnRead: Integer;
	ini: TMemIniFile;
	ResRec: TResRec;
//	RoundItem: TRoundItem;
//	idx: Integer;
	usePlugIn : Boolean;
	tmpStr: string;
	BoardPath : String;
	server : String;
	islog : Boolean;
	//protocol, host, path, document, port, bookmark	: string;
	//is2ch : Boolean;
	{*
	FavoThreadItem : TFavoriteThreadItem;
	Node: TTreeNode;
	*}
begin
	if Board.IsThreadDatRead then
		Exit;
	Board.Clear;
	UnRead := 0;
	//is2ch := false;
	usePlugIn := Board.IsBoardPlugInAvailable;
	server :=  UrlToServer( Board.URL );
	//is2ch := Is2chHost(server);

	FileName := Board.GetFolderIndexFileName;

	FileList := TStringList.Create;
	FileList.Sorted := True;
	FileList.BeginUpdate;
	TmpFileList := TStringList.Create;
	TmpFileList.Sorted := True;
	TmpFileList.BeginUpdate;
	//IsLogFilepDATt@CXg
	GetFileList(ExtractFileDir(Board.GetFolderIndexFileName), '*.dat', FileList, False);
	FileList.EndUpdate;
	//OُIpTmpt@CXg
	GetFileList(ExtractFileDir(Board.GetFolderIndexFileName), '*.tmp', TmpFileList, False);
	TmpFileList.EndUpdate;

	// dh
	Board.BeginUpdate;
	Board.Sorted := True;

	sl := TStringList.Create;
	try
		if FileExists(FileName) then begin
			sl.LoadFromFile(FileName);

			//QsڂiPsڂ̓o[Wj
			for i := sl.Count - 1 downto 1 do begin
				Rec := ParseIndexLine(sl[i]);
				islog := FileList.Find( Rec.FFileName, Index );
				if usePlugIn then
					ThreadItem := TThreadItem.Create(
							Board.BoardPlugIn,
							Board,
							Board.BoardPlugIn.FileName2ThreadURL( DWORD( Board ), Rec.FFileName ) )
				else begin
					if Board.is2ch then begin
						ThreadItem := TThreadItem.Create(
							nil,
							Board,
							server + 'test/read.cgi/' + Board.BBSID + '/' + ChangeFileExt( Rec.FFileName, '' ) + '/l50',
							islog,
							Rec.FFileName
							);
					end else begin
						ThreadItem := TThreadItem.Create(
							nil,
							Board,
							server + 'test/read.cgi?bbs=' + Board.BBSID + '&key=' + ChangeFileExt( Rec.FFileName, '' ) + '&ls=50',
							islog,
							Rec.FFileName
							);
					end;
				end;

				ThreadItem.BeginUpdate;
				if islog then
					FileList.Delete( Index );

				ThreadItem.No := Rec.FNo;
				ThreadItem.FileName := Rec.FFileName;
				ThreadItem.Title := Rec.FTitle;
				//ThreadItem.ShortTitle := CustomStringReplace(ZenToHan(ThreadItem.Title), ' ', '');
				ThreadItem.Count := Rec.FCount;
				ThreadItem.Size := Rec.FSize;
//			ThreadItem.RoundNo := Rec.FRoundNo;
				ThreadItem.RoundDate := Rec.FRoundDate;
				ThreadItem.LastModified := Rec.FLastModified;
				ThreadItem.Kokomade := Rec.FKokomade;
				ThreadItem.NewReceive := Rec.FNewReceive;
//			ThreadItem.Round := Rec.FRound;
				ThreadItem.UnRead := Rec.FUnRead;
				ThreadItem.ScrollTop := Rec.FScrollTop;
				ThreadItem.AllResCount := Rec.FAllResCount;
				ThreadItem.NewResCount := Rec.FNewResCount;
				ThreadItem.AgeSage := Rec.FAgeSage;
				ThreadItem.ParentBoard := Board;
				{* CɓʐR[h *}
				{*
				FavoThreadItem := TFavoriteThreadItem.Create( ThreadItem.URL, ThreadItem.Title, ThreadItem );
				Node := FavoriteDM.TreeView.Items.AddChildObject( FavoriteDM.TreeView.Items.Item[0], ThreadItem.Title, FavoThreadItem);
				*}

				{//񃊃Xgɑ݂珄tOZbg
				if ThreadItem.IsLogFile then begin
					idx := RoundList.Find(ThreadItem);
					if idx <> -1 then begin
						RoundItem := RoundList.Items[idx, grtItem];
						ThreadItem.RoundName := RoundItem.RoundName;
						ThreadItem.Round := True;
					end;
				end;
				}

				ThreadItem.EndUpdate;
				Board.Add(ThreadItem);

				if (ThreadItem.IsLogFile) and (ThreadItem.UnRead) then
					Inc(UnRead);
			end;
		end;

		if UnRead <> Board.UnRead then
			Board.UnRead := UnRead;

		Boardpath := ExtractFilePath(Board.GetFolderIndexFileName);
		//CfbNXɖOǉiCfbNXΉj
		for i := 0 to FileList.Count - 1 do begin
			FileName := Boardpath + FileList[i];

			//ResRec := DivideStrLine(ReadThreadFile(FileName, 1));
			if usePlugIn then begin
				ThreadItem := TThreadItem.Create(
					Board.BoardPlugIn,
					Board,
					Board.BoardPlugIn.FileName2ThreadURL( DWORD( Board ), FileList[i] ) );
				ResRec := DivideStrLine(Board.BoardPlugIn.GetDat( DWORD( ThreadItem ), 1 ));
			end else begin
				ThreadItem := TThreadItem.Create(
					nil,
					Board,
					Get2chBoard2ThreadURL( Board, ChangeFileExt( FileList[i], '' ) ) );
				ResRec := DivideStrLine(ReadThreadFile(FileName, 1));
			end;

			ThreadItem.BeginUpdate;
			ThreadItem.FileName := FileList[i];
			//ThreadItem.FilePath := FileName;
			ThreadItem.No := Board.Count + 1;
			ThreadItem.Title := ResRec.FTitle;
			ThreadItem.Count := GetFileLineCount(FileName);
			ThreadItem.AllResCount := ThreadItem.Count;
			ThreadItem.NewResCount := ThreadItem.Count;
			ThreadItem.Size := GetFileSize(FileName) - ThreadItem.Count;//1byteƂ邯ǂ͂߂
			ThreadItem.RoundDate := ZERO_DATE;
			ThreadItem.LastModified := ZERO_DATE;
			ThreadItem.Kokomade := -1;
			ThreadItem.NewReceive := ThreadItem.Count;
			ThreadItem.ParentBoard := Board;
			ThreadItem.IsLogFile := True;
			ThreadItem.Round := False;
			ThreadItem.UnRead := False;
			ThreadItem.ScrollTop := 0;
			ThreadItem.AgeSage := gasNone;
			ThreadItem.EndUpdate;
			Board.Add(ThreadItem);
		end;
		Board.EndUpdate;

		//OُI`FbN
		for i := TmpFileList.Count - 1 downto 0 do begin
		//if TmpFileList.Count <> 0 then begin
			ThreadItem := Board.FindThreadFromFileName(ChangeFileExt(TmpFileList[i], '.dat'));
			if ThreadItem <> nil then begin
			//if TmpFileList.Find(ChangeFileExt(ThreadItem.FileName, '.tmp'), Index) then begin
				ini := TMemIniFile.Create(Boardpath + TmpFileList[i]);
				try
					tmpStr := ini.ReadString('Setting', 'RoundDate', DateTimeToStr(ZERO_DATE));
					ThreadItem.RoundDate := ConvertDateTimeString(tmpStr);

					tmpStr := ini.ReadString('Setting', 'LastModified', DateTimeToStr(ZERO_DATE));
					ThreadItem.LastModified := ConvertDateTimeString(tmpStr);
					ThreadItem.Count := ini.ReadInteger('Setting', 'Count', 0);
					ThreadItem.NewReceive := ini.ReadInteger('Setting', 'NewReceive', 0);

					ThreadItem.Size := ini.ReadInteger('Setting', 'Size', 0);
					if(ThreadItem.Size = 0) and (FileExists(ThreadItem.GetThreadFileName)) then begin
						try
							ThreadItem.Size := GetFileSize(ThreadItem.GetThreadFileName) - ThreadItem.Count;
						except
						end;
					end;

                    //̐ݒRoundData̕邩珟ɐݒ肵Ă̓_I@by 
					//ThreadItem.Round := ini.ReadBool('Setting', 'Round', False);
					//ThreadItem.RoundName := ini.ReadString('Setting', 'RoundName', ThreadItem.RoundName);
					ThreadItem.UnRead := False;//ini.ReadBool('Setting', 'UnRead', False);
					ThreadItem.ScrollTop := ini.ReadInteger('Setting', 'ScrollTop', 0);
					ThreadItem.AllResCount := ini.ReadInteger('Setting', 'AllResCount', ThreadItem.Count);
					ThreadItem.NewResCount := ini.ReadInteger('Setting', 'NewResCount', 0);
					ThreadItem.AgeSage := TGikoAgeSage(ini.ReadInteger('Setting', 'AgeSage', Ord(gasNone)));
				finally
					ini.Free;
				end;
				DeleteFile(Boardpath + TmpFileList[i]);
			end;
		end;

	finally
		sl.Free;
		FileList.Free;
		TmpFileList.Free;
		Board.Sorted := False;
	end;
	Board.IsThreadDatRead := True;
end;

(*************************************************************************
 *XbhCfbNXt@C(Folder.idx)쐬
 *************************************************************************)
procedure TGikoSys.CreateThreadDat(Board: TBoard);
var
	i: integer;
	s: string;
	SubjectList: TStringList;
	sl: TStringList;
	Rec: TSubjectRec;
	FileName: string;
	cnt: Integer;
begin
	if not FileExists(Board.GetSubjectFileName) then Exit;
	FileName := Board.GetFolderIndexFileName;

	SubjectList := TStringList.Create;
	try
		SubjectList.LoadFromFile(Board.GetSubjectFileName);
		sl := TStringList.Create;
		try
			cnt := 1;
			sl.BeginUpdate;
			sl.Add(FOLDER_INDEX_VERSION);
			for i := 0 to SubjectList.Count - 1 do begin
				Rec := DivideSubject(SubjectList[i]);

				if (Trim(Rec.FFileName) = '') or (Trim(Rec.FTitle) = '') then
					Continue;

				{s := Format('%x', [cnt]) + #1					//ԍ
					 + Rec.FFileName + #1								//t@C
					 + Rec.FTitle + #1									//^Cg
					 + Format('%x', [Rec.FCount]) + #1	//JEg
					 + Format('%x', [0]) + #1						//size
					 + Format('%x', [0]) + #1						//RoundDate
					 + Format('%x', [0]) + #1						//LastModified
					 + Format('%x', [0]) + #1						//Kokomade
					 + Format('%x', [0]) + #1						//NewReceive
					 + '0' + #1					 							//gp
					 + Format('%x', [0]) + #1						//UnRead
					 + Format('%x', [0]) + #1						//ScrollTop
					 + Format('%x', [Rec.FCount]) + #1	//AllResCount
					 + Format('%x', [0]) + #1						//NewResCount
					 + Format('%x', [0]);								//AgeSage
				}
				s := Format('%x'#1'%s'#1'%s'#1'%x'#1'%x'#1'%x'#1'%x'#1'%x'#1'%x'#1 + 
							'%s'#1'%x'#1'%x'#1'%x'#1'%x'#1'%x',
					[cnt,			//ԍ
					 Rec.FFileName, //t@C
					 Rec.FTitle,    //^Cg
					 Rec.FCount,     //JEg
					 0,             //size
					 0,             //RoundDate
					 0,				//LastModified
					 0,				//Kokomade
					 0,				//NewReceive
					 '0',			//gp
					 0,				//UnRead
					 0,				//ScrollTop
					 Rec.FCount,	//AllResCount
					 0,				//NewResCount
					 0]             //AgeSage
					);

				sl.Add(s);
				inc(cnt);
			end;
			sl.EndUpdate;
			sl.SaveToFile(FileName);
		finally
			sl.Free;
		end;
	finally
		SubjectList.Free;
	end;
end;

(*************************************************************************
 *XbhCfbNX(Thread.dat)
 *Public
 *************************************************************************)
procedure TGikoSys.WriteThreadDat(Board: TBoard);
//const
//	Values: array[Boolean] of string = ('0', '1');
var
	i: integer;
	FileName: string;
	sl: TStringList;
	s: string;
	TmpFileList: TStringList;
begin
	if not Board.IsThreadDatRead then
		Exit;
	FileName := Board.GetFolderIndexFileName;
	ForceDirectoriesEx( ExtractFilePath( FileName ) );

	sl := TStringList.Create;
	TmpFileList := TStringList.Create;
	TmpFileList.Sorted := true;
	try
        TmpFileList.BeginUpdate;
		GetFileList(ExtractFileDir(Board.GetFolderIndexFileName), '*.tmp', TmpFileList, false);
        TmpFileList.EndUpdate;
		sl.BeginUpdate;
		sl.Add(FOLDER_INDEX_VERSION);

		// Xԍۑ̂߃\[g
		Sort.SortNoFlag := true;
		Sort.SortOrder := true;
		Sort.SortIndex := 0;
		//Sort.SortNonAcquiredCountFlag := GikoSys.Setting.NonAcquiredCount;
		Board.CustomSort(ThreadItemSortProc);

		for i := 0 to Board.Count - 1 do begin
			Board.Items[i].No := i + 1;
			s := Format('%x'#1'%s'#1'%s'#1'%x'#1'%x'#1'%x'#1'%x'#1'%x'#1'%x'#1 +
							'%s'#1'%x'#1'%x'#1'%x'#1'%x'#1'%x',
					[Board.Items[i].No,			//ԍ
					 Board.Items[i].FileName, //t@C
					 Board.Items[i].Title,    //^Cg
					 Board.Items[i].Count,     //JEg
					 Board.Items[i].Size,             //size
					 DateTimeToInt(Board.Items[i].RoundDate),             //RoundDate
					 DateTimeToInt(Board.Items[i].LastModified),				//LastModified
					 Board.Items[i].Kokomade,				//Kokomade
					 Board.Items[i].NewReceive,				//NewReceive
					 '0',			//gp
					 BoolToInt(Board.Items[i].UnRead),				//UnRead
					 Board.Items[i].ScrollTop,				//ScrollTop
					 Board.Items[i].AllResCount,	//AllResCount
					 Board.Items[i].NewResCount,				//NewResCount
					 Ord(Board.Items[i].AgeSage)]             //AgeSage
					);

			sl.Add(s);
		end;
		sl.EndUpdate;
		sl.SaveToFile(FileName);

		for i := 0 to TmpFileList.Count - 1 do begin
			DeleteFile(ExtractFilePath(Board.GetFolderIndexFileName) + TmpFileList[i]);
		end;

	finally
		TmpFileList.Free;
		sl.Free;
	end;
end;

function TGikoSys.ParseIndexLine(Line: string): TIndexRec;
begin
	Result.FNo := StrToIntDef('$' + RemoveToken(Line, #1), 0);
	Result.FFileName := RemoveToken(Line, #1);
	Result.FTitle := RemoveToken(Line, #1);
	Result.FCount := StrToIntDef('$' + RemoveToken(Line, #1), 0);
	Result.FSize := StrToIntDef('$' + RemoveToken(Line, #1), 0);
	Result.FRoundDate := IntToDateTime(StrToIntDef('$' + RemoveToken(Line, #1), ZERO_DATE));
	Result.FLastModified := IntToDateTime(StrToIntDef('$' + RemoveToken(Line, #1), ZERO_DATE));
	Result.FKokomade := StrToIntDef('$' + RemoveToken(Line, #1), -1);
	Result.FNewReceive := StrToIntDef('$' + RemoveToken(Line, #1), 0);
	RemoveToken(Line, #1);//9: ;	//gp
	Result.FUnRead := IntToBool(StrToIntDef('$' + RemoveToken(Line, #1), 0));
	Result.FScrollTop := StrToIntDef('$' + RemoveToken(Line, #1), 0);
	Result.FAllResCount := StrToIntDef('$' + RemoveToken(Line, #1), 0);
	Result.FNewResCount := StrToIntDef('$' + RemoveToken(Line, #1), 0);
	Result.FAgeSage := TGikoAgeSage(StrToIntDef('$' + RemoveToken(Line, #1), 0));

end;

//wtH_̎wt@Cꗗ擾
// ListFiles('c:\', '*.txt', list, True);
procedure TGikoSys.GetFileList(Path: string; Mask: string; var List: TStringList; SubDir: Boolean; IsPathAdd: Boolean);
var
	rc: Integer;
	SearchRec : TSearchRec;
	s: string;
	maskExt: string;
begin
	//maskExt := Copy(Mask, 1, Length(Mask) - 1);
    maskExt := Mask;
	Path := IncludeTrailingPathDelimiter(Path);
	rc := FindFirst(Path + '*.*', faAnyfile, SearchRec);
	try
		while rc = 0 do begin
			if (SearchRec.Name <> '..') and (SearchRec.Name <> '.') then begin
				s := Path + SearchRec.Name;
				//if (SearchRec.Attr and faDirectory > 0) then
				//	s := IncludeTrailingPathDelimiter(s)

				if (SearchRec.Attr and faDirectory = 0) and (MatchesMask(s, Mask)) then
						if IsPathAdd then
							List.Add(s)
						else
							List.Add(SearchRec.Name);
				if SubDir and (SearchRec.Attr and faDirectory > 0) then
					GetFileList(s, Mask, List, True, IsPathAdd);
			end;
			rc := FindNext(SearchRec);
		end;
	finally
		SysUtils.FindClose(SearchRec);
	end;
	List.Sort;
end;
//wtH_̎wt@Cꗗ擾
//TutH_͌Ȃ
// ListFiles('c:\', '*.txt', list, True);
procedure TGikoSys.GetFileList(Path: string; Mask: string; var List: TStringList; IsPathAdd: Boolean);
var
	rc: Integer;
	SearchRec : TSearchRec;
	s: string;
begin
	Path := IncludeTrailingPathDelimiter(Path);
	rc := FindFirst(Path + Mask, faAnyfile, SearchRec);
	try
		while rc = 0 do begin
			if (SearchRec.Name <> '..') and (SearchRec.Name <> '.') then begin
				s := Path + SearchRec.Name;

				if (SearchRec.Attr and faDirectory = 0) then
						if IsPathAdd then
							List.Add(s)
						else
							List.Add(SearchRec.Name);
			end;
			rc := FindNext(SearchRec);
		end;
	finally
		SysUtils.FindClose(SearchRec);
	end;
	List.Sort;
end;
//wtH_̃fBNgꗗ擾
procedure TGikoSys.GetDirectoryList(Path: string; Mask: string; List: TStringList; SubDir: Boolean);
var
	rc: Integer;
	SearchRec : TSearchRec;
	s: string;
begin
	Path := IncludeTrailingPathDelimiter(Path);
	rc := FindFirst(Path + '*.*', faDirectory, SearchRec);
	try
		while rc = 0 do begin
			if (SearchRec.Name <> '..') and (SearchRec.Name <> '.') then begin
				s := Path + SearchRec.Name;
				//if (SearchRec.Attr and faDirectory > 0) then
				//	s := IncludeTrailingPathDelimiter(s)

				if (SearchRec.Attr and faDirectory > 0) and (MatchesMask(s, Mask)) then
					List.Add( IncludeTrailingPathDelimiter( s ) );
				if SubDir and (SearchRec.Attr and faDirectory > 0) then
					GetDirectoryList(s, Mask, List, True);
			end;
			rc := FindNext(SearchRec);
		end;
	finally
		SysUtils.FindClose(SearchRec);
	end;
end;


(*************************************************************************
 *TuWFNgs𕪊
 *************************************************************************)
function TGikoSys.DivideSubject(Line: string): TSubjectRec;
var
	i: integer;
	ws: WideString;
	Delim: string;
	LeftK: string;
	RightK: string;
begin
	Result.FCount := 0;

	if AnsiPos('<>', Line) = 0 then
		Delim := ','
	else
		Delim := '<>';
	Result.FFileName := RemoveToken(Line, Delim);
	Result.FTitle := Trim(RemoveToken(Line, Delim));

	ws := Result.FTitle;
	if Copy(ws, Length(ws), 1) = ')' then begin
		LeftK := '(';
		RightK := ')';
	end else if Copy(ws, Length(ws)-1, 2) = 'j' then begin
		LeftK := 'i';
		RightK := 'j';
	end else if Copy(ws, Length(ws), 1) = '>' then begin
		LeftK := '<';
		RightK := '>';
	end;
	for i := Length(ws) - 1 downto 1 do begin
		if Copy(ws, i, Length(LeftK)) = LeftK then begin
			Result.FTitle := TrimRight(Copy(ws, 1, i - 1));
			ws := Copy(ws, i + Length(LeftK), Length(ws) - i - Length(RightK));
			if IsNumeric(ws) then
				Result.FCount := StrToInt(ws);
			//Delete(Result.FTitle, i, Length(LeftK) + Length(ws) + Length(RightK));
			break;
		end;
	end;
end;

(*************************************************************************
 * datt@C̈ꃉC𕪉
 *************************************************************************)
function TGikoSys.DivideStrLine(Line: string): TResRec;
var
	Delim: string;
begin
	if AnsiPos('<>', Line) = 0 then begin
		//Delim := ',';
		//Result.FType := glt2chOld;
        Line := CustomStringReplace(Line, '<>', '&lt;&gt;');
		Line := CustomStringReplace(Line, ',', '<>');
		Line := CustomStringReplace(Line, 'M', ',');
	end;
	Delim := '<>';
	Result.FType := glt2chNew;
	//TrimĂ͂ȂC@by
	Result.FName := RemoveToken(Line, Delim);
	Result.FMailTo := RemoveToken(Line, Delim);
	Result.FDateTime := RemoveToken(Line, Delim);
	Result.FBody := RemoveToken(Line, Delim);
	//󂾂Ɩ肪N邩A󔒂ݒ肷
	if Result.FBody = '' then begin
		Result.FBody := '&nbsp;';
	end else if ( Result.FBody[1] = ' ' ) then begin
		//Q˂ƂƁA{̐擪ɂPp󔒂Ă̂ō폜
		//̌fŁAX̂̋󔒂Ȃǂ͒߂
		Delete(Result.FBody, 1, 1);
	end;
	//Result.FTitle := Trim(RemoveToken(Line, Delim));
	Result.FTitle := RemoveToken(Line, Delim);

end;

(*************************************************************************
 * URLBBSID擾
 *************************************************************************)
function TGikoSys.UrlToID(url: string): string;
var
	i: integer;
begin
	Result := '';
	url := Trim(url);

	if url = '' then Exit;
	try
		url := Copy(url, 0, Length(url) - 1);
		for i := Length(url) downto 0 do begin
			if url[i] = '/' then begin
				Result := Copy(url, i + 1, Length(url));
				Break;
			end;
		end;
	except
		Result := '';
	end;
end;

(*************************************************************************
 *URLBBSIDȊO̕(http://teri.2ch.net/)擾
 *************************************************************************)
function TGikoSys.UrlToServer(url: string): string;
var
	i: integer;
	wsURL: WideString;
begin
	Result := '';
	wsURL := url;
	wsURL := Trim(wsURL);

	if wsURL = '' then exit;

	if Copy(wsURL, Length(wsURL), 1) = '/' then
		wsURL := Copy(wsURL, 0, Length(wsURL) - 1);

	for i := Length(wsURL) downto 0 do begin
		if wsURL[i] = '/' then begin
			Result := Copy(wsURL, 0, i);
			break;
		end;
	end;
end;

(*************************************************************************
 *fBNg݂邩`FbN
 *************************************************************************)
function TGikoSys.DirectoryExistsEx(const Name: string): Boolean;
var
	Code: Integer;
begin
	Code := GetFileAttributes(PChar(Name));
	Result := (Code <> -1) and (FILE_ATTRIBUTE_DIRECTORY and Code <> 0);
end;

(*************************************************************************
 *fBNg쐬iKwΉj
 *************************************************************************)
function TGikoSys.ForceDirectoriesEx(Dir: string): Boolean;
begin
	Result := True;
	if Length(Dir) = 0 then
		raise Exception.Create('tH_쐬o܂');
	Dir := ExcludeTrailingPathDelimiter(Dir);
	if (Length(Dir) < 3) or DirectoryExistsEx(Dir)
		or (ExtractFilePath(Dir) = Dir) then Exit; // avoid 'xyz:\' problem.
	Result := ForceDirectoriesEx(ExtractFilePath(Dir)) and CreateDir(Dir);
end;

(*************************************************************************
 *񂩂g[N̐؂oij
 *FDelphĩpN
 *************************************************************************)
function TGikoSys.StrTokFirst(const s:string; const sep: TStrTokSeparator; var Rec: TStrTokRec): string;
begin
	Rec.Str := s;
	Rec.Pos := 1;
	Result := StrTokNext(sep, Rec);
end;

(*************************************************************************
 *񂩂g[N̐؂o
 *FDelphĩpN
 *************************************************************************)
function TGikoSys.StrTokNext(const sep: TStrTokSeparator; var Rec: TStrTokRec): string;
var
	Len, I: Integer;
begin
	with Rec do	begin
		Len := Length(Str);
		Result := '';
		if Len >= Pos then begin
			while (Pos <= Len) and (Str[Pos] in sep) do begin
			 Inc(Pos);
			end;
			I := Pos;
			while (Pos<= Len) and not (Str[Pos] in sep) do begin
				if IsDBCSLeadByte(Byte(Str[Pos])) then begin
					Inc(Pos);
				end;
				Inc(Pos);
			end;
			Result := Copy(Str, I, Pos - I);
			while (Pos <= Len) and (Str[Pos] in sep) do begin// ͂D
				Inc(Pos);
			end;
		end;
	end;
end;

(*************************************************************************
 *t@CTCY擾
 *************************************************************************)
function TGikoSys.GetFileSize(FileName : string): longint;
var
	F : File;
begin
	try
		if not FileExists(FileName) then begin
			Result := 0;
			Exit;
		end;
		Assign(F, FileName);
		Reset(F, 1);
		Result := FileSize(F);
		CloseFile(F);
	except
		Result := 0;
	end;
end;

(*************************************************************************
 *t@Cs擾
 *************************************************************************)
function TGikoSys.GetFileLineCount(FileName : string): longint;
var
	sl: TStringList;
begin
	sl := TStringList.Create;
	try
		try
			sl.LoadFromFile(FileName);
			Result := sl.Count;
		except
			Result := 0;
		end;
	finally
		sl.Free;
	end;

end;

(*************************************************************************
 *Xbht@Cws擾
 *************************************************************************)
function TGikoSys.ReadThreadFile(FileName: string; Line: Integer): string;
var
	fileTmp : TStringList;
begin
	Result := '';
	if FileExists(FileName) then begin
		fileTmp := TStringList.Create;
		try
			try
				fileTmp.LoadFromFile( FileName );
				if ( Line	>= 1 ) and ( Line	< fileTmp.Count + 1 ) then begin
					Result := fileTmp.Strings[ Line-1 ];
				end;
			except
				//on EFOpenError do Result := '';
			end;
		finally
			fileTmp.Free;
		end;
	end;
end;

(*************************************************************************
 *VXej[tHg̑擾
 *************************************************************************)
procedure TGikoSys.MenuFont(Font: TFont);
var
	lf: LOGFONT;
	nm: NONCLIENTMETRICS;
begin
	nm.cbSize := sizeof(NONCLIENTMETRICS);

	SystemParametersInfo(SPI_GETNONCLIENTMETRICS, 0, @nm, 0);
	lf := nm.lfMenuFont;

	Font.Name := lf.lfFaceName;
	Font.Height := lf.lfHeight;
	Font.Style := [];
	if lf.lfWeight >= 700 then
		Font.Style := Font.Style + [fsBold];
	if lf.lfItalic = 1 then
		Font.Style := Font.Style + [fsItalic];
end;

(*************************************************************************
 *
 *ǂ̃TCg̃pN
 *************************************************************************)
function TGikoSys.RemoveToken(var s: string;const delimiter: string): string;
var
	p: Integer;
begin
	p := AnsiPos(delimiter, s);
	if p = 0 then
		Result := s
	else
		Result := Copy(s, 1, p - 1);
	Delete(s, 1, Length(Result) + Length(delimiter));
end;

(*************************************************************************
 *
 *ǂ̃TCg̃pN
 *************************************************************************)
function TGikoSys.GetTokenIndex(s: string; delimiter: string; index: Integer): string;
var
	i: Integer;
begin
	Result := '';
	for i := 0 to index do
		Result := RemoveToken(s, delimiter);
end;

(*************************************************************************
 *
 *************************************************************************)
function TGikoSys.DeleteLink(const s: string): string;
var
	s1: string;
	s2: string;
	idx: Integer;
	i: Integer;
begin
	i := 0;
	Result := '';
	while True do begin
		s1 := GetTokenIndex(s, '<a href="', i);
		s2 := GetTokenIndex(s, '<a href="', i + 1);

		idx := Pos('">', s1);
		if idx <> 0 then
			Delete(s1, 1, idx + 1);
		idx := Pos('">', s2);
		if idx <> 0 then
			Delete(s2, 1, idx + 1);

		Result := Result + s1 + s2;

		if s2 = '' then
			Break;

		inc(i, 2);
	end;
end;

//CfbNXXVobt@tbVI
{procedure TGikoSys.FlashExitWrite;
var
	i: Integer;
begin
	//Xbhf[^t@CXV
	for i := 0 to FExitWrite.Count - 1 do
		WriteThreadDat(FExitWrite[i]);
	FExitWrite.Clear;
end;}

(*************************************************************************
 *XȂǂZOɕϊ
 *from HotZonu
 *************************************************************************)
function TGikoSys.GetShortName(const LongName: string; ALength: integer): string;
const
	ERASECHAR : array [1..39] of string =
		('','','','','','','Q','','','',
		 '','','','','','y','z','','s','t',
		 'g','h','k','l','e','f','','','','',
		 'o','p','q','r','w','x','','c', '@');
var
	Chr : array [0..255]	of	char;
	S : string;
	i : integer;
begin
	s := Trim(LongName);
	if (Length(s) <= ALength) then begin
		Result := s;
	end else begin
		S := s;
		for i := Low(ERASECHAR)	to	High(ERASECHAR) do	begin
			S := CustomStringReplace(S, ERASECHAR[i], '');
		end;
		if (Length(S) <= ALength) then begin
			Result := S;
		end else begin
			Windows.LCMapString(
					GetUserDefaultLCID(),
					LCMAP_HALFWIDTH,
					PChar(S),
					Length(S) + 1,
					chr,
					Sizeof(chr)
					);
			S := Chr;
			S := Copy(S,1,ALength);
			while true do begin
				if (ByteType(S, Length(S)) = mbLeadByte ) then begin
					S := Copy(S, 1, Length(S) - 1);
				end else begin
					Break;
				end;
			end;
			Result := S;
		end;
	end;
end;

(*************************************************************************
 *
 * from HotZonu
 *************************************************************************)
function TGikoSys.ConvRes(const Body, Bbs, Key,
	ParamBBS, ParamKey, ParamStart, ParamTo, ParamNoFirst, ParamTrue : string;
	DatToHTML: boolean = false): string;
type
	PIndex = ^TIndex;
	TIndex = record
		FIndexFrom	: integer;
		FIndexTo		: integer;
		FNo				 : string;
	end;
const
	GT	= '&gt;';
	SN	= '0123456789-';
	ZN	= 'OPQRSTUVWX|';
var
	i : integer;
	s,r : string;
	b : TMbcsByteType;
	sw: boolean;
	sp: integer;
	No: string;
	sx: string;
	List: TList;
	oc	: string;
	st, et: string;
	chk : boolean;
	al : boolean;
	procedure Add(IndexFrom, IndexTo: integer; const No: string);
	var
		FIndex : PIndex;
	begin
		New(FIndex);
		FIndex.FIndexFrom	:= IndexFrom;
		FIndex.FIndexTo		:= IndexTo;
		FIndex.FNo				 := No;
		List.Add(FIndex);
	end;
	function ChooseString(const Text, Separator: string; Index: integer): string;
	var
		S : string;
		i, p : integer;
	begin
		S :=	Text;
		for i :=	0 to	Index - 1 do	begin
			if	(AnsiPos(Separator, S) = 0) then	S :=	''
			else	S :=	Copy(S, AnsiPos(Separator, S) + Length(Separator), Length(S));
		end;
		p :=	AnsiPos(Separator, S);
		if	(p > 0) then	Result	:=	Copy(S, 1, p - 1) else Result :=	S;
	end;
begin
	{ v1.0 b2 - 03 }
	s	 :=	Body;
	r	 :=	Body;
	i	 :=	1;
	sw	:=	False;
	No	:=	'';
	List:=	TList.Create;
	oc	:=	'';
	sp	:=	0;
	chk :=	False;
	al	:=	False;
	while true	do	begin
		b :=	ByteType(s, i);
		case	b of
			mbSingleByte	: begin
				if	(not sw) and (Copy(s,i,8) = GT + GT) then	begin
					if	(AnsiPos('<A HREF', AnsiUpperCase(oc)) = 0) then	begin
						sw	:=	True;
						sp	:=	i;
						i :=	i + 7;
						oc:='';
						chk :=	True;
					end;
				end else
				if	(not sw) and (Copy(s,i,8) = GT + GT) then	begin
					if	(AnsiPos('<A HREF', AnsiUpperCase(oc)) = 1) then	begin
						i :=	i + 7;
						oc:='';
						chk :=	True;
					end;
				end else
				if	(not sw) and (Copy(s,i,4) = GT) then	begin
					if	(AnsiPos('<A HREF', AnsiUpperCase(oc)) = 0) then	begin
						sw	:=	True;
						sp	:=	i;
						i :=	i + 3;
						oc:='';
						chk :=	True;
					end;
				end else
				if	((not sw) and (Copy(s,i,1) = ',')) or
						((not sw) and (Copy(s,i,1) = '=')) then	begin
					if	((not Chk) and (AnsiLowerCase(oc) = '</a>')) or
							((Chk) and	(oc = '')) or
							((not Chk) and (al)) then
					begin
						sw	:=	True;
						sp	:=	i;
						//i :=	i + 1;
						oc:='';
					end;
				end else
				if	(sw) then begin
					sx	:=	Copy(s,i,1);
					if	(AnsiPos(sx, SN) > 0)	then	begin
						No	:=	No	+ sx;
					end else begin
						if	(No <> '') and (No <> '-')	 then	begin
							Add(sp, i, No);
							al := True;
						end;
						sw	:=	False;
						//
						i := i - 1;
						//
						No	:= '';
						oc:='';
						//chk :=	False;
					end;
				end else begin
					if	Copy(s,i,1) = '<' then	oc	:=	'';
					oc	:=	oc + Copy(s,i,1);
					chk :=	False;
					al	:=	False;
				end;
			end;
			mbLeadByte	: begin
				if	(not sw) and (Copy(s,i,4) = '') then	begin
					sw	:=	True;
					sp	:=	i;
					i :=	i + 3;
					chk :=	True;
				end else
				if	(not sw) and (Copy(s,i,2) = '') then	begin
					sw	:=	True;
					sp	:=	i;
					i :=	i + 1;
					chk :=	True;
				end else
				if	(sw) then begin
					sx	:=	Copy(s,i,2);
					if	(AnsiPos(sx, ZN) > 0)	then	begin
						No	:=	No	+ ZenToHan(sx);
					end else begin
						if	(No <> '') and (No <> '-')	and (No <> '|') then	begin
							Add(sp, i, No);
						end;
						sw	:=	False;
						i := i - 1;
						No	:=	'';
					end;
				end else begin
					oc	:=	'';
					chk :=	False;
				end;
				al	:=	False;
			end;
		end;
		inc(i);
		if	(i > Length(Body))	then	begin
			if	(sw)	then	begin
				if	(No <> '')	then	Add(sp, i, No);
			end;
			Break;
		end;
	end;
	for i :=	List.Count - 1	downto	0 do	begin
		if	(AnsiPos('-', PIndex(List[i]).FNo) > 0) then	begin
			st	:=	ChooseString(PIndex(List[i]).FNo, '-', 0);
			et	:=	ChooseString(PIndex(List[i]).FNo, '-', 1);
		end else begin
			st	:=	PIndex(List[i]).FNo;
			et	:=	PIndex(List[i]).FNo;
		end;
		if not DatToHTML then
		r :=	Copy(r,0, PIndex(List[i]).FIndexFrom - 1) +
					Format('<a href="../test/read.cgi?%s=%s&%s=%s&%s=%s&%s=%s&%s=%s" target="_blank">',
								[ParamBBS, Bbs, ParamKey, Key, ParamStart, st, ParamTo, et, ParamNoFirst, ParamTrue]) +
					Copy(r,PIndex(List[i]).FIndexFrom, PIndex(List[i]).FIndexTo - PIndex(List[i]).FIndexFrom) + '</A>' +
					Copy(r,PIndex(List[i]).FIndexTo,Length(r))
		else
		r :=	Copy(r,0, PIndex(List[i]).FIndexFrom - 1) +
					Format('<a href="#%s">', [st]) +
					Copy(r,PIndex(List[i]).FIndexFrom, PIndex(List[i]).FIndexTo - PIndex(List[i]).FIndexFrom) + '</A>' +
					Copy(r,PIndex(List[i]).FIndexTo,Length(r));

		Dispose(PIndex(List[i]));
	end;
	List.Free;
	Result	:=	r;
end;

function TGikoSys.ConvRes(
	const Body, Bbs, Key, ParamBBS, ParamKey,
    ParamStart, ParamTo, ParamNoFirst,
	ParamTrue, FullURL : string
): string;
type
	PIndex = ^TIndex;
	TIndex = record
		FIndexFrom	: integer;
		FIndexTo		: integer;
		FNo				 : string;
	end;
const
	GT	= '&gt;';
	SN	= '0123456789-';
	ZN	= 'OPQRSTUVWX|';
var
	i : integer;
	s,r : string;
	b : TMbcsByteType;
	sw: boolean;
	sp: integer;
	No: string;
	sx: string;
	List: TList;
	oc	: string;
	st, et: string;
	chk : boolean;
	al : boolean;
	procedure Add(IndexFrom, IndexTo: integer; const No: string);
	var
		FIndex : PIndex;
	begin
		New(FIndex);
		FIndex.FIndexFrom	:= IndexFrom;
		FIndex.FIndexTo		:= IndexTo;
		FIndex.FNo				 := No;
		List.Add(FIndex);
	end;
	function ChooseString(const Text, Separator: string; Index: integer): string;
	var
		S : string;
		i, p : integer;
	begin
		S :=	Text;
		for i :=	0 to	Index - 1 do	begin
			if	(AnsiPos(Separator, S) = 0) then	S :=	''
			else	S :=	Copy(S, AnsiPos(Separator, S) + Length(Separator), Length(S));
		end;
		p :=	AnsiPos(Separator, S);
		if	(p > 0) then	Result	:=	Copy(S, 1, p - 1) else Result :=	S;
	end;
begin
	{ v1.0 b2 - 03 }
	s	 :=	Body;
	r	 :=	Body;
	i	 :=	1;
	sw	:=	False;
	No	:=	'';
	List:=	TList.Create;
	oc	:=	'';
	sp	:=	0;
	chk :=	False;
	al	:=	False;
	while true	do	begin
		b :=	ByteType(s, i);
		case	b of
			mbSingleByte	: begin
				if	(not sw) and (Copy(s,i,8) = GT + GT) then	begin
					if	(AnsiPos('<A HREF', AnsiUpperCase(oc)) = 0) then	begin
						sw	:=	True;
						sp	:=	i;
						i :=	i + 7;
						oc:='';
						chk :=	True;
					end;
				end else
				if	(not sw) and (Copy(s,i,8) = GT + GT) then	begin
					if	(AnsiPos('<A HREF', AnsiUpperCase(oc)) = 1) then	begin
						i :=	i + 7;
						oc:='';
						chk :=	True;
					end;
				end else
				if	(not sw) and (Copy(s,i,4) = GT) then	begin
					if	(AnsiPos('<A HREF', AnsiUpperCase(oc)) = 0) then	begin
						sw	:=	True;
						sp	:=	i;
						i :=	i + 3;
						oc:='';
						chk :=	True;
					end;
				end else
				if	((not sw) and (Copy(s,i,1) = ',')) or
						((not sw) and (Copy(s,i,1) = '=')) then	begin
					if	((not Chk) and (AnsiLowerCase(oc) = '</a>')) or
							((Chk) and	(oc = '')) or
							((not Chk) and (al)) then
					begin
						sw	:=	True;
						sp	:=	i;
						//i :=	i + 1;
						oc:='';
					end;
				end else
				if	(sw) then begin
					sx	:=	Copy(s,i,1);
					if	(AnsiPos(sx, SN) > 0)	then	begin
						No	:=	No	+ sx;
					end else begin
						if	(No <> '') and (No <> '-')	 then	begin
							Add(sp, i, No);
							al := True;
						end;
						sw	:=	False;
						//
						i := i - 1;
						//
						No	:= '';
						oc:='';
						//chk :=	False;
					end;
				end else begin
					if	Copy(s,i,1) = '<' then	oc	:=	'';
					oc	:=	oc + Copy(s,i,1);
					chk :=	False;
					al	:=	False;
				end;
			end;
			mbLeadByte	: begin
				if	(not sw) and (Copy(s,i,4) = '') then	begin
					sw	:=	True;
					sp	:=	i;
					i :=	i + 3;
					chk :=	True;
				end else
				if	(not sw) and (Copy(s,i,2) = '') then	begin
					sw	:=	True;
					sp	:=	i;
					i :=	i + 1;
					chk :=	True;
				end else
				if	(sw) then begin
					sx	:=	Copy(s,i,2);
					if	(AnsiPos(sx, ZN) > 0)	then	begin
						No	:=	No	+ ZenToHan(sx);
					end else begin
						if	(No <> '') and (No <> '-')	and (No <> '|') then	begin
							Add(sp, i, No);
						end;
						sw	:=	False;
						i := i - 1;
						No	:=	'';
					end;
				end else begin
					oc	:=	'';
					chk :=	False;
				end;
				al	:=	False;
			end;
		end;
		inc(i);
		if	(i > Length(Body))	then	begin
			if	(sw)	then	begin
				if	(No <> '')	then	Add(sp, i, No);
			end;
			Break;
		end;
	end;
	for i :=	List.Count - 1	downto	0 do	begin
        //plName := Copy(PluginName, LastDelimiter('\',PluginName) + 1, Length(PluginName) - LastDelimiter('/',PluginName) -1 );
		if	(AnsiPos('-', PIndex(List[i]).FNo) > 0) then	begin
			st	:=	ChooseString(PIndex(List[i]).FNo, '-', 0);
			et	:=	ChooseString(PIndex(List[i]).FNo, '-', 1);
		end else begin
			st	:=	PIndex(List[i]).FNo;
			et	:=	PIndex(List[i]).FNo;
		end;
		r :=	Copy(r,0, PIndex(List[i]).FIndexFrom - 1) +
					Format('<a href="%s&%s=%s&%s=%s&%s=%s" target="_blank">',
								[FullURL, ParamStart, st, ParamTo, et, ParamNoFirst, ParamTrue]) +
					Copy(r,PIndex(List[i]).FIndexFrom, PIndex(List[i]).FIndexTo - PIndex(List[i]).FIndexFrom) + '</A>' +
					Copy(r,PIndex(List[i]).FIndexTo,Length(r));
		Dispose(PIndex(List[i]));
	end;
	List.Free;
	Result	:=	r;
end;


function TGikoSys.BoolToInt(b: Boolean): Integer;
begin
	Result := IfThen(b, 1, 0);
end;

function TGikoSys.IntToBool(i: Integer): Boolean;
begin
	Result := i = 1;
end;

//gzipňkꂽ̂߂
function TGikoSys.GzipDecompress(ResStream: TStream; ContentEncoding: string): string;
const
	BUF_SIZE = 4096;
var
	GZipStream: TGzipDecompressStream;
	TextStream: TStringStream;
	buf: array[0..BUF_SIZE - 1] of Byte;
	cnt: Integer;
	s: string;
	i: Integer;
begin
	Result := '';
	TextStream := TStringStream.Create('');
	try
//m[gE`EBX2003΍(x-gzipƂɂȂ݂)
//		if LowerCase(Trim(ContentEncoding)) = 'gzip' then begin
		if AnsiPos('gzip', LowerCase(Trim(ContentEncoding))) > 0 then begin
			ResStream.Position := 0;
			GZipStream := TGzipDecompressStream.Create(TextStream);
			try
				repeat
					FillChar(buf, BUF_SIZE, 0);
					cnt := ResStream.Read(buf, BUF_SIZE);
					if cnt > 0 then
						GZipStream.Write(buf, BUF_SIZE);
				until cnt = 0;
			finally
				GZipStream.Free;
			end;
		end else begin
			ResStream.Position := 0;
			repeat
				FillChar(buf, BUF_SIZE, 0);
				cnt := ResStream.Read(buf, BUF_SIZE);
				if cnt > 0 then
					TextStream.Write(buf, BUF_SIZE);
			until cnt = 0;
		end;

		//NULL"*"ɂ
		s := TextStream.DataString;
		i := Length(s);
		while (i > 0) and (s[i] = #0) do
			Dec(i);
		s := Copy(s, 1, i);

		i := Pos(#0, s);
		while i <> 0 do begin
			s[i] := '*';
			i := Pos(#0, s);
		end;
		Result := s;
	finally
		TextStream.Free;
	end;
end;

procedure TGikoSys.LoadKeySetting(ActionList: TActionList);
const
	STD_SEC = 'KeySetting';
var
	i: Integer;
	ini: TMemIniFile;
	ActionName: string;
	ActionKey: Integer;
	SecList: TStringList;
	Component: TComponent;
begin
	if not FileExists(GetConfigDir + KEY_SETTING_FILE_NAME) then
		Exit;
	SecList := TStringList.Create;
	ini := TMemIniFile.Create(GetConfigDir + KEY_SETTING_FILE_NAME);
	try
		ini.ReadSection(STD_SEC, SecList);
		for i := 0 to SecList.Count - 1 do begin
			ActionName := SecList[i];
			ActionKey := ini.ReadInteger(STD_SEC, ActionName, -1);
			if ActionKey <> -1 then begin
				Component := ActionList.Owner.FindComponent(ActionName);
				if TObject(Component) is TAction then begin
					TAction(Component).ShortCut := ActionKey;
				end;
			end;
		end;
	finally
		ini.Free;
		SecList.Free;
	end;
end;

procedure TGikoSys.SaveKeySetting(ActionList: TActionList);
const
	STD_SEC = 'KeySetting';
var
	i: Integer;
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GetConfigDir + KEY_SETTING_FILE_NAME);
	try
		for i := 0 to ActionList.ActionCount - 1 do begin
			if ActionList.Actions[i].Tag = -1 then
				Continue;
			ini.WriteInteger(STD_SEC, ActionList.Actions[i].Name, TAction(ActionList.Actions[i]).ShortCut);
		end;
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

procedure TGikoSys.LoadEditorKeySetting(ActionList: TActionList);
const
	STD_SEC = 'KeySetting';
var
	i: Integer;
	ini: TMemIniFile;
	ActionName: string;
	ActionKey: Integer;
	SecList: TStringList;
	Component: TComponent;
begin
	if not FileExists(GetConfigDir + EKEY_SETTING_FILE_NAME) then
		Exit;
	SecList := TStringList.Create;
	ini := TMemIniFile.Create(GetConfigDir + EKEY_SETTING_FILE_NAME);
	try
		ini.ReadSection(STD_SEC, SecList);
		for i := 0 to SecList.Count - 1 do begin
			ActionName := SecList[i];
			ActionKey := ini.ReadInteger(STD_SEC, ActionName, -1);
			if ActionKey <> -1 then begin
				Component := ActionList.Owner.FindComponent(ActionName);
				if TObject(Component) is TAction then begin
					TAction(Component).ShortCut := ActionKey;
				end;
			end;
		end;
	finally
		ini.Free;
		SecList.Free;
	end;
end;

procedure TGikoSys.SaveEditorKeySetting(ActionList: TActionList);
const
	STD_SEC = 'KeySetting';
var
	i: Integer;
	ini: TMemIniFile;
begin
	ini := TMemIniFile.Create(GetConfigDir + EKEY_SETTING_FILE_NAME);
	try
		for i := 0 to ActionList.ActionCount - 1 do begin
			if ActionList.Actions[i].Tag = -1 then
				Continue;
			ini.WriteInteger(STD_SEC, ActionList.Actions[i].Name, TAction(ActionList.Actions[i]).ShortCut);
		end;
		ini.UpdateFile;
	finally
		ini.Free;
	end;
end;

//
procedure TGikoSys.CreateProcess(const AppPath: string; const Param: string);
var
	PI: TProcessInformation;
	SI: TStartupInfo;
	Path: string;
begin
	Path := '"' + AppPath + '"';
	if Param <> '' then
		Path := Path + ' ' + Param;

	SI.Cb := SizeOf(Si);
	SI.lpReserved	:= nil;
	SI.lpDesktop	 := nil;
	SI.lpTitle		 := nil;
	SI.dwFlags		 := 0;
	SI.cbReserved2 := 0;
	SI.lpReserved2 := nil;
	SI.dwysize		 := 0;
	Windows.CreateProcess(nil,
								PChar(Path),
								nil,
								nil,
								False,
								0,
								nil,
								nil,
								SI,
								PI);
end;

procedure TGikoSys.OpenBrowser(URL: string; BrowserType: TGikoBrowserType);
begin
	case BrowserType of
		gbtIE:
			HlinkNavigateString(nil, PWideChar(WideString(URL)));
		gbtUserApp, gbtAuto:
			if (Setting.URLApp) and (FileExists(Setting.URLAppFile)) then
				GikoSys.CreateProcess(Setting.URLAppFile, URL)
			else
				HlinkNavigateString(nil, PWideChar(WideString(URL)));
	end;
end;

function TGikoSys.HTMLDecode(const AStr: String): String;
var
	Sp, Rp, Cp, Tp: PChar;
	S: String;
	I, Code: Integer;
	Num: Boolean;
begin
	SetLength(Result, Length(AStr));
	Sp := PChar(AStr);
	Rp := PChar(Result);
	//Cp := Sp;
	try
		while Sp^ <> #0 do begin
			case Sp^ of
				'&': begin
							 //Cp := Sp;
							 Inc(Sp);
							 case Sp^ of
								 'a': if AnsiStrPos(Sp, 'amp;') = Sp then
											begin
												Inc(Sp, 3);
												Rp^ := '&';
											end;
								 'l',
								 'g': if (AnsiStrPos(Sp, 'lt;') = Sp) or (AnsiStrPos(Sp, 'gt;') = Sp) then
											begin
												Cp := Sp;
												Inc(Sp, 2);
												while (Sp^ <> ';') and (Sp^ <> #0) do
													Inc(Sp);
												if Cp^ = 'l' then
													Rp^ := '<'
												else
													Rp^ := '>';
											end;
								 'q': if AnsiStrPos(Sp, 'quot;') = Sp then
											begin
												Inc(Sp,4);
												Rp^ := '"';
											end;
								 '#': begin
												Tp := Sp;
												Inc(Tp);
												Num := IsNumeric(Copy(Tp, 1, 1));
												while (Sp^ <> ';') and (Sp^ <> #0) do begin
													if (Num) and (not IsNumeric(Copy(Sp, 1, 1))) then
														Break;
													Inc(Sp);
												end;
												SetString(S, Tp, Sp - Tp);
												Val(S, I, Code);
												Rp^ := Chr((I));
											end;
							 //	 else
									 //raise EConvertError.CreateFmt(sInvalidHTMLEncodedChar,
										 //[Cp^ + Sp^, Cp - PChar(AStr)])
							 end;
					 end
			else
				Rp^ := Sp^;
			end;
			Inc(Rp);
			Inc(Sp);
		end;
	except
//		on E:EConvertError do
//			raise EConvertError.CreateFmt(sInvalidHTMLEncodedChar,
//				[Cp^ + Sp^, Cp - PChar(AStr)])
	end;
	SetLength(Result, Rp - PChar(Result));
end;

function TGikoSys.GetHRefText(s: string): string;
var
	Index: Integer;
	Index2: Integer;
begin
	Result := '';
	s := Trim(s);
	if s = '' then
		Exit;

	Index := AnsiPos('href', LowerCase(s));
	if Index = 0 then
		Exit;
	s := Trim(Copy(s, Index + 4, Length(s)));
	s := Trim(Copy(s, 2, Length(s)));

	//n߂̕'"'Ȃ菜
	//if Copy(s, 1, 1) = '"' then begin
    if s[1]  = '"' then begin
		s := Trim(Copy(s, 2, Length(s)));
	end;

	Index := AnsiPos('"', s);
	if Index <> 0 then begin
		//'"'܂URLƂ
		s := Copy(s, 1, Index - 1);
	end else begin
		//'"'΃Xy[X">"̑܂łURLƂ
		Index := AnsiPos(' ', s);
		Index2 := AnsiPos('>', s);
		if Index = 0 then
			Index := Index2;
		if Index > Index2 then
			Index := Index2;
		if Index <> 0 then
			s := Copy(s, 1, Index - 1)
		else
			//ȏm
			;
	end;
	Result := Trim(s);
end;

//zXgQǂ`FbN
function TGikoSys.Is2chHost(Host: string): Boolean;
const
	HOST_NAME: array[0..1] of string = ('2ch.net', 'bbspink.com');
var
	i: Integer;
//	Len: Integer;
begin
	Result := False;
	if RightStr( Host, 1 ) = '/' then
		Host := Copy( Host, 1, Length( Host ) - 1 );
	OutputDebugString(pchar(HOST_NAME[0]));
	for i := 0 to Length(HOST_NAME) - 1 do begin
//		Len := Length(HOST_NAME[i]);
		if (AnsiPos(HOST_NAME[i], Host) > 0) and
			(AnsiPos(HOST_NAME[i], Host) = (Length(Host) - Length(HOST_NAME[i]) + 1)) then begin
			Result := True;
			Exit;
		end;
	end;
end;

function TGikoSys.Parse2chURL(const url: string; const path: string; const document: string; var BBSID: string; var BBSKey: string): Boolean;
var
	Index: Integer;
	s: string;
	SList: TStringList;
begin
	BBSID := '';
	BBSKey := '';
	Result := False;

	Index := AnsiPos(READ_PATH, path);
	if Index <> 0 then begin
		s := Copy(path, Index + Length(READ_PATH), Length(path));

		if (Length(s) > 0) and (s[1] = '/') then
			Delete(s, 1, 1);
		BBSID := GetTokenIndex(s, '/', 0);
		BBSKey := GetTokenIndex(s, '/', 1);
		if BBSKey = '' then
			BBSKey := Document;
		Result := (BBSID <> '') or (BBSKey <> '');
		Exit;
	end;
	Index := AnsiPos(KAKO_PATH, path);
	if Index <> 0 then begin
		s := Copy(path, 2, Length(path));
		BBSID := GetTokenIndex(s, '/', 0);
		if (BBSID = 'log') and (GetTokenIndex(s, '/', 2) = 'kako') then
			BBSID := GetTokenIndex(s, '/', 1);
		BBSKey := ChangeFileExt(Document, '');
		Result := (BBSID <> '') or (BBSKey <> '');
		Exit;
	end;
	Index := AnsiPos('read.cgi?', URL);
	if Index <> 0 then begin
		SList := TStringList.Create;
		try
			try
//				s := HTMLDecode(Document);
				ExtractHTTPFields(['?', '&'], [], PChar(URL), SList, False);
				BBSID := SList.Values['bbs'];
				BBSKey := SList.Values['key'];
				Result := (BBSID <> '') or (BBSKey <> '');
				Exit;
			except
				Exit;
			end;
		finally
			SList.Free;
		end;
	end;
end;
procedure TGikoSys.GetPopupResNumber(URL : string; var stRes, endRes : Int64);
var
	buf : String;
	convBuf : String;
	ps : Int64;
	pch : PChar;
begin
	URL := Trim(LowerCase(URL));
	if (AnsiPos('&st=', URL ) <> 0) and ( AnsiPos( '&to=',URL) <> 0 ) then begin
		stRes := 0;
		endRes := 0;
		try
			buf := Copy( URL, AnsiPos('&st=', URL ) + 4, AnsiPos( '&to=',URL) - AnsiPos('&st=', URL ) - 4 );
			if buf <> '' then
				stRes := StrToInt64( buf );
			if AnsiPos( '&nofirst=',URL) <> 0 then begin
				buf := Copy( URL, AnsiPos('&to=', URL ) + 4, AnsiPos( '&nofirst=',URL) - AnsiPos('&to=', URL ) - 4);
			end else begin
				buf := Copy( URL, AnsiPos('&to=', URL ) + 4, Length( URL ) - AnsiPos('&to=', URL ) - 4 + 1 );
				ps := 0;
				pch := PChar(buf);
				while  ( ps < Length(buf) )and ( pch[ps] >= '0' ) and ( pch[ps] <= '9' ) do Inc(ps);
				buf := Copy( buf, 1, ps );
			end;
			try
				if buf <> '' then
					endRes := StrToInt64(buf)
			except
				endRes := 0;
			end;
		except
			stRes := 0;
		end;
		if (stRes <> 0) and (endRes = 0) then
			endRes := stRes + MAX_POPUP_RES
		else if (stRes = 0) and (endRes <> 0) then begin
			stRes := endRes - MAX_POPUP_RES;
			if stRes < 1 then
				stRes := 1;
		end;
		GikoSys.GetBrowsableThreadURL( URL );
	end else if( AnsiPos('&res=', URL ) <> 0 ) then begin
		endRes := 0;
		buf := Copy( URL, AnsiPos('&res=', URL ) + 5, Length( URL ) - AnsiPos('&res=', URL ) - 5 + 1 );
		ps := 0;
		pch := PChar(buf);
		while  ( ps < Length(buf) )and ( pch[ps] >= '0' ) and ( pch[ps] <= '9' ) do Inc(ps);
		buf := Copy( buf, 1, ps );
		try
			if buf <> '' then
				stRes := StrToInt(buf)
			else begin
				stRes := 0;
			end;
		except
			stRes := 0;
		end;
	end else if (AnsiPos('&start=', URL ) <> 0) and ( AnsiPos( '&end=',URL) <> 0 ) then begin
		try
			stRes := StrToInt64( Copy( URL, AnsiPos('&start=', URL ) + 7, AnsiPos( '&end=',URL) - AnsiPos('&start=', URL ) - 7 ) );
			if AnsiPos( '&nofirst=',URL) <> 0 then begin
				buf := Copy( URL, AnsiPos('&end=', URL ) + 5, AnsiPos( '&nofirst=',URL) - AnsiPos('&end=', URL ) - 5);
			end else begin
				buf := Copy( URL, AnsiPos('&end=', URL ) + 5, Length( URL ) - AnsiPos('&to=', URL ) - 5 + 1 );
				ps := 0;
				pch := PChar(buf);
				while  ( ps < Length(buf) )and ( pch[ps] >= '0' ) and ( pch[ps] <= '9' ) do Inc(ps);
				buf := Copy( buf, 1, ps );
			end;
			try
				if buf <> '' then
					endRes := StrToInt64(buf);
			except
				endRes := 0;
			end;
		except
			stRes := 0;
		end;
	end else if ( AnsiPos('.html',URL) <> Length(URL) -4 ) and ( AnsiPos('.htm',URL) <> Length(URL) -3 ) then begin
		buf := Copy(URL, LastDelimiter('/',URL)+1,Length(URL)-LastDelimiter('/',URL)+1);
		if  Length(buf) > 0 then begin
			if AnsiPos('-', buf) = 1 then begin
				stRes := 0;
				Delete(buf,1,1);
				ps := 0;
				pch := PChar(buf);
				while  ( ps < Length(buf) )and ( pch[ps] >= '0' ) and ( pch[ps] <= '9' ) do Inc(ps);
				try
					convBuf := Copy( buf, 1, ps );
					if convBuf <> '' then
						endRes := StrToInt64(convBuf)
					else
						endRes := 0;
				except
					endRes := 0;
				end;
				if endRes <> 0 then begin
					stRes := endRes - MAX_POPUP_RES;
					if stRes < 1 then
						stRes := 1;
				end;
			end else begin
				ps := 0;
				pch := PChar(buf);
				while  ( ps < Length(buf) )and ( pch[ps] >= '0' ) and ( pch[ps] <= '9' ) do Inc(ps);
				try
					convBuf := Copy( buf, 1, ps );
					if convBuf <> '' then begin
						stRes := StrToInt64(convBuf);
						Delete(buf,1,ps+1);
						ps := 0;
						pch := PChar(buf);
						while  ( ps < Length(buf) )and ( pch[ps] >= '0' ) and ( pch[ps] <= '9' ) do Inc(ps);
						try
							convBuf := Copy( buf, 1, ps );
							if convBuf <> '' then
								endRes := StrToInt64(convBuf)
							else
								endRes := 0;
						except
							endRes := 0;
						end;
					end else begin
						stRes := 0;
					end;
				except
					stRes := 0;
					endRes := 0;
				end;
			end;
		end;
	end else begin
		//stRes := 0;
		//endRes := 0;
	end;
end;

function TGikoSys.Parse2chURL2(URL: string): TPathRec;
var
	i: Integer;
	s: string;
//	buf : String;
//	convBuf : String;
	wk: string;
	wkMin: Integer;
	wkMax: Integer;
	wkInt: Integer;
	RStart: Integer;
	RLength: Integer;
//	ps : Integer;
//	pch : PChar;
	SList: TStringList;
begin
	URL := Trim(LowerCase(URL));
	Result.FBBS := '';
	Result.FKey := '';
	Result.FSt := 0;
	Result.FTo := 0;
	Result.FFirst := False;
	Result.FStBegin := False;
	Result.FToEnd := False;
	Result.FDone := False;
	Result.FNoParam := False;

	wkMin := 0;
	wkMax := 1;
	if URL[length(URL)] = '\' then
		URL := URL + 'n';
	FAWKStr.RegExp := 'http://.+\.(2ch\.net|bbspink\.com)/';
	if FAWKStr.Match(FAWKStr.ProcessEscSeq(URL), RStart, RLength) <> 0 then begin
		s := Copy(URL, RStart + RLength - 1, Length(URL));

		//W
		//Ōl50, 10, 10-20, 10n, 10-20n, -10, 10-, 10n- Ȃ
		//http://xxx.2ch.net/test/read.cgi/bbsid/1000000000/
		FAWKStr.RegExp := '/test/read.cgi/.+/[0-9]+/?.*';
		if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
			s := Copy(s, 15, Length(s));

			SList := TStringList.Create;
			try
				SList.Clear;
				FAWKStr.RegExp := '/';
				if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) >= 3 then begin
					Result.FBBS := SList[1];
					Result.FKey := SList[2];
					if SList.Count >= 4 then
						s := SList[3]
					else begin
						s := '';
						Result.FNoParam := true;
					end;
				end else
					Exit;

				SList.Clear;
				FAWKStr.LineSeparator := mcls_CRLF;
				FAWKStr.RegExp := '-';
				if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) = 0 then begin
					Result.FFirst := True;
				end else begin
					FAWKStr.RegExp := 'l[0-9]+';
					if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
						Result.FFirst := True;
					end else begin
						for i := 0 to SList.Count - 1 do begin
							if Trim(SList[i]) = '' then begin
								if i = 0 then
									Result.FStBegin := True;
								if i = (SList.Count - 1) then
									Result.FToEnd := True;
							end else if IsNumeric(SList[i]) then begin
								wkInt := StrToInt(SList[i]);
								wkMax := Max(wkMax, wkInt);
								if wkMin = 0 then
									wkMin := wkInt
								else
									wkMin := Min(wkMin, wkInt);
							end else if Trim(SList[i]) = 'n' then begin
								Result.FFirst := True;
							end else begin
								FAWKStr.RegExp := '^n[0-9]+$|^[0-9]+n$';
								if FAWKStr.Match(FAWKStr.ProcessEscSeq(SList[i]), RStart, RLength) > 0 then begin
									if Copy(SList[i], 1, 1) = 'n' then
										wkInt := StrToInt(Copy(SList[i], 2, Length(SList[i])))
									else
										wkInt := StrToInt(Copy(SList[i], 1, Length(SList[i]) - 1));
									Result.FFirst := True;
									wkMax := Max(wkMax, wkInt);
									if wkMin = 1 then
										wkMin := wkInt
									else
										wkMin := Min(wkMin, wkInt);
								end;
							end;
						end;
						if Result.FStBegin and (not Result.FToEnd) then
							Result.FSt := wkMin
						else if (not Result.FStBegin) and Result.FToEnd then
							Result.FTo := wkMax
						else if (not Result.FStBegin) and (not Result.FToEnd) then begin
							Result.FSt := wkMin;
							Result.FTo := wkMax;
						end;
						//Result.FSt := wkMin;
						//Result.FTo := wkMax;
					end;
				end;
			finally
				SList.Free;
			end;
			Result.FDone := True;
			Exit;
		end;

		//Vkako
		//http://server.2ch.net/ITA_NAME/kako/1000/10000/1000000000.html
		FAWKStr.RegExp := '/.+/kako/[0-9]+/[0-9]+/[0-9]+\.html';
		if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
			SList := TStringList.Create;
			try
				SList.Clear;
				FAWKStr.RegExp := '/';
				if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) >= 6 then begin
					Result.FBBS := SList[1];
					Result.FKey := ChangeFileExt(SList[5], '');
					Result.FFirst := True;
				end else
					Exit;
			finally
				SList.Free;
			end;
			Result.FDone := True;
			Exit;
		end;

		//kako
		//http://server.2ch.net/ITA_NAME/kako/999/999999999.html
		FAWKStr.RegExp := '/.+/kako/[0-9]+/[0-9]+\.html';
		if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
			SList := TStringList.Create;
			try
				SList.Clear;
				FAWKStr.RegExp := '/';
				if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) >= 5 then begin
					Result.FBBS := SList[1];
					Result.FKey := ChangeFileExt(SList[4], '');
					Result.FFirst := True;
				end else
					Exit;
			finally
				SList.Free;
			end;
			Result.FDone := True;
			Exit;
		end;

		//logylog2
		//http://server.2ch.net/log/ITA_NAME/kako/999/999999999.html
		//http://server.2ch.net/log2/ITA_NAME/kako/999/999999999.html
		FAWKStr.RegExp := '/log2?/.+/kako/[0-9]+/[0-9]+\.html';
		if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
			SList := TStringList.Create;
			try
				SList.Clear;
				FAWKStr.RegExp := '/';
				if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) >= 6 then begin
					Result.FBBS := SList[2];
					Result.FKey := ChangeFileExt(SList[5], '');
					Result.FFirst := True;
				end else
					Exit;
			finally
				SList.Free;
			end;
			Result.FDone := True;
			Exit;
		end;


		//URL
		//http://server.2ch.net/test/read.cgi?bbs=ITA_NAME&key=1000000000&st=1&to=5&nofirst=true
		FAWKStr.RegExp := '/test/read\.cgi\?';
		if FAWKStr.Match(FAWKStr.ProcessEscSeq(s), RStart, RLength) > 0 then begin
			s := Copy(s, 16, Length(s));
			SList := TStringList.Create;
			try
				SList.Clear;
				FAWKStr.RegExp := '&';
				if FAWKStr.Split(FAWKStr.ProcessEscSeq(s), SList) >= 2 then begin
					Result.FFirst := True;
					for i := 0 to SList.Count - 1 do begin
						if Pos('bbs=', SList[i]) = 1 then begin
							Result.FBBS := Copy(SList[i], 5, Length(SList[i]));
						end else if Pos('key=', SList[i]) = 1 then begin
							Result.FKey := Copy(SList[i], 5, Length(SList[i]));
						end else if Pos('st=', SList[i]) = 1 then begin
							wk := Copy(SList[i], 4, Length(SList[i]));
							if IsNumeric(wk) then
								Result.FSt := StrToInt(wk)
							else if wk = '' then
								Result.FStBegin := True;
						end else if Pos('to=', SList[i]) = 1 then begin
							wk := Copy(SList[i], 4, Length(SList[i]));
							if IsNumeric(wk) then
								Result.FTo := StrToInt(wk)
							else if wk = '' then
								Result.FToEnd := True;
						end else if Pos('nofirst=', SList[i]) = 1 then begin
							Result.FFirst := False;
						end;
					end;
				end else
					Exit;
			finally
				SList.Free;
			end;

			if (Result.FBBS <> '') and (Result.FKey <> '') then begin
				Result.FDone := True;
			end;
			Exit;
		end;
	end;
end;

procedure TGikoSys.ParseURI(const URL : string; var Protocol, Host, Path, Document, Port, Bookmark: string);
var
	URI: TIdURI;
begin
	Protocol := '';
	Host := '';
	Path := '';
	Document := '';
	Port := '';
	Bookmark := '';
	URI := TIdURI.Create(URL);
	try
		Protocol := URI.Protocol;
		Host := URI.Host;
		Path := URI.Path;
		Document := URI.Document;
		Port := URI.Port;
		Bookmark := URI.Bookmark;
	finally
		URI.Free;
	end;
end;

function TGikoSys.GetVersionBuild: Integer;
var
	FixedFileInfo: PVSFixedFileInfo;
	VersionHandle, VersionSize: DWORD;
	pVersionInfo: Pointer;
	ItemLen : UInt;
	AppFile: string;
begin
	Result := 0;
	AppFile := Application.ExeName;
	VersionSize := GetFileVersionInfoSize(pChar(AppFile), VersionHandle);
	if VersionSize = 0 then
		Exit;
	GetMem(pVersionInfo, VersionSize);
	try
		if GetFileVersionInfo(PChar(AppFile),VersionHandle,VersionSize, pVersionInfo) then
			if VerQueryValue(pVersionInfo, '\', Pointer(FixedFileInfo), ItemLen) then
				Result := LOWORD(FixedFileInfo^.dwFileVersionLS);
	finally
		FreeMem(pVersionInfo, VersionSize);
	end;
end;

function	TGikoSys.GetBrowsableThreadURL(
	inURL : string
) : string;
var
	threadItem	: TThreadItem;
	boardPlugIn	: TBoardPlugIn;
    board		: TBoard;
	i						: Integer;
begin

	//===== vOC
	try
		for i := Length( BoardGroups ) - 1 downto 1 do begin
			if Assigned( Pointer( BoardGroups[i].BoardPlugIn.Module ) ) then begin
				if BoardGroups[i].BoardPlugIn.AcceptURL( inURL ) = atThread then begin
                    board := BBSsFindBoardFromURL( BoardGroups[i].BoardPlugIn.ExtractBoardURL(inURL) );
					if board <> nil then begin
						boardPlugIn := BoardGroups[i].BoardPlugIn;
						threadItem	:= TThreadItem.Create( boardPlugIn, board, inURL );
						Result			:= threadItem.URL;
						threadItem.Free;

					end;
					Exit;
				end;
			end;
		end;
	except
		// exception ꍇ͓ɔĈłł͉Ȃ
	end;

	if Length( Result ) = 0 then
		Result := GikoSys.Get2chBrowsableThreadURL( inURL );

end;

function	TGikoSys.GetThreadURL2BoardURL(
	inURL : string
) : string;
var
	threadItem	: TThreadItem;
	boardPlugIn	: TBoardPlugIn;
    board		: TBoard;
	i						: Integer;
begin

	//===== vOC
	try
		for i := Length( BoardGroups ) - 1 downto 1 do begin
			if Assigned( Pointer( BoardGroups[i].BoardPlugIn.Module ) ) then begin
				if BoardGroups[i].BoardPlugIn.AcceptURL( inURL ) = atThread then begin
                    board		:= BBSsFindBoardFromURL(BoardGroups[i].BoardPlugIn.ExtractBoardURL(inURL));
					boardPlugIn := BoardGroups[i].BoardPlugIn;
					threadItem	:= TThreadItem.Create( boardPlugIn, board, inURL );
					Result			:= BoardGroups[i].BoardPlugIn.GetBoardURL( Longword( threadItem ) );
					threadItem.Free;

					Break;
				end;
			end;
		end;
	except
		// exception ꍇ͓ɔĈłł͉Ȃ
	end;

	if Length( Result ) = 0 then
		Result := GikoSys.Get2chThreadURL2BoardURL( inURL );

end;

function	TGikoSys.Get2chThreadURL2BoardURL(
	inURL : string
) : string;
var
	Protocol, Host, Path, Document, Port, Bookmark : string;
	BBSID, BBSKey : string;
	foundPos			: Integer;
begin

	ParseURI( inURL, Protocol, Host, Path, Document, Port, Bookmark );
	Parse2chURL( inURL, Path, Document, BBSID, BBSKey );

	foundPos := Pos( '/test/read.cgi', inURL );
	if {(Is2chHost(Host)) and} (foundPos > 0) then
		Result := Copy( inURL, 1, foundPos ) + BBSID + '/'
	else
		Result := Protocol + '://' + Host + '/' + BBSID + '/';

end;

function	TGikoSys.Get2chBrowsableThreadURL(
	inURL			: string
) : string;
var
	Protocol, Host, Path, Document, Port, Bookmark : string;
	BBSID, BBSKey : string;
	foundPos	: Integer;
begin

//	if Pos( KAKO_PATH, inURL ) > 0 then begin
//		Result := inURL;
//	end else begin
		ParseURI( inURL, Protocol, Host, Path, Document, Port, Bookmark );
		Parse2chURL( inURL, Path, Document, BBSID, BBSKey );
		foundPos := Pos( '/test/read.cgi', inURL ) - 1;

		if Is2chHost( Host ) then begin
			Result := Protocol + '://' + Host +
				READ_PATH + BBSID + '/' + BBSKey + '/l50';
		end else begin
			if foundPos > 0 then
				Result := Copy( inURL, 1, foundPos ) +
					OLD_READ_PATH + 'bbs=' + BBSID + '&key=' + BBSKey + '&ls=50'
			else
				Result := Protocol + '://' + Host +
					OLD_READ_PATH + 'bbs=' + BBSID + '&key=' + BBSKey + '&ls=50';
		end;
//	end;

end;

function	TGikoSys.Get2chBoard2ThreadURL(
	inBoard	: TBoard;
	inKey	 	: string
) : string;
var
	server	: string;
begin

	server := UrlToServer( inBoard.URL );
	//if Is2chHost( server ) then
	if inBoard.Is2ch then
		Result := server + 'test/read.cgi/' + inBoard.BBSID + '/' + inKey + '/l50'
	else
		Result := server + 'test/read.cgi?bbs=' + inBoard.BBSID + '&key=' + inKey + '&ls=50';

end;

(*************************************************************************
 *@\@@F{[ht@C
 *@@@FPublic
 *************************************************************************)
procedure TGikoSys.ListBoardFile;
var
	boardFileList	: TStringList;
	i, l, k					: Integer;
begin
	// BBS ̊J
	try
	  for i := 0 to Length( BBSs ) - 1 do
		BBSs[ i ].Free;
	except
	end;
	SetLength( BBSs, 0 );

	l := 0;
	// Xg̗
	if FileExists( GikoSys.GetBoardFileName ) then begin
	  SetLength( BBSs, l + 1 );
	  BBSs[ l ]				:= TBBS.Create( GikoSys.GetBoardFileName );
	  BBSs[ l ].Title	:= 'Q˂';
		  Inc( l );
	end;

	if FileExists( GikoSys.GetCustomBoardFileName ) then begin
	  SetLength( BBSs, l + 1 );
	  BBSs[ l ]				:= TBBS.Create( GikoSys.GetCustomBoardFileName );
	  BBSs[ l ].Title	:= '̑';
		  Inc( l );
	end;

	// Board tH_
	if DirectoryExists( GikoSys.Setting.GetBoardDir ) then begin
	  BoardFileList := TStringList.Create;
	  try
        BoardFileList.BeginUpdate;
		GikoSys.GetFileList( GikoSys.Setting.GetBoardDir, '*', BoardFileList, True, True );
        BoardFileList.EndUpdate;
		for k := BoardFileList.Count - 1 downto 0 do begin
		  if AnsiCompareText(ExtractFileExt(BoardFileList[ k ]), '.bak') = 0 then
			  BoardFileList.Delete(k);
		end;
			  SetLength( BBSs, l + BoardFileList.Count );
		for i := BoardFileList.Count - 1 downto 0 do begin
		  BBSs[ l ]				:= TBBS.Create( BoardFileList[ i ] );
		  BBSs[ l ].Title	:= ChangeFileExt( ExtractFileName( BoardFileList[ i ] ), '' );
		  Inc( l );
		end;
	  finally
		BoardFileList.Free;
	  end;
	end;
end;
(*************************************************************************
 *@\@@F{[ht@Cǂݍ
 *@@@FPublic
 *************************************************************************)
procedure TGikoSys.ReadBoardFile( bbs : TBBS );
var
//	idx						: Integer;
	ini						: TMemIniFile;
	p : Integer;
	boardFile			: TStringList;
	CategoryList	: TStringList;
	BoardList			: TStringList;
	Category			: TCategory;
	Board					: TBoard;
	inistr				: string;
	tmpstring			: string;
//	RoundItem			: TRoundItem;

	i, iBound			: Integer;
	j, jBound			: Integer;
	k, kBound			: Integer;
begin

	if not FileExists( bbs.FilePath ) then
		Exit;

	bbs.Clear;
	ini := TMemIniFile.Create('');
	boardFile := TStringList.Create;

	try
		boardFile.LoadFromFile( bbs.FilePath );

		ini.SetStrings( boardFile );
		CategoryList	:= TStringList.Create;
		BoardList			:= TStringList.Create;
		try
			ini.ReadSections( CategoryList );

			iBound := CategoryList.Count - 1;
			for i := 0 to iBound do begin
				ini.ReadSection( CategoryList[i], BoardList );
				Category				:= TCategory.Create;
				Category.No			:= i + 1;
				Category.Title	:= CategoryList[i];

				jBound := BoardList.Count - 1;
				for j := 0 to jBound do begin
					Board := nil;
					inistr := ini.ReadString(CategoryList[i], BoardList[j], '');
					//'http://'܂܂Ȃ͖̎
					if (AnsiPos('http://', AnsiLowerCase(inistr)) = 0) then Continue;
					//===== vOC
					try
						kBound := Length(BoardGroups) - 1;
						for k := 1 to kBound do begin  //0́A2
							if Assigned( Pointer( BoardGroups[k].BoardPlugIn.Module ) ) then begin
								if BoardGroups[k].BoardPlugIn.AcceptURL( inistr ) = atBoard then begin
									if not BoardGroups[k].Find(inistr, p) then begin
										tmpstring := BoardGroups[k].BoardPlugIn.ExtractBoardURL( inistr );
										if AnsiCompareStr(tmpString, inistr) <> 0 then begin
											if not BoardGroups[k].Find(tmpstring, p) then begin
												try
													Board := TBoard.Create( BoardGroups[k].BoardPlugIn, tmpstring );
													BoardGroups[k].AddObject(tmpstring, Board);
													Category.Add(Board);
												except
													//ɗƂBoard̍쐬ɎsƂBoardnilɂ
													Board := nil;
												end;
											end else begin
												Board := TBoard(BoardGroups[k].Objects[p]);
												if Board.ParentCategory <> Category then
													Category.Add(Board);
											end;
										end else begin
											try
												Board := TBoard.Create( BoardGroups[k].BoardPlugIn, tmpstring );
												BoardGroups[k].AddObject(tmpstring, Board);
												Category.Add(Board);
											except
												//ɗƂBoard̍쐬ɎsƂBoardnilɂ
												Board := nil;
											end;
										end;
									end else begin
										Board := TBoard(BoardGroups[k].Objects[p]);
										if Board.ParentCategory <> Category then
											Category.Add(Board);
									end;
									Break;
								end;
							end;
						end;
					except
						// exception ꍇ͓ɔĈłł͉Ȃ
					end;
					try
						if (Board = nil) then begin
							if not BoardGroups[0].Find(inistr,p) then begin
								Board := TBoard.Create( nil, inistr );
								BoardGroups[0].AddObject(inistr, Board);
								Category.Add(Board);
							end else begin
								Board := TBoard(BoardGroups[0].Objects[p]);
								if Board.ParentCategory <> Category then
									Category.Add(Board);
							end;
						end;

						if (Board.Multiplicity = 0) then begin
							Board.BeginUpdate;
							Board.No := j + 1;
                            Board.Multiplicity := 1;
							Board.Title := BoardList[j];
							Board.RoundDate := ZERO_DATE;
							Board.LoadSettings;
							Board.EndUpdate;
						end else begin
							Board.No := j + 1;
							Board.Multiplicity := Board.Multiplicity + 1;
						end;
					except
					end;
				end;
				bbs.Add( Category );
			end;


		  //end;
		  bbs.IsBoardFileRead := True;
	  finally
		BoardList.Free;
		CategoryList.Free;
	  end;
  finally
	boardFile.Free;
	ini.Free;
  end;

end;

function	TGikoSys.GetUnknownCategory : TCategory;
const
	UNKNOWN_CATEGORY = '(̕s)';
begin

	if Length( BBSs ) < 2 then begin
		Result := nil;
		Exit;
	end;

	Result := BBSs[ 1 ].FindCategoryFromTitle( UNKNOWN_CATEGORY );
	if Result = nil then begin
		Result				:= TCategory.Create;
		Result.Title	:= UNKNOWN_CATEGORY;
		BBSs[ 1 ].Add( Result );
	end;

end;

function	TGikoSys.GetUnknownBoard( inPlugIn : TBoardPlugIn; inURL : string ) : TBoard;
var
	category : TCategory;
const
	UNKNOWN_BOARD = '(̕s)';
begin

	category := GetUnknownCategory;
	if category = nil then begin
		Result := nil;
	end else begin
		Result := category.FindBoardFromTitle( UNKNOWN_BOARD );
		if Result = nil then begin
			Result				:= TBoard.Create( inPlugIn, inURL );
			Result.Title	:= UNKNOWN_BOARD;
			category.Add( Result );
		end;
	end;

end;
function TGikoSys.GetSambaFileName : string;
begin
	Result := Setting.GetSambaFileName;
end;
procedure TGikoSys.SambaFileExists();
var
	sambaTmp: string;
	sambaStrList: TStringList;
begin
	if not FileExists(GikoSys.GetSambaFileName) then begin
		sambaTmp := ChangeFileExt(GikoSys.GetSambaFileName, '.default');
		sambaStrList := TStringList.Create;
		try
			if FileExists(sambaTmp) then begin
				sambaStrList.LoadFromFile(sambaTmp);
				sambaStrList.SaveToFile(GikoSys.GetSambaFileName);
			end;
		finally
			sambaStrList.Free;
		end;
	end;
end;
function TGikoSys.GetSameIDResAnchor(const AID : string; ThreadItem: TThreadItem; limited: boolean):string;
var
	i: integer;
	body: TStringList;
begin
    Result := '';
    if (not IsNoValidID(AID)) and
    	(ThreadItem <> nil) and (ThreadItem.IsLogFile) then begin
        body := TStringList.Create;
        try
            GetSameIDRes(AID, ThreadItem, body);
            if (limited) and (body.Count > 20) then begin
                for i := body.Count - 20 to body.Count - 1 do begin
                    Result := Result + '&gt;' + body[i] + ' ';
                end;
            end else begin
                for i := 0 to body.Count - 1 do begin
                    Result := Result + '&gt;' + body[i] + ' ';
                end;
            end;
        finally
            body.Free;
        end;
		Result := HTMLCreater.ConvRes(Result, ThreadItem.ParentBoard.BBSID, ChangeFileExt(ThreadItem.FileName, ''), 'bbs', 'key', 'st', 'to', 'nofirst', 'true', false);
    end;
end;
procedure TGikoSys.GetSameIDRes(const AID : string; ThreadItem: TThreadItem;var body: TStringList);
var
	i: integer;
	ReadList: TStringList;
	Res: TResRec;
	boardPlugIn : TBoardPlugIn;
begin
	if (not IsNoValidID(AID)) and
    	(ThreadItem <> nil) and (ThreadItem.IsLogFile) then begin
		//if ThreadItem.IsBoardPlugInAvailable then begin
        if ThreadItem.ParentBoard.IsBoardPlugInAvailable then begin
			//===== vOCɂ\
			//boardPlugIn		:= ThreadItem.BoardPlugIn;
            boardPlugIn		:= ThreadItem.ParentBoard.BoardPlugIn;

			for i := 0 to threadItem.Count - 1 do begin
				// X
				Res := DivideStrLine(boardPlugIn.GetDat(DWORD( threadItem ), i + 1));
				if(AnsiPos(AID, Res.FDateTime) > 0) then begin
					body.Add(IntToStr(i+1));
				end;
			end;
		end else begin
			ReadList := TStringList.Create;
			try
				ReadList.LoadFromFile(ThreadItem.GetThreadFileName);
				for i := 0 to ReadList.Count - 1 do begin
					Res := DivideStrLine(ReadList[i]);
					if AnsiPos(AID, Res.FDateTime) > 0 then begin
						body.Add(IntToStr(i+1));
					end;
				end;
			finally
				ReadList.Free;
			end;
		end;
	end;
end;
function TGikoSys.GetSameIDResAnchor(AIDNum : Integer; ThreadItem: TThreadItem; limited: boolean):string;
var
	i: integer;
	body: TStringList;
begin
	Result := '';
	if (ThreadItem <> nil) and (ThreadItem.IsLogFile) then begin
		body := TStringList.Create;
		try
			GetSameIDRes(AIDNum, ThreadItem, body);
            if (limited) and (body.Count > 20) then begin
    			for i := body.Count - 20 to body.Count - 1 do begin
	    			Result := Result + '&gt;' + body[i] + ' ';
		    	end;
            end else begin
    			for i := 0 to body.Count - 1 do begin
	    			Result := Result + '&gt;' + body[i] + ' ';
		    	end;
            end;
		finally
			body.Free;
		end;
		Result := HTMLCreater.ConvRes(Result, ThreadItem.ParentBoard.BBSID, ChangeFileExt(ThreadItem.FileName, ''), 'bbs', 'key', 'st', 'to', 'nofirst', 'true', false);
	end;
end;

procedure TGikoSys.GetSameIDRes(AIDNum : Integer; ThreadItem: TThreadItem;var body: TStringList);
var
	Res: TResRec;
	boardPlugIn : TBoardPlugIn;
	AID : String;
	stList: TStringList;
	i : Integer;
begin
	if (ThreadItem <> nil) and (ThreadItem.IsLogFile)
		and (AIDNum > 0) and (AIDNum <= ThreadItem.Count) then begin
		//if ThreadItem.IsBoardPlugInAvailable then begin
        if ThreadItem.ParentBoard.IsBoardPlugInAvailable then begin
			//===== vOCɂ\
			//boardPlugIn		:= ThreadItem.BoardPlugIn;
            boardPlugIn		:= ThreadItem.ParentBoard.BoardPlugIn;
			Res := DivideStrLine(boardPlugIn.GetDat(DWORD( threadItem ), AIDNum));
		end else begin
			Res := DivideStrLine( ReadThreadFile(ThreadItem.GetThreadFileName, AIDNum));
		end;
		AID := Res.FDateTime;
		if AnsiPos('id', AnsiLowerCase(AID)) > 0 then begin
			AID := Copy(AID, AnsiPos('id', AnsiLowerCase(AID)) - 1, 11);
            if AnsiPos(' be:', AnsiLowerCase(AID)) > 0 then begin
            	AID := Copy(AID, 1, AnsiPos(' BE:', AnsiLowerCase(AID)) - 1)
            end;
		end else begin
			stlist := TStringList.Create;
			try
				stList.DelimitedText := AID;
                AID := '';
				for i := 0 to stList.Count - 1 do
					if Length(WideString(stList[i])) = 8 then begin
						if NotDateorTimeString(stList[i]) then begin
							AID := stList[i];
							break;
						end;
					end;
			finally
				stList.Free;
			end;
		end;
        if not IsNoValidID(AID) then
			GetSameIDRes(AID, ThreadItem, body);
	end;
end;
function TGikoSys.GetSameIDResCount(const AID : string; ThreadItem: TThreadItem):Integer;
var
	body: TStringList;
begin
    Result := 0;
	if (not IsNoValidID(AID))
     and (ThreadItem <> nil) and (ThreadItem.IsLogFile) then begin
		body := TStringList.Create;
		try
			GetSameIDRes(AID, ThreadItem, body);
			Result := body.Count;
		finally
			body.Free;
		end;
	end;

end;
function TGikoSys.GetSameIDResCount(AIDNum : Integer; ThreadItem: TThreadItem):Integer;
var
	body: TStringList;
begin
	Result := 0;
	if (ThreadItem <> nil) and (ThreadItem.IsLogFile) then begin
		body := TStringList.Create;
		try
			GetSameIDRes(AIDNum, ThreadItem, body);
            Result := body.Count;
		finally
			body.Free;
		end;
	end;
end;

function TGikoSys.NotDateorTimeString(const AStr : string): boolean;
begin
	Result := false;
	try
		StrToDate(AStr);
	except
		try
			StrToTime(AStr);
			Result := false;
		except
			Result := true;
		end;
	end;

end;

procedure TGikoSys.SpamCountWord( const text : string; wordCount : TWordCount );
begin

	if Setting.SpamFilterAlgorithm = gsfaNone then Exit;
	Bayesian.CountWord( text, wordCount );

end;

procedure TGikoSys.SpamForget( wordCount : TWordCount; isSpam : Boolean );
begin

	if Setting.SpamFilterAlgorithm = gsfaNone then Exit;
	Bayesian.Forget( wordCount, isSpam );

end;

procedure TGikoSys.SpamLearn( wordCount : TWordCount; isSpam : Boolean );
begin

	if Setting.SpamFilterAlgorithm = gsfaNone then Exit;
	Bayesian.Learn( wordCount, isSpam );

end;

function TGikoSys.SpamParse( const text : string; wordCount : TWordCount ) : Extended;
begin

	case Setting.SpamFilterAlgorithm of
	gsfaNone:								Result := 0;
	gsfaPaulGraham:					Result := Bayesian.Parse( text, wordCount, gbaPaulGraham );
	gsfaGaryRobinson:				Result := Bayesian.Parse( text, wordCount, gbaGaryRobinson );
	gsfaGaryRobinsonFisher:	Result := Bayesian.Parse( text, wordCount, gbaGaryRobinsonFisher );
	else										Result := 0;
	end;

end;
function TGikoSys.SetUserOptionalStyle(): string;
begin
    Result := '';
	if Length( GikoSys.Setting.BrowserFontName ) > 0 then
		Result := 'font-family:"' + GikoSys.Setting.BrowserFontName + '";';
	if GikoSys.Setting.BrowserFontSize <> 0 then
		Result := Result + 'font-size:' + IntToStr( GikoSys.Setting.BrowserFontSize ) + 'pt;';
	if GikoSys.Setting.BrowserFontColor <> -1 then
		Result := Result + 'color:#' + IntToHex( GikoSys.Setting.BrowserFontColor, 6 ) + ';';
	if GikoSys.Setting.BrowserBackColor <> -1 then
		Result := Result + 'background-color:#' + IntToHex( GikoSys.Setting.BrowserBackColor, 6 ) + ';';
	case GikoSys.Setting.BrowserFontBold of
		-1: Result := Result + 'font-weight:normal;';
		1:  Result := Result + 'font-weight:bold;';
	end;
	case GikoSys.Setting.BrowserFontItalic of
		-1: Result := Result + 'font-style:normal;';
		1:  Result := Result + 'font-style:italic;';
	end;
end;
//AAIDFΏۂƂȂtIDAANum:X AURLF̃XbhURL
function TGikoSys.AddBeProfileLink(AID : string; ANum: Integer):string ;
var
	p : integer;
	BNum, BMark : string;
begin
	p := AnsiPos('BE:', AnsiUpperCase(AID));
	if p > 0 then begin
		BNum := Copy(AID, p, Length(AID));
		AID := Copy(AID, 1, p - 1);
		p := AnsiPos('-', BNum);
		if p > 0 then begin
			BMark := '?' + Trim(Copy(BNum, p + 1, Length(BNum)));
			BNum := Copy(BNum, 1, p - 1);
		end;
		BNum := Trim(BNum);
		Result := AID + ' <a href="'  + BNum + '/' + IntToStr(ANum)
			+ '" target=_blank>' + BMark + '</a>';
	end else
		Result := AID;
end;
// o[W擾
function TGikoSys.GetVersionInfo(KeyWord: TVerResourceKey): string;
const
	Translation = '\VarFileInfo\Translation';
	FileInfo = '\StringFileInfo\%0.4s%0.4s\';
var
	BufSize, HWnd: DWORD;
	VerInfoBuf: Pointer;
	VerData: Pointer;
	VerDataLen: Longword;
	PathLocale: String;
begin
	// Kvȃobt@̃TCY擾
	BufSize := GetFileVersionInfoSize(PChar(Application.ExeName), HWnd);
	if BufSize <> 0 then begin
		// m
		GetMem(VerInfoBuf, BufSize);
		try
			GetFileVersionInfo(PChar(Application.ExeName), 0, BufSize, VerInfoBuf);
			// ϐubN̕ϊe[uw
			VerQueryValue(VerInfoBuf, PChar(Translation), VerData, VerDataLen);

			if not (VerDataLen > 0) then
				raise Exception.Create('̎擾Ɏs܂');

			// 8̂PUiɕϊ
			// '\StringFileInfo\027382\FileDescription'
			PathLocale := Format(FileInfo + KeyWordStr[KeyWord],
			[IntToHex(Integer(VerData^) and $FFFF, 4),
			IntToHex((Integer(VerData^) shr 16) and $FFFF, 4)]);
			VerQueryValue(VerInfoBuf, PChar(PathLocale), VerData, VerDataLen);

			if VerDataLen > 0 then begin
				// VerData̓[ŏI镶ł͂ȂƂɒ
				result := '';
				SetLength(result, VerDataLen);
				StrLCopy(PChar(result), VerData, VerDataLen);
			end;
		finally
			// 
			FreeMem(VerInfoBuf);
		end;
	end;
end;
//Plugin̏̎擾
//LoadꂽSẴvOC̃o[WԂ
//1s1plugin
function TGikoSys.GetPluginsInfo(): String;
var
	i : Integer;
	major, minor, revision : Cardinal;
	agent, release : String;
begin
	//ʂNAĂ
	Result := '';

	//BoardGroupsoRPluginɃANZX
	for  i := 0 to Length(BoardGroups) - 1 do begin
		//BoardGroups̒ɂ́APluginĂȂ́i2j
		//̂ł
		if BoardGroups[i].BoardPlugIn <> nil then begin
			BoardGroups[i].BoardPlugIn.VersionInfo(agent, major, minor, release, revision);


			//"Plugin̖O(major.minor.revision)"
			Result := Result +
				Format('%s(%d.%d.%d)', [agent, major, minor, revision]) + #13#10;
		end;
	end;
end;


//IẼo[W擾
function TGikoSys.GetIEVersion: string;
var
	R: TRegistry;
begin
	R := TRegistry.Create;
	try
		//ǂݎpɂȂƁAUSERƂ̏ꍇAJȂ݂
		R.Access := KEY_EXECUTE;
		R.RootKey := HKEY_LOCAL_MACHINE;
		R.OpenKey('Software\Microsoft\Internet Explorer', False);
		try
			Result := R.ReadString('version');
		except
			Result := 'o[W̎擾Ɏs܂B';
		end;
		R.CloseKey;
	finally
		R.Free;
	end;
end;


initialization
	GikoSys := TGikoSys.Create;

finalization
	if GikoSys <> nil then begin
		GikoSys.Free;
		GikoSys := nil;
	end;
end.
