unit ExternalBoardPlugInMain;

interface

uses
	Windows, Classes, SysUtils, Menus,
	IdHTTP, IdComponent, IdGlobal, IdException,
	AbonUnit, IdAntiFreezeBase;

type

	// _E[hǂ
	TDownloadState = (dsWait, dsWork, dsComplete, dsDiffComplete, dsNotModify, dsAbort, dsError);

	// w肵 URL ̃vOCŎ󂯕t邩ǂ
	TAcceptType = (atNoAccept, atBBS, atBoard, atThread);

	// j[nh
	TMenuHandler	= procedure(
		inHandle : HMENU					// j[nh
	); stdcall;

	// *************************************************************************
	// vOC()[hꂽ
	// *************************************************************************
	TOnLoad = procedure (
		inInstance : DWORD				// vOC̃CX^X
	); stdcall;

	// *************************************************************************
	// vOC̃o[W
	// *************************************************************************
	TOnVersionInfo = procedure(
		var outAgent		: PChar;	// o[W؊܂܂ȂȖ
		var outMajor		: DWORD;	// W[o[W
		var outMinor		: DWORD;	// }Ci[o[W
		var outRelease	: PChar;	// [XiK
		var outRevision	: DWORD		// rWio[
	); stdcall;

	// *************************************************************************
	// w肵 URL ̃vOCŎ󂯕t邩ǂ
	// *************************************************************************
	TOnAcceptURL = function(
		inURL : PChar						// fł URL
	): TAcceptType; stdcall;	// URL ̎

	// *************************************************************************
	// w肵URL݂URLɕϊ
	// *************************************************************************
	TOnExtractBoardURL = procedure(
		inURL : PChar;						// ϊURL;
        var outURL: PChar						// ϊꂽURL
	); stdcall;	// ϊꂽURL

	// *************************************************************************
	// j[nh
	// *************************************************************************
	TOnPlugInMenu = procedure(
		inInstance : DWORD		// j[nh
	); stdcall;

	// *************************************************************************
	// Xꗗ URL Xbh URL 𓱂o
	// *************************************************************************
	TOnListURL2ThreadURL = function(
		inListURL		: PChar;	// Xꗗ URL
		inFileName	: PChar		// Xbht@C
	) : PChar; stdcall;			// Xbh URL


function CreateResultString(
	resultStr : string
) : PChar; stdcall;

procedure DisposeResultString(
	resultStr : PChar
); stdcall;

var
	socket : TIdHTTP;

implementation

uses ExternalBoardManager, ExternalThreadItem, GikoSystem, BoardGroup, Giko;

// *************************************************************************
// ߂l PChar ł API ̃mۂ
// *************************************************************************
function CreateResultString(
	resultStr : string
) : PChar; stdcall;
var
	tmp : PChar;
begin

	tmp := PChar( resultStr );
	GetMem( Result, Length( tmp ) + 1 );
	Move( tmp^, Result^, Length( tmp ) + 1 );

end;

// *************************************************************************
// ߂l PChar ł API ̃J
// *************************************************************************
procedure DisposeResultString(
	resultStr : PChar
); stdcall;
begin

	FreeMem( resultStr );

end;

// *************************************************************************
// vO{̂̃o[W擾
// *************************************************************************
procedure VersionInfo(
	var outAgent		: PChar;	// o[W؊܂܂ȂȖ
	var outMajor		: DWORD;	// W[o[W
	var outMinor		: DWORD;	// }Ci[o[W
	var outRelease	: PChar;	// [XiK
	var outRevision	: DWORD		// rWio[
); stdcall;
begin

	{$IFDEF DEBUG}
	Writeln('ExternalBoardManager.VersionInfo');
	{$ENDIF}
	outAgent		:= CreateResultString( PChar( APP_NAME ) );
	outMajor		:= 1;
	outMinor		:= 0;
	outRelease	:= CreateResultString( PChar( BETA_VERSION_NAME_E ) );
	outRevision	:= BETA_VERSION;

end;

// *************************************************************************
// bZ[W\
// *************************************************************************
procedure InternalPrint(
	inMessage	: PChar	// bZ[W
); stdcall;
begin

	GikoForm.AddMessageList( inMessage, nil, gmiWhat );

end;

// *************************************************************************
// fobObZ[W\
// *************************************************************************
procedure InternalDebugPrint(
	inMessage	: PChar	// bZ[W
); stdcall;
begin

	{$IFDEF DEBUG}
	Writeln( inMessage );
	{$ENDIF}

end;

// *************************************************************************
// \Pbg(Gp֐)
// *************************************************************************
procedure	InitializeSocket(
	inSocket : TIdHTTP
);
begin

	if inSocket <> nil then begin
		// Cxg̐ݒ
		if Assigned( OnWork ) then
			inSocket.OnWork				:= OnWork;
		if Assigned( OnWorkBegin ) then
			inSocket.OnWorkBegin	:= OnWorkBegin;
		if Assigned( OnWorkEnd ) then
			inSocket.OnWorkEnd		:= OnWorkEnd;

		// ʐMɊւݒ
		inSocket.Request.CustomHeaders.Clear;
		inSocket.Response.Clear;
		inSocket.Request.Clear;

		inSocket.Request.UserAgent	:= GikoSys.GetUserAgent;
		inSocket.RecvBufferSize			:= Gikosys.Setting.RecvBufferSize;
		inSocket.ProxyParams.BasicAuthentication := False;
		inSocket.ReadTimeout := GikoSys.Setting.ReadTimeOut;
		{$IFDEF DEBUG}
		Writeln('------------------------------------------------------------');
		{$ENDIF}
		//inSocket.AllowCookies := False;
		if GikoSys.Setting.ReadProxy then begin
			if GikoSys.Setting.ProxyProtocol then
				inSocket.ProtocolVersion := pv1_1
			else
				inSocket.ProtocolVersion := pv1_0;
			inSocket.ProxyParams.ProxyServer		:= GikoSys.Setting.ReadProxyAddress;
			inSocket.ProxyParams.ProxyPort			:= GikoSys.Setting.ReadProxyPort;
			inSocket.ProxyParams.ProxyUsername	:= GikoSys.Setting.ReadProxyUserID;
			inSocket.ProxyParams.ProxyPassword	:= GikoSys.Setting.ReadProxyPassword;
			if GikoSys.Setting.ReadProxyUserID <> '' then
				inSocket.ProxyParams.BasicAuthentication := True;
			{$IFDEF DEBUG}
			Writeln('vLVݒ肠');
			Writeln('zXg: ' + GikoSys.Setting.ReadProxyAddress);
			Writeln('|[g: ' + IntToStr( GikoSys.Setting.ReadProxyPort ));
			{$ENDIF}
		end else begin
			if GikoSys.Setting.Protocol then
				inSocket.ProtocolVersion := pv1_1
			else
				inSocket.ProtocolVersion := pv1_0;
			inSocket.ProxyParams.ProxyServer		:= '';
			inSocket.ProxyParams.ProxyPort			:= 80;
			inSocket.ProxyParams.ProxyUsername	:= '';
			inSocket.ProxyParams.ProxyPassword	:= '';
			{$IFDEF DEBUG}
			Writeln('vLVݒȂ');
			{$ENDIF}
		end;
	end;

end;

// *************************************************************************
// w肵 URL _E[hĕԂ
// *************************************************************************
function InternalDownload(
	inURL							: PChar;	// _E[h URL
	var ioModified		: Double;	// ŌɎ擾
	var outResultData	: PChar;	// _E[hꂽ
	inRangeStart			: DWORD;	// Jnʒu
	inRangeEnd				: DWORD		// Iʒu
) : Longint; stdcall;					// X|XR[h
var
//	httpSocket				: TIdHTTP;
	resStream					: TMemoryStream;
	content						: string;
const
	LIVEDOOR_URL = 'http://jbbs.livedoor.jp/';
begin


	{$IFDEF DEBUG}
	Writeln('ExternalBoardManager.InternalDownload');
	{$ENDIF}
//	Result := -1;

	socket := TIdHTTP.Create( nil );
	try
		InitializeSocket( socket );
		socket.Request.ContentRangeStart	:= inRangeStart;
		socket.Request.ContentRangeEnd		:= inRangeEnd;
		if (ioModified <> 0) and (ioModified <> ZERO_DATE) then
			socket.Request.LastModified := ioModified - OffsetFromUTC;
		if inRangeStart = 0 then
			socket.Request.AcceptEncoding := 'gzip'
		else
			socket.Request.AcceptEncoding := '';
		socket.Request.Accept := 'text/html';

		resStream := TMemoryStream.Create;
		try
			try
				resStream.Clear;
				{$IFDEF DEBUG}
				Writeln('URL: ' + inURL);
				{$ENDIF}
				//XVAtbNĂԂ́AGet悤Ƃ
				//[v
				if GAntiFreeze = nil then begin
					socket.Get( inURL, resStream );
				end else begin
                    Result := 503;
				end;
				{$IFDEF DEBUG}
				Writeln('擾ŗOȂ');
				{$ENDIF}

				content			:= GikoSys.GzipDecompress( resStream, socket.Response.ContentEncoding );

				ioModified	:= socket.Response.LastModified;

				Result := socket.ResponseCode;
				if (Length( content ) = 0) and (Result = 206) then
					Result := 304;
				//JBBS̓wb_ɃG[񂪍ڂ炵̂ŁAŃ`FbN
				if ( AnsiPos(LIVEDOOR_URL, inURL) > 0 ) and (Result = 200) then begin
					if( AnsiPos('STORAGE IN', socket.Response.RawHeaders.Text) > 0 ) then begin
						Result := 302;
					end;
				end;
				outResultData := CreateResultString( content );
			except
				on E: EIdSocketError do begin
					ioModified		:= ZERO_DATE;
					outResultData	:= nil;
					Result				:= socket.ResponseCode;
				end;
				on E: EIdConnectException do begin
					ioModified		:= ZERO_DATE;
					outResultData	:= nil;
					Result				:= socket.ResponseCode;
					//Item.ErrText	:= E.Message;
				end;
				//fꂽƂRRɓ
				on E: EIdClosedSocket do begin
					ioModified		:= ZERO_DATE;
					outResultData	:= nil;
					Result				:= 408; //ɈꕔDLĂƃX|XR[h200̂܂܂
												//ȂĂ܂̂ŁAIɃG[R[hԂ
				end;
				on E: Exception do begin
					{$IFDEF DEBUG}
					Writeln('擾ŗO');
					Writeln('E.Message: ' + E.Message);
					{$ENDIF}
					ioModified		:= ZERO_DATE;
					outResultData	:= nil;
					Result				:= socket.ResponseCode;
					//Item.ErrText	:= E.Message;
				end;
			end;
		finally
			resStream.Free;
		end;

	finally
		socket.Free;
		socket := nil;
	end;

end;

// *************************************************************************
// w肵 URL փf[^𑗐M
// *************************************************************************
function	InternalPost(
	inURL							: PChar;			// M URL
	inSource					: PChar;			// Me
	inReferer			: PChar;				// Referer
	var outResultData	: PChar				// ԂĂ
) : Longint; stdcall;							// X|XR[h
var
	httpSocket				: TIdHTTP;
	content						: string;
	resStream					: TStringStream;
	sourceStream			: TStringStream;

begin

	{$IFDEF DEBUG}
	Writeln('ExternalBoardManager.InternalPost');
	{$ENDIF}
	Result := -1;

	httpSocket := TIdHTTP.Create( nil );
	try
		InitializeSocket( httpSocket );
		httpSocket.Request.CustomHeaders.Add('Pragma: no-cache');
		httpSocket.Request.AcceptLanguage	:= 'ja';
		httpSocket.Request.Accept					:= 'image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, */*';
		httpSocket.Request.ContentType		:= 'application/x-www-form-urlencoded';
		httpSocket.Request.Referer			:= string(inReferer);
		resStream			:= TStringStream.Create( content );
		sourceStream	:= TStringStream.Create( string( inSource ) );
		try
			try
				{$IFDEF DEBUG}
				Writeln('URL: ' + inURL);
				Writeln('Source: ' + inSource);
				{$ENDIF}
				httpSocket.Post( string( inURL ), sourceStream, resStream );
				{$IFDEF DEBUG}
				Writeln('擾ŗOȂ');
				{$ENDIF}

				Result := httpSocket.ResponseCode;

				outResultData := CreateResultString( resStream.DataString );
			except
				on E: EIdSocketError do begin
					outResultData	:= nil;
				end;
				on E: EIdConnectException do begin
					outResultData	:= nil;
				end;
				on E: Exception do begin
					{$IFDEF DEBUG}
					Writeln('擾ŗO');
					Writeln('E.Message: ' + E.Message);
					{$ENDIF}
					outResultData := CreateResultString( resStream.DataString );
					Result				:= httpSocket.ResponseCode;
				end;
			end;
		finally
			resStream.Free;
			sourceStream.Free;
		end;
	finally
		httpSocket.Free;
	end;

end;

// *************************************************************************
// Q˂ dat `[Jځ`ɒʂ
// *************************************************************************

function InternalAbon(
	inDatText : PChar;			// O<>[<>tID<>{<>[s] ō\ꂽeLXg
	inDatPath	: PChar				// dat t@C̃tpX

) : PChar; stdcall;				// ځ`ς݂ dat `eLXg
var
	datList : TStringList;
		FileName : String;
begin

	datList := TStringList.Create;
    try
        datList.Text := string( inDatText );
        FileName := string( inDatPath );
        GikoSys.FAbon.IndividualAbon( datList, ChangeFileExt(FileName,'.NG'));
        GikoSys.FAbon.Execute( datList );
        GikoSys.FSelectResFilter.Execute( datList );

        Result := CreateResultString( datList.Text );
    finally
    	datList.Free;
    end;


end;
// *************************************************************************
// Q˂ dat `[Jځ`ɒʂ
// APX
// *************************************************************************

function InternalAbonForOne(
	inDatText : PChar;		// O<>[<>tID<>{<>[s] ō\ꂽeLXg
	inDatPath	: PChar;		// dat t@C̃tpX
	inNo : Integer				// vꂽXԍ
) : PChar; stdcall;			// ځ`ς݂ dat `eLXg
var
	datString : String;
		FileName : String;
begin

	datString := string( inDatText );
	FileName := string( inDatPath );
	GikoSys.FAbon.IndividualAbon( datString, ChangeFileExt(FileName,'.NG'), inNo);
	GikoSys.FAbon.Execute( datString , inNo);
	GikoSys.FSelectResFilter.Execute( datString , inNo );

	Result := CreateResultString( datString );

end;

// *************************************************************************
// Q˂ dat ` 1 s HTML ɕϊ
// *************************************************************************
function InternalDat2HTML(
	inDatRes		: PChar; 		// O<>[<>tID<>{<> ō\ꂽeLXg
	inResNo			: DWORD; 		// Xԍ
	inIsNew			: Boolean		// VXȂ True
) : PChar; stdcall;				// `ꂽ HTML
var
	board				: TBoard;
	threadItem	: TThreadItem;
begin

	// _~[̃NX
	board				:= TBoard.Create( nil, 'about://dummy/' );
	threadItem	:= TThreadItem.Create( nil, board, 'about://dummy/test/read.cgi/dummy/' );
	try
		try
			board.Add( threadItem );

			Result := ThreadItemDat2HTML( DWORD( threadItem ), inDatRes, inResNo, inIsNew );
		except
			Result := nil;
		end;
	finally
		board.Free;
	end;

end;

// *************************************************************************
// vOCj[ɍڂǉ
// *************************************************************************
function AddPlugInMenu(
	inInstance	: DWORD;		// vOC̃CX^X
	inCaption	: PChar 			// j[ɕ\镶
) : HMENU; stdcall;				// j[nhAǉɎsꍇ NULL
var
	newItem		: TMenuItem;
begin

	try
		newItem					:= TMenuItem.Create( nil );
		newItem.Caption	:= inCaption;
		newItem.Tag			:= inInstance;
		newItem.OnClick	:= GikoForm.OnPlugInMenuItem;
		GikoForm.PlugInMenu.Add( newItem );

		Result := newItem.Handle;
	except
   		Result := 0;
	end;

end;

// *************************************************************************
// vOCj[獀ڂ폜
// *************************************************************************
procedure RemovePlugInMenu(
	inHandle	: HMENU 			// j[nh
); stdcall;
var
	i					: Integer;
begin

	for i := GikoForm.PlugInMenu.Count - 1 downto 0 do begin
		if GikoForm.PlugInMenu.Items[ i ].Handle = inHandle then begin
            GikoForm.PlugInMenu.items[i].Free;
			//GikoForm.PlugInMenu.Delete( i );
			Break;
		end;
	end;

end;

exports
	CreateResultString,
	DisposeResultString,
	VersionInfo,
	InternalPrint,
	InternalDebugPrint,
	InternalDownload,
	InternalPost,
	InternalAbon,
	InternalAbonForOne,
	InternalDat2HTML,
	AddPlugInMenu,
	RemovePlugInMenu;

end.
