import smtpd
import asyncore
import email.feedparser
from pprint import pformat

import tg
import pylons
from paste.script import command

import allura.command
from allura.lib.helpers import find_project
from allura.command import base

from paste.deploy.converters import asint

M = None

class SMTPServerCommand(allura.command.Command):
    min_args=1
    max_args=1
    usage = 'NAME <ini file>'
    summary = 'Handle incoming emails, routing them to RabbitMQ'
    parser = command.Command.standard_parser(verbose=True)
    parser.add_option('-c', '--context', dest='context',
                      help=('The context of the message (path to the project'
                            ' and/or tool'))

    def command(self):
        global M
        self.basic_setup()
        from allura import model
        M = model
        server = MailServer((tg.config.get('forgemail.host', '0.0.0.0'),
                             asint(tg.config.get('forgemail.port', 8825))),
                            None)
        asyncore.loop()

class MailServer(smtpd.SMTPServer):

    def process_message(self, peer, mailfrom, rcpttos, data):
        base.log.info('Msg Received from %s for %s', mailfrom, rcpttos)
        base.log.info(' (%d bytes)', len(data))
        pylons.g.publish('audit', 'forgemail.received_email',
                         dict(peer=peer, mailfrom=mailfrom,
                              rcpttos=rcpttos, data=data),
                         serializer='pickle')
        base.log.info('Msg passed along')
