﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using Formula;
using Formula.Node;
using System.Text;
using System.Reflection;
using Formula.Node.Impl;


namespace UnitTestFormula
{
    [TestClass]
    public class UnitTest文字列関数
    {
        public UnitTest文字列関数()
        {
            //DllLoader loader = DllLoader.getInstance();
            //loader.Load();
        }
        
        [TestMethod]
        public void LEN1()
        {
            Assert.AreEqual(5m, FormulaTest.Formula("len(\"あいうえお\")", null));
        }
        [TestMethod]
        public void LEN2()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("len(\"  \")", null));
        }
        [TestMethod]
        public void LEN3()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("len(\"　\")", null));
        }
        [TestMethod]
        public void LEN4()
        {
            Assert.AreEqual(3m, FormulaTest.Formula("len(123)", null));
        }
        [TestMethod]
        public void LEN5()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("len(-1)", null));
        }
        [TestMethod]
        public void LEFT1()
        {
            Assert.AreEqual("あいう", FormulaTest.Formula("left(\"あいうえお\" , 3)", null));
        }
        [TestMethod]
        public void LEFT2()
        {
            Assert.AreEqual("あいうえお", FormulaTest.Formula("left(\"あいうえお\" , 7)", null));
        }
        [TestMethod]
        public void LEFT3()
        {
            Assert.AreEqual("", FormulaTest.Formula("left(\"あいうえお\" , 0)", null));
        }
        [TestMethod]
        public void LEFT4()
        {
            Assert.AreEqual("あいうえお", FormulaTest.Formula("left(\"あいうえお\" , 5)", null));
        }
        [TestMethod]
        public void LEFT5()
        {
            Assert.AreEqual("あいうえお", FormulaTest.Formula("left(\"あいうえお\" , 6)", null));
        }
        [TestMethod]
        public void LEFT6()
        {
            Assert.AreEqual("あいうえ", FormulaTest.Formula("left(\"あいうえお\" , 4)", null));
        }
        [TestMethod]
        public void RIGHT1()
        {
            Assert.AreEqual("", FormulaTest.Formula("right(\"あいうえお\" , 0)", null));
        }
        [TestMethod]
        public void RIGHT2()
        {
            Assert.AreEqual("うえお", FormulaTest.Formula("right(\"あいうえお\" , 3)", null));
        }
        [TestMethod]
        public void RIGHT3()
        {
            Assert.AreEqual("あいうえお", FormulaTest.Formula("right(\"あいうえお\" , 6)", null));
        }
        [TestMethod]
        public void RIGHT4()
        {
            Assert.AreEqual("いうえお", FormulaTest.Formula("right(\"あいうえお\" , 4)", null));
        }
        [TestMethod]
        public void RIGHT5()
        {
            Assert.AreEqual("あいうえお", FormulaTest.Formula("right(\"あいうえお\" , 5)", null));
        }
        [TestMethod]
        public void MID1()
        {
            Assert.AreEqual("あ", FormulaTest.Formula("mid(\"あいうえお\" , 1 , 1)", null));
        }
        [TestMethod]
        public void MID2()
        {
            Assert.AreEqual("い", FormulaTest.Formula("mid(\"あいうえお\" , 2 , 1)", null));
        }
        [TestMethod]
        public void MID3()
        {
            Assert.AreEqual("いう", FormulaTest.Formula("mid(\"あいうえお\" , 2 , 2)", null));
        }
        [TestMethod]
        public void MID4()
        {
            Assert.AreEqual("えお", FormulaTest.Formula("mid(\"あいうえお\" , 4 , 2)", null));
        }
        [TestMethod]
        public void MID5()
        {
            Assert.AreEqual("お", FormulaTest.Formula("mid(\"あいうえお\" , 5 , 2)", null));
        }
        [TestMethod]
        public void MID6()
        {
            Assert.AreEqual("", FormulaTest.Formula("mid(\"あいうえお\" , 6 , 2)", null));
        }
        [TestMethod]
        public void FIND1()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("find(\"あ\",\"あいうあ\" , 0)", null));
        }
        [TestMethod]
        public void FIND2()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("find(\"あ\",\"あいうあ\" , 1)", null));
        }
        [TestMethod]
        public void FIND3()
        {
            Assert.AreEqual(4m, FormulaTest.Formula("find(\"あ\",\"あいうあ\" , 2)", null));
        }
        [TestMethod]
        public void FIND4()
        {
            Assert.AreEqual(4m, FormulaTest.Formula("find(\"あ\",\"あいうあ\" , 4)", null));
        }
        [TestMethod]
        public void FIND5()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("find(\"あい\",\"あいうあ\" , 1)", null));
        }
        [TestMethod]
        public void FIND6()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("find(\"あ\",\"あいうあ\" , 5)", null));
        }
        [TestMethod]
        public void SUBSTITUTE1()
        {
            Assert.AreEqual("def", FormulaTest.Formula("substitute(\"abcdef\", \"abc\",\"\")", null));
        }
        [TestMethod]
        public void SUBSTITUTE2()
        {
            Assert.AreEqual("abcdef", FormulaTest.Formula("substitute(\"abcdef\", \"\",\"aaa\")", null));
        }
        [TestMethod]
        public void SUBSTITUTE3()
        {
            Assert.AreEqual("", FormulaTest.Formula("substitute(\"\", \"\",\"aaa\")", null));
        }
        [TestMethod]
        public void SUBSTITUTE4()
        {
            Assert.AreEqual("123bcdef", FormulaTest.Formula("substitute(\"abcdef\", \"a\",123)", null));
        }
        [TestMethod]
        public void SUBSTITUTE5()
        {
            Assert.AreEqual("abcdf", FormulaTest.Formula("substitute(\"abcdef\", \"e\",\"\")", null));
        }
    }
}
