﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using Formula;
using Formula.Node;
using System.Text;
using System.Reflection;
using Formula.Node.Impl;


namespace UnitTestFormula
{
    [TestClass]
    public class UnitTest四則演算
    {
        public UnitTest四則演算()
        {
            //DllLoader loader = DllLoader.getInstance();
            //loader.Load();
        }

        [TestMethod]
        public void 引き算1()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("3-2", null));
        }
        [TestMethod]
        public void 引き算2()
        {
            Assert.AreEqual(-7m, FormulaTest.Formula("-2-5", null));
        }
        [TestMethod]
        public void 引き算4()
        {
            Assert.AreEqual(1.0m, FormulaTest.Formula("2.1-1.1", null));
        }
        [TestMethod]
        public void 引き算3()
        {
            Assert.AreEqual(-3m, FormulaTest.Formula("2-5", null));
        }
        [TestMethod]
        public void 引き算5()
        {
            Assert.AreEqual(-0.5m, FormulaTest.Formula("2-2.5", null));
        }
        [TestMethod]
        public void 引き算6()
        {
            Assert.AreEqual(-0.1m, FormulaTest.Formula("0-0.1", null));
        }
        [TestMethod]
        public void 引き算7()
        {
            Assert.AreEqual(-0.1m, FormulaTest.Formula("-0.1", null));
        }
        [TestMethod]
        public void 足し算1()
        {
            Assert.AreEqual(3m, FormulaTest.Formula("1+2", null));
        }
        [TestMethod]
        public void 足し算2()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("-1+2", null));
        }
        [TestMethod]
        public void 足し算3()
        {
            Assert.AreEqual(1.9m, FormulaTest.Formula("-1.1+3", null));
        }
        [TestMethod]
        public void 足し算4()
        {
            Assert.AreEqual(3m, FormulaTest.Formula("0+3", null));
        }
        [TestMethod]
        public void 足し算5()
        {
            Assert.AreEqual(10.3m, FormulaTest.Formula("10+0.3", null));
        }
        [TestMethod]
        public void 足し算6()
        {
            Assert.AreEqual(0.3m, FormulaTest.Formula("0+0.3", null));
        }
        [TestMethod]
        public void 足し算7()
        {
            Assert.AreEqual(0.3m, FormulaTest.Formula("+0.3", null));
        }
        [TestMethod]
        public void べき乗1()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("1^2", null));
        }
        [TestMethod]
        public void べき乗2()
        {
            Assert.AreEqual(8m, FormulaTest.Formula("2^3", null));
        }
        [TestMethod]
        public void 掛け算1()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("1*2", null));
        }
        [TestMethod]
        public void 掛け算2()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("0*2", null));
        }
        [TestMethod]
        public void 掛け算3()
        {
            Assert.AreEqual(null, FormulaTest.Formula("*2", null));
        }
        [TestMethod]
        public void 掛け算4()
        {
            Assert.AreEqual(0.06m, FormulaTest.Formula("0.2*0.3", null));
        }
        [TestMethod]
        public void 掛け算5()
        {
            Assert.AreEqual(-2m, FormulaTest.Formula("-1*2", null));
        }
        [TestMethod]
        public void 掛け算6()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("-1*(-2)", null));
        }
        [TestMethod]
        public void 掛け算7()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("-1*-2", null));
        }
        [TestMethod]
        public void 掛け算8()
        {
            Assert.AreEqual(-2m, FormulaTest.Formula("1*-2", null));
        }
        [TestMethod]
        public void 割り算1()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("6/3", null));
        }
        [TestMethod]
        public void 割り算2()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("0/2", null));
        }
        [TestMethod]
        public void 割り算3()
        {
            try
            {
                Assert.AreEqual(0m, FormulaTest.Formula("3/0", null));
                Assert.AreEqual(1, 2);
            }catch(Exception)
            {
                Assert.AreEqual(1,1);
            }
        }
        [TestMethod]
        public void 割り算4()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("10/5", null));
        }
        [TestMethod]
        public void 括弧1()
        {
            Assert.AreEqual(7m, FormulaTest.Formula("1+2*3", null));
        }
        [TestMethod]
        public void 括弧2()
        {
            Assert.AreEqual(7m, FormulaTest.Formula("1+(2*3)", null));
        }
        [TestMethod]
        public void 括弧3()
        {
            Assert.AreEqual(40m, FormulaTest.Formula("2*(3+1)*5", null));
        }
        [TestMethod]
        public void 四則演算1()
        {
            Assert.AreEqual(14m, FormulaTest.Formula("2*3+1*5+3", null));
        }
        [TestMethod]
        public void 四則演算2()
        {
            Assert.AreEqual(17m, FormulaTest.Formula("2*3+1*5+3*2", null));
        }
        [TestMethod]
        public void 四則演算3()
        {
            Assert.AreEqual(46m, FormulaTest.Formula("2*(3+1)*5+3*2", null));
        }
        [TestMethod]
        public void 四則演算4()
        {
            Assert.AreEqual(-34m, FormulaTest.Formula("-2*(3+1)*5+3*2", null));
        }
        [TestMethod]
        public void 四則演算5()
        {
            Assert.AreEqual(-46m, FormulaTest.Formula("-2*(3+1)*5+3*(-2)", null));
        }
        [TestMethod]
        public void 文字列の演算1()
        {
            Assert.AreEqual("あいうえお", FormulaTest.Formula("\"あい\"&\"うえお\"", null));
        }
        [TestMethod]
        public void 文字列の演算2()
        {
            Assert.AreEqual("うえお", FormulaTest.Formula("\"\"&\"うえお\"", null));
        }
        [TestMethod]
        public void 文字列の演算3()
        {
            Assert.AreEqual("うえ", FormulaTest.Formula("\"\"&\"うえ\"&\"\"", null));
        }

        [TestMethod]
        public void 変数の利用1()
        {
            Dictionary<string, string> arg = new Dictionary<string, string>();
            arg.Add("a", "1");
            Assert.AreEqual("1", FormulaTest.Formula("a", arg));
        }
        [TestMethod]
        public void 変数の利用2()
        {
            Dictionary<string, string> arg = new Dictionary<string, string>();
            arg.Add("a", "1");
            Assert.AreEqual(2m, FormulaTest.Formula("a+1", arg));
        }

    }
}
