﻿/**
FormulaOperator.Variable.NumberNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;

namespace FormulaOperator.Variable
{
    public class NumberNode : AbstractValueNode
    {
        public override object Value
        {
            get { return this.getDecimal(); }
            set { base.Value = value; }
        }
        public override string Regex
        {
            get
            {
                return "^\\s*[-0-9]";
            }
        }

        public override string ToString()
        {
            return string.Format("{0}:[N:{1}-{2}] {3}", this.nodeId , this.startPosition, this.endPosition, this.Value);
        }
    }
}
