﻿
using System;
using System.Collections.Generic;
/**
FormulaOperator.Operator.MultiplyNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using FormulaOperator.Variable;


namespace FormulaOperator.Operator
{
    public class MultiplyNode : AbstractOperatorNode
    {
        private static string[] signature = { "*" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode), typeof(NumberNode) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override int priority { get { return 1; } }
        public override bool IsPermitLeftNodeBlank { get { return false; } }
        protected override INode execute()
        {
            decimal? ret = null;


            INode l = this.getLeftNode();
            INode r = this.getRightNode();

            IValueNode lret = l == null ? null : (IValueNode)l.eval();
            IValueNode rret = r == null ? null : (IValueNode)r.eval();

            decimal? lvalue = lret == null ? null : lret.getDecimal();
            decimal? rvalue = rret == null ? null : rret.getDecimal();

            if (lvalue == null && rvalue == null) ret = null;
            else if (lvalue == null) ret = null;
            else if (rvalue == null) ret = null;
            else ret = lvalue * rvalue;

            NumberNode v = new NumberNode();
            v.Value = ret;
            return v;
        }

    }
}
