﻿/**
FormulaMethod.String.MidNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.String
{
    public class MidNode : AbstractMethodNode
    {

        private static string[] signature = { "mid" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode) , typeof(NumberNode) , typeof(NumberNode)}; } }
        public override Type ReturnNode { get { return typeof(WordNode); } }
        public override string Note { get { return @"文字列から指定位置の文字列を返します。

第一引数：対象文字列
第二引数：切り取り開始位置（先頭文字は１）
第三引数：切り取る長さ

"; } }
        protected override INode execute()
        {
            INode ret = null;

            if (!(this.FormatArgs.Count > 2))
                throw new ArgumentException();

            string str = ((IValueNode)this.FormatArgs[0].eval()).Value.ToString();
            int st = decimal.ToInt32((decimal)((IValueNode)this.FormatArgs[1].eval()).getDecimal());
            int len = decimal.ToInt32((decimal)((IValueNode)this.FormatArgs[2].eval()).getDecimal());
            st = st < 1 ? 0 : st - 1;
            ret = new WordNode();
            ((WordNode)ret).Value = str.Substring( st , st + len < str.Length ? len : str.Length - st );
            return ret;
        }



    }
}
