﻿/**
FormulaMethod.String.LenNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.String
{
    public class LenNode : AbstractMethodNode
    {

        private static string[] signature = { "len" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode)}; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"引数の文字数を返します。

第１引数：文字数をかぞえる文字列
"; } }
        protected override INode execute()
        {
            INode ret = null;

            if (!(this.FormatArgs.Count > 0))
                throw new ArgumentException();
            ret = this.FormatArgs[0];
            string str = ((IValueNode)this.FormatArgs[0].eval()).Value.ToString();
            ret = new NumberNode();
            ((NumberNode)ret).Value = str.Length;
            return ret;
        }



    }
}
