﻿/**
FormulaMethod.Math.RoundNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Math
{
    public class RoundNode : AbstractMethodNode
    {
        private static string[] signature = { "round" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode), typeof(NumberNode) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"第一引数を第二引数の桁で四捨五入します。

例)
round(456.456 , -3) = 0
round(456.456 , -2) = 500
round(456.456 , -1) = 450
round(456.456 , 0)  = 456
round(456.456 , 1)  = 456.5
round(456.456 , 2)  = 456.46
round(456.456 , 3)  = 456.456

round(-456.456 , -3) = 0
round(-456.456 , -2) = -500
round(-456.456 , -1) = -460
round(-456.456 , 0)  = -456
round(-456.456 , 1)  = -456.5
round(-456.456 , 2)  = -456.46
round(-456.456 , 3)  = -456.456
"; } }
        protected override INode execute()
        {

            decimal value = 0m;
            decimal? tmp = ((IValueNode)this.FormatArgs[0].eval()).getDecimal();
            decimal? keta = this.FormatArgs.Count <= 1 ? 0m : ((IValueNode)this.FormatArgs[1].eval()).getDecimal();

            double k = System.Math.Abs(System.Math.Pow(10, (double)keta));
            tmp = (decimal)tmp * (decimal)k;
            tmp = System.Math.Round((decimal)tmp);
            value = ((decimal)tmp) / (decimal)k;

            NumberNode ret = new NumberNode();
            ret.Value = value;

            return ret;
        }

    }
}
