﻿/**
FormulaMethod.Math.ProductNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Math
{
    public class ProductNode : AbstractMethodNode
    {
        private static string[] signature = { "product" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode[]) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"引数をすべて掛け合わせた数値を返します。
"; } }
        protected override INode execute()
        {

            decimal value = 1m;
            foreach (INode node in this.FormatArgs)
            {
                decimal? a = ((IValueNode)node.eval()).getDecimal();
                if(a != null)
                    value *= (decimal)a;
            }
            NumberNode ret = new NumberNode();
            ret.Value = value;

            return ret;
        }

    }
}
