﻿/**
FormulaMethod.Math.ModNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Math
{
    public class ModNode : AbstractMethodNode
    {
        private static string[] signature = { "mod" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode), typeof(NumberNode) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"第一引数を第二引数で割ったときの余りを返します。
"; } }
        protected override INode execute()
        {

            decimal value = 0m;
            decimal? arg1 = ((IValueNode)this.FormatArgs[0].eval()).getDecimal();
            decimal? arg2 = this.FormatArgs.Count <= 1 ? 0m : ((IValueNode)this.FormatArgs[1].eval()).getDecimal();

            value = ((decimal)arg1) % ((decimal)arg2);

            NumberNode ret = new NumberNode();
            ret.Value = value;

            return ret;
        }

    }
}
