﻿/**
FormulaMethod.Math.MinNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Math
{
    public class MinNode : AbstractMethodNode
    {
        private static string[] signature = { "min" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode[]) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"引数の最小値を返します。
"; } }
        protected override INode execute()
        {
            decimal? value = null;
            foreach(INode node in this.FormatArgs)
            {
                
                if( node == null )continue;
                decimal? arg = ((IValueNode)node.eval()).getDecimal();
                if (arg != null)
                    value = (value == null || (decimal)arg < value) ? (decimal)arg : value;
            }
            NumberNode ret = new NumberNode();
            ret.Value = value;

            return ret;
        }

    }
}
