﻿/**
FormulaMethod.Math.IntNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Math
{
    public class IntNode : AbstractMethodNode
    {
        private static string[] signature = { "int" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"引数の整数値を返します。
"; } }
        protected override INode execute()
        {

            decimal value = 0m;
            decimal? tmp = ((IValueNode)this.FormatArgs[0].eval()).getDecimal();
            decimal? keta = this.FormatArgs.Count <= 1 ? 0m : ((IValueNode)this.FormatArgs[1].eval()).getDecimal();

            double t = (double)tmp;
            double k = System.Math.Abs(System.Math.Pow(10, -1 * (double)keta));
            t = t / k;
            t = System.Math.Floor(t) * k;
            value = (decimal) t;

            NumberNode ret = new NumberNode();
            ret.Value = value;

            return ret;
        }

    }
}
