﻿/**
FormulaMethod.Math.AbsNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Math
{
    public class AbsNode : AbstractMethodNode
    {
        private static string[] signature = { "abs" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"引数の絶対値を返します。
"; } }
        protected override INode execute()
        {

            decimal value = 0m;
            decimal? arg1 = ((IValueNode)this.FormatArgs[0].eval()).getDecimal();

            value = System.Math.Abs((decimal)arg1);

            NumberNode ret = new NumberNode();
            ret.Value = value;

            return ret;
        }

    }
}
