﻿/**
FormulaMethod.Logical.IsErrorNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Logical
{
    public class IsErrorNode : AbstractMethodNode
    {
        private static string[] signature = { "iserror" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(INode[]) }; } }
        public override Type ReturnNode { get { return typeof(BoolNode); } }
        public override string Note { get { return @"引数の評価によりエラーが発生した時にTrueを返します。

引数は一つ以上である必要があります。
"; } }
        protected override INode execute()
        {
            bool b = false;
            foreach (INode node in this.FormatArgs)
            {
                b |= node.eval() is ErrorNode;
                if (b) break;
            }
            BoolNode ret = new BoolNode();
            ret.Value = b;

            return ret;
        }

    }
}
