﻿/**
FormulaDebugger.Program

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FormulaDebugger
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            DirectoryInfo directoryInfo = new FileInfo(Assembly.GetEntryAssembly().Location).Directory;
            //string libratyPath = Path.Combine(directoryInfo.FullName, "lib");

            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            DebuggerForm form = new DebuggerForm();
            form.DllPath = directoryInfo.FullName;
            Application.Run(form);
        }
    }
}
