﻿/**
Formula.VariableSetVisitor

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using System.Collections.Concurrent;
using System.Collections.Generic;

namespace Formula
{
    /// <summary>
    /// 構築した構文木に含まれる構文木を操作します。
    /// （複数式でインスタンスを共有することはできません）
    /// </summary>
    public class VariableManager
    {
        /// <summary>
        /// 読みだした変数のリスト
        /// </summary>
        public IDictionary<string, IValueNode> variableDictionary { get; set; }
        /// <summary>
        /// 処理対象となる構文木のルートノード
        /// </summary>
        public INode Node {get;set;}

        /// <summary>
        /// 構文木中に出てくる変数ノード
        /// </summary>
        public List<INode> variableNode { get; set; }


        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="node"></param>
        public VariableManager(INode node)
        {
            this.variableDictionary = new ConcurrentDictionary<string, IValueNode>();
            this.variableNode = new List<INode>();
            this.Node = node;
        }

        /// <summary>
        /// 構文木より変数のシグネチャを抜き出します
        /// </summary>
        /// <returns></returns>
        public void loadVariable()
        {
            if (this.Node is VariableNode)
            {
                if(!this.variableDictionary.ContainsKey((string)((VariableNode)this.Node).Value))
                    this.variableDictionary.Add((string)((VariableNode)this.Node).Value, (IValueNode)this.Node);
                this.variableNode.Add(this.Node);
            }
            else if (this.Node is IFunctionNode)
            {
                foreach (INode childNode in ((IFunctionNode)this.Node).Args)
                {
                    if (childNode == null) continue;
                    VariableManager man = new VariableManager(childNode);
                    man.variableDictionary = this.variableDictionary;
                    man.variableNode = this.variableNode;
                    man.loadVariable();
                }
            }
        }
        
        /// <summary>
        /// 構文木に変数をセットします
        /// </summary>
        public void setVariable()
        {
            foreach(INode variableNode in this.variableNode)
                ((VariableNode)variableNode).variableDictionary = this.variableDictionary;
            //if (this.Node is VariableNode){
            //    ((VariableNode)this.Node).variableDictionary = this.variableDictionary;
            //    return;
            //}
            //else if (this.Node is IFunctionNode)
            //{
            //    foreach (INode childNode in ((IFunctionNode)this.Node).Args)
            //    {
            //        if (childNode == null) continue;
            //        VariableSetVisitor man = new VariableSetVisitor(childNode);
            //        man.variableDictionary = this.variableDictionary;
            //        man.setVariable();
            //    }
            //}
        }



    }
}
