﻿/**
Formula.StepExecuteVisitor

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;

namespace Formula
{
    /// <summary>
    /// ステップ実行を行います。
    /// すでに構築された構文木を通常のルートで処理をします。
    /// 一つ処理をすると処理が戻ります。
    /// </summary>
    public class StepExecuteVisitor
    {
        /// <summary>
        /// 処理対象のノード
        /// </summary>
        public INode currentNode { get; set; }
        /// <summary>
        /// 処理後のノードID
        /// </summary>
        public int replaceToId { get; set; }
        /// <summary>
        /// 処理前のノードID(処理後は存在しない)
        /// </summary>
        public int replaceFromId { get; set; }
        
        /// <summary>
        /// 実行します。
        /// </summary>
        /// <param name="currentNode">処理対象となるノード</param>
        /// <param name="isUpdate">True:ノードを処理し、構文木を再構築する False:処理対象ノードを特定するだけで再構築はしない</param>
        public void Execute(INode currentNode , bool isUpdate = true)
        {
            //int ret = -1;
            this.replaceToId = -1;
            this.replaceFromId = -1;
            this.currentNode = currentNode;
            if (this.currentNode is IFunctionNode)
            {
                bool isBase = true;
                foreach (INode node in ((IFunctionNode)currentNode).Args)
                {
                    if (node == null) continue;
                    isBase &= node is IValueNode;
                }

                if (!isBase)
                {
                    foreach (INode node in ((IFunctionNode)currentNode).Args)
                    {
                        StepExecuteVisitor visitor = new StepExecuteVisitor();
                        visitor.Execute(node , isUpdate);
                        this.replaceToId = visitor.replaceToId;
                        this.replaceFromId = visitor.replaceFromId;
                        if (this.replaceToId > 0)
                            break;
                    }
                    return ;
                }

                this.replaceFromId = this.currentNode.nodeId;
                INode resultNode = this.currentNode.eval();
                this.replaceToId = resultNode.nodeId;
                
                if (this.currentNode.ParentNode == null)
                    this.currentNode = resultNode;
                else if (isUpdate)
                    for (int i = 0 ; i < ((IFunctionNode)this.currentNode.ParentNode).Args.Count ; i++)
                    {
                        INode node = ((IFunctionNode)this.currentNode.ParentNode).Args[i];
                        if (node == this.currentNode)
                        {
                            ((IFunctionNode)this.currentNode.ParentNode).Args[i] = resultNode;
                            return;
                        }
                    }
            }
            return;
        }
    }
}
