﻿/**
Formula.Node.NodeVisitor

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/


using Formula.Node;
namespace Formula
{
    /// <summary>
    /// 構文木を文字列化するためのクラス。
    /// 関数の引数を整理した状態で文字列化します
    /// </summary>
    public class NodeFormatVisitor
    {
        public INode Target { get; set; }
        public string Header { get; set; }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public NodeFormatVisitor()
        {
            this.Header = string.Empty;
        }

        /// <summary>
        /// カレントノードを示す文字列を取得します
        /// </summary>
        /// <returns></returns>
        public virtual string currentNodeString()
        {
            if (this.Target == null)
                return string.Format("{0}-null-", this.Header);
            else
                return string.Format("{0}{1}", this.Header, this.Target.ToString());
        }

        /// <summary>
        /// ノードの文字列を組み立てます。
        /// 子供ノードがある場合は再帰します
        /// </summary>
        /// <param name="target"></param>
        /// <returns></returns>
        public string visit(INode target = null)
        {
            if (target != null) this.Target = target;
            string ret = this.currentNodeString();
            
            if(this.Target is IMethodNode)
            {
                for (int i = 0; i < ((IMethodNode)this.Target).FormatArgs.Count; i++)
                {
                    INode elem = ((IMethodNode)this.Target).FormatArgs[i];
                    string childHeader = this.Header.Replace("└", "　").Replace("├", "│");
                    if (i == 0) childHeader += "├";
                    else if (i == ((IMethodNode)this.Target).FormatArgs.Count - 1) childHeader += "└";
                    else childHeader += "├";

                    NodeFormatVisitor v = new NodeFormatVisitor();
                    v.Target = elem;
                    v.Header = childHeader;
                    ret += "\r\n" + v.visit();
                }

            }
            else if (this.Target is IOperatorNode)
            {
                
                for(int i = 0 ; i < ((IFunctionNode)this.Target).Args.Count ; i++)
                {
                    INode elem = ((IFunctionNode)this.Target).Args[i];


                    if (elem is ISeparatorNode)
                    {
                        string childHeader = this.Header.Replace("└", "　").Replace("├", "│");
                        if (i == 0 && ((IFunctionNode)this.Target).Args.Count == 1) childHeader += "└";
                        else if (i == 0) childHeader += "├";
                        else if (i == ((IFunctionNode)this.Target).Args.Count - 1) childHeader += "└";
                        else childHeader += "│";

                        ArrayVisitor a = new ArrayVisitor();
                        a.target = elem;
                        foreach (INode aa in a.getArgs())
                        {
                            NodeFormatVisitor v = new NodeFormatVisitor();
                            v.Target = aa;
                            v.Header = childHeader;
                            ret += "\r\n" + v.visit();
                        }
                    }
                    else
                    {
                        string childHeader = this.Header.Replace("└", "　").Replace("├", "│");
                        if (i == 0 && ((IFunctionNode)this.Target).Args.Count == 1) childHeader += "└";
                        else if (i == 0) childHeader += "├";
                        else if (i == ((IFunctionNode)this.Target).Args.Count - 1) childHeader += "└";
                        else childHeader += "│";

                        NodeFormatVisitor v = new NodeFormatVisitor();
                        v.Target = elem;
                        v.Header = childHeader;
                        ret += "\r\n" + v.visit();
                    }
                }
            }
            return ret;
        }

    }
}
