﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using Formula;
using Formula.Node;
using System.Text;
using System.Reflection;
using Formula.Node.Impl;


namespace UnitTestFormula
{
    [TestClass]
    public class UnitTest特殊な式
    {
        public UnitTest特殊な式()
        {
            //DllLoader loader = DllLoader.getInstance();
            //loader.Load();
        }

        [TestMethod]
        public void 式_1()
        {
            Assert.AreEqual("(", FormulaTest.Formula(@"""(""", null));
        }
        
        [TestMethod]
        public void 式_2()
        {
            Assert.AreEqual(0m, FormulaTest.Formula(@"abs(1)-1", null));
        }
        [TestMethod]
        public void 式_3()
        {
            Assert.AreEqual(-1m, FormulaTest.Formula(@"abs(1)-abs(-2)", null));
        }
        [TestMethod]
        public void IF_1()
        {
            Assert.AreEqual("2", FormulaTest.Formula("if(true,trim(\"2\") , 3)", null));
        }
        [TestMethod]
        public void IF_2()
        {
            Assert.AreEqual("2", FormulaTest.Formula("if(true , trim(\"2\") , 3)", null));
        }
        [TestMethod]
        public void IF_3()
        {
            Assert.AreEqual("3", FormulaTest.Formula("if(false , trim (\"2\" ) , trim(\"3\"))", null));
        }

        [TestMethod]
        public void IF_4()
        {
            Assert.AreEqual(7m, FormulaTest.Formula("if(mod(12 ,10)=2 , 1+2*3 , \"a\" & trim(\"b\"))", null));
        }
        [TestMethod]
        public void IF_5()
        {
            Assert.AreEqual("ab", FormulaTest.Formula("if(mod(12 ,10)=3 , 1+2*3 , \"a\" & trim(\"b\"))", null));
        }

        [TestMethod]
        public void Special_1()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("1+2*", null));
        }
        
        [TestMethod]
        public void 式の組み合わせ_1()
        {
            Dictionary<string, string> arg = new Dictionary<string, string>();
            arg.Add("$1", "1.0(2.0)");
            Assert.AreEqual("2.0", FormulaTest.Formula(@"if(
find(""("",$1,1)>0
, mid($1, find(""("",$1, 1)+1, find("")"",$1, 1)-find(""("",$1, 1)-1)
, ""-""
)", arg));
        }
        [TestMethod]
        public void 式の組み合わせ_2()
        {
            Dictionary<string, string> arg = new Dictionary<string, string>();
            arg.Add("$1", "1.0");
            Assert.AreEqual("-", FormulaTest.Formula(@"if(
find(""("",$1,1)>0
, mid($1, find(""("",$1, 1)+1, find("")"",$1, 1)-find(""("",$1, 1)-1)
, ""-""
)", arg));
        }


        
                [TestMethod]
        public void 式の組み合わせ_3()
        {
            Dictionary<string, string> arg = new Dictionary<string, string>();
            arg.Add("$4", "172");
            arg.Add("$5", "78");
            Assert.AreEqual(26.3m, FormulaTest.Formula(@"rounddown($5/(($4/100)*($4/100)),1)", arg));
        }
    }
}
