﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using Formula;
using Formula.Node;
using System.Text;
using System.Reflection;
using Formula.Node.Impl;


namespace UnitTestFormula
{
    [TestClass]
    public class UnitTest日付関数
    {
        public UnitTest日付関数()
        {
            //DllLoader loader = DllLoader.getInstance();
            //loader.Load();
        }

        [TestMethod]
        public void date1()
        {
            Assert.AreEqual(DateTime.Parse("2015/02/04 23:50:23.1123"), FormulaTest.Formula("date(2015,2,4,23,50,23,1123)", null));
        }
        [TestMethod]
        public void date2()
        {
            Assert.AreEqual(DateTime.Parse("2015/02/04 23:50:23"), FormulaTest.Formula("date(2015,2,4,23,50,23)", null));
        }
        [TestMethod]
        public void date3()
        {
            Assert.AreEqual(DateTime.Parse("2015/02/04"), FormulaTest.Formula("date(2015,2,\"4\")", null));
        }
        [TestMethod]
        public void date4()
        {
            Assert.AreEqual(DateTime.Parse("2015/02/04 23:50:23"), FormulaTest.Formula("date(\"2015/2/4 23:50:23\")", null));
        }
        [TestMethod]
        public void date5()
        {
            Assert.AreEqual(DateTime.Parse("2015/02/04 00:00:00"), FormulaTest.Formula("date(\"2015/2/4\")", null));
        }
        public void date_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("date(0/0)", null) );
        }
        public void date_E02()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("date(2004 , 0/0)", null)  );
        }
        public void date_E03()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("date(2004 , 01 , 0/0)", null) );
        }
        public void date_E04()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("date(2004 , 01 , 01 , 0/0)", null)  );
        }
        public void date_E05()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("date(2004 , 01 , 01 , 01 , 0/0)", null)  );
        }
        public void date_E06()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("date(2004 , 01 , 01 , 01 , 01 , 0/0)", null)  );
        }
        public void date_E07()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("date(2004 , 01 , 01 , 01 , 01 , 01 ,01)", null) );
        }



        [TestMethod]
        public void now1()
        {
            Console.WriteLine(FormulaTest.Formula("now()", null));
        }
        [TestMethod]
        public void today1()
        {
            Console.WriteLine(FormulaTest.Formula("today()", null));
        }

        [TestMethod]
        public void year_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("year(0/0)", null));
        }
        [TestMethod]
        public void year01()
        {
            Assert.AreEqual(2016m, FormulaTest.Formula("year(date(2016, 3, 2, 23, 47, 0)))", null));
        }
        [TestMethod]
        public void month_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("month(0/0)", null));
        }
        [TestMethod]
        public void month01()
        {
            Assert.AreEqual(3m, FormulaTest.Formula("month(date(2016, 3, 2, 23, 47, 0)))", null));
        }
        [TestMethod]
        public void day_E01()
        {
            Assert.AreEqual("-ERR-" , FormulaTest.Formula("day(0/0)", null));
        }
        [TestMethod]
        public void day01()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("day(date(2016, 3, 2, 23, 47, 0)))", null));
        }
        [TestMethod]
        public void day02()
        {
            Assert.AreEqual(30m, FormulaTest.Formula("day(date(2016, 1, 30, 23, 47, 0)))", null));
        }
        [TestMethod]
        public void hour_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("hour(0/0)", null));
        }
        [TestMethod]
        public void hour01()
        {
            Assert.AreEqual(23m, FormulaTest.Formula("hour(date(2016, 1, 30, 23, 45, 0)))", null));
        }
        [TestMethod]
        public void hour02()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("hour(date(2016, 1, 30, 0, 23, 0)))", null));
        }
        [TestMethod]
        public void minute_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("minute(0/0)", null));
        }
        [TestMethod]
        public void minute01()
        {
            Assert.AreEqual(45m, FormulaTest.Formula("minute(date(2016, 1, 30, 23, 45, 0)))", null));
        }
        [TestMethod]
        public void minute02()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("minute(date(2016, 1, 30, 0, 0, 0)))", null));
        }
        [TestMethod]
        public void second_E01()
        {
            Assert.AreEqual("-ERR-",  FormulaTest.Formula("second(0/0)", null));
        }
        [TestMethod]
        public void second01()
        {
            Assert.AreEqual(0m, FormulaTest.Formula("second(date(2016, 1, 30, 23, 47, 0)))", null));
        }
        [TestMethod]
        public void second02()
        {
            Assert.AreEqual(59m, FormulaTest.Formula("second(date(2016, 1, 30, 23, 47, 59)))", null));
        }

        [TestMethod]
        public void dateadd01()
        {
            Assert.AreEqual(DateTime.Parse("2017/01/30 23:47:59"), FormulaTest.Formula("dateadd(\"Y\" , 1 , date(2016, 1, 30, 23, 47, 59)))", null));
        }
        [TestMethod]
        public void dateadd02()
        {
            Assert.AreEqual(DateTime.Parse("2015/01/30 23:47:59"), FormulaTest.Formula("dateadd(\"Y\" , -1 , date(2016, 1, 30, 23, 47, 59)))", null));
        }
        [TestMethod]
        public void dateadd03()
        {
            Assert.AreEqual(DateTime.Parse("2015/11/30 23:47:59"), FormulaTest.Formula("dateadd(\"m\" , -2 , date(2016, 1, 30, 23, 47, 59)))", null));
        }
        [TestMethod]
        public void dateadd04()
        {
            Assert.AreEqual(DateTime.Parse("2016/02/01 23:47:59"), FormulaTest.Formula("dateadd(\"d\" , 2 , date(2016, 1, 30, 23, 47, 59)))", null));
        }
        [TestMethod]
        public void dateadd05()
        {
            Assert.AreEqual(DateTime.Parse("2016/01/31 01:47:59"), FormulaTest.Formula("dateadd(\"h\" , 2 , date(2016, 1, 30, 23, 47, 59)))", null));
        }
        [TestMethod]
        public void dateadd06()
        {
            Assert.AreEqual(DateTime.Parse("2016/02/29 23:00:59"), FormulaTest.Formula("dateadd(\"h\" , -2 , date(2016, 3, 1, 01, 00, 59)))", null));
        }
        [TestMethod]
        public void dateadd07()
        {
            Assert.AreEqual(DateTime.Parse("2016/02/29 23:59:01"), FormulaTest.Formula("dateadd(\"n\" , -1 , date(2016, 3, 1, 00, 00, 01)))", null));
        }
        [TestMethod]
        public void dateadd08()
        {
            Assert.AreEqual(DateTime.Parse("2016/02/29 23:59:59"), FormulaTest.Formula("dateadd(\"s\" , -2 , date(2016, 3, 1, 00, 00, 01)))", null));
        }
        public void dateadd_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("dateadd(0/0 , -2 , date(2016, 3, 1, 00, 00, 01)))", null));
        }

        public void dateadd_E02()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("dateadd(\"s\" , 0/0 , date(2016, 3, 1, 00, 00, 01)))", null));
        }

        public void dateadd_E03()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("dateadd(\"s\" , -2 , 0/0)", null));
        }
    }
}
