﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using Formula;
using Formula.Node;
using System.Text;
using System.Reflection;
using Formula.Node.Impl;


namespace UnitTestFormula
{
    [TestClass]
    public class UnitTest文字列関数
    {
        public UnitTest文字列関数()
        {
            //DllLoader loader = DllLoader.getInstance();
            //loader.Load();
        }
        [TestMethod]
        public void LEN_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("len(0/0)", null));
        }
        [TestMethod]
        public void LEN1()
        {
            Assert.AreEqual(5m, FormulaTest.Formula("len(\"あいうえお\")", null));
        }
        [TestMethod]
        public void LEN2()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("len(\"  \")", null));
        }
        [TestMethod]
        public void LEN3()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("len(\"　\")", null));
        }
        [TestMethod]
        public void LEN4()
        {
            Assert.AreEqual(3m, FormulaTest.Formula("len(123)", null));
        }
        [TestMethod]
        public void LEN5()
        {
            Assert.AreEqual(2m, FormulaTest.Formula("len(-1)", null));
        }
        [TestMethod]
        public void LEFT_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("left(0/0 , 3)", null));
        }
        [TestMethod]
        public void LEFT_E02()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("left(\"aaa\" , 0/0)", null));
        }
        [TestMethod]
        public void LEFT1()
        {
            Assert.AreEqual("あいう", FormulaTest.Formula("left(\"あいうえお\" , 3)", null));
        }
        [TestMethod]
        public void LEFT2()
        {
            Assert.AreEqual("あいうえお", FormulaTest.Formula("left(\"あいうえお\" , 7)", null));
        }
        [TestMethod]
        public void LEFT3()
        {
            Assert.AreEqual("", FormulaTest.Formula("left(\"あいうえお\" , 0)", null));
        }
        [TestMethod]
        public void LEFT4()
        {
            Assert.AreEqual("あいうえお", FormulaTest.Formula("left(\"あいうえお\" , 5)", null));
        }
        [TestMethod]
        public void LEFT5()
        {
            Assert.AreEqual("あいうえお", FormulaTest.Formula("left(\"あいうえお\" , 6)", null));
        }
        [TestMethod]
        public void LEFT6()
        {
            Assert.AreEqual("あいうえ", FormulaTest.Formula("left(\"あいうえお\" , 4)", null));
        }
        [TestMethod]
        public void RIGHT_E02()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("right(\"あいうえお\" , 0/0)", null));
        }
        [TestMethod]
        public void RIGHT_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("right(0/0 , 2)", null));
        }
        [TestMethod]
        public void RIGHT1()
        {
            Assert.AreEqual("", FormulaTest.Formula("right(\"あいうえお\" , 0)", null));
        }
        [TestMethod]
        public void RIGHT2()
        {
            Assert.AreEqual("うえお", FormulaTest.Formula("right(\"あいうえお\" , 3)", null));
        }
        [TestMethod]
        public void RIGHT3()
        {
            Assert.AreEqual("あいうえお", FormulaTest.Formula("right(\"あいうえお\" , 6)", null));
        }
        [TestMethod]
        public void RIGHT4()
        {
            Assert.AreEqual("いうえお", FormulaTest.Formula("right(\"あいうえお\" , 4)", null));
        }
        [TestMethod]
        public void RIGHT5()
        {
            Assert.AreEqual("あいうえお", FormulaTest.Formula("right(\"あいうえお\" , 5)", null));
        }
        [TestMethod]
        public void MID_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("mid(0/0 , 1 , 1)", null));
        }
        [TestMethod]
        public void MID_E02()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("mid(\"あいうえお\" , 1/0 , 1)", null));
        }
        [TestMethod]
        public void MID_E03()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("mid(\"あいうえお\" , 1 , 1/0)", null));
        }
        [TestMethod]
        public void MID1()
        {
            Assert.AreEqual("あ", FormulaTest.Formula("mid(\"あいうえお\" , 1 , 1)", null));
        }
        [TestMethod]
        public void MID2()
        {
            Assert.AreEqual("い", FormulaTest.Formula("mid(\"あいうえお\" , 2 , 1)", null));
        }
        [TestMethod]
        public void MID3()
        {
            Assert.AreEqual("いう", FormulaTest.Formula("mid(\"あいうえお\" , 2 , 2)", null));
        }
        [TestMethod]
        public void MID4()
        {
            Assert.AreEqual("えお", FormulaTest.Formula("mid(\"あいうえお\" , 4 , 2)", null));
        }
        [TestMethod]
        public void MID5()
        {
            Assert.AreEqual("お", FormulaTest.Formula("mid(\"あいうえお\" , 5 , 2)", null));
        }
        [TestMethod]
        public void MID6()
        {
            Assert.AreEqual("", FormulaTest.Formula("mid(\"あいうえお\" , 6 , 2)", null));
        }
        [TestMethod]
        public void FIND_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("find(0/0,\"あいうあ\" , 0)", null));
        }
        [TestMethod]
        public void FIND_E02()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("find(\"あ\",0/0 , 0)", null));
        }
        [TestMethod]
        public void FIND_E03()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("find(\"あ\",\"あいうあ\" , 0/0)", null));
        }
        [TestMethod]
        public void FIND1()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("find(\"あ\",\"あいうあ\" , 0)", null));
        }
        [TestMethod]
        public void FIND2()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("find(\"あ\",\"あいうあ\" , 1)", null));
        }
        [TestMethod]
        public void FIND3()
        {
            Assert.AreEqual(4m, FormulaTest.Formula("find(\"あ\",\"あいうあ\" , 2)", null));
        }
        [TestMethod]
        public void FIND4()
        {
            Assert.AreEqual(4m, FormulaTest.Formula("find(\"あ\",\"あいうあ\" , 4)", null));
        }
        [TestMethod]
        public void FIND5()
        {
            Assert.AreEqual(1m, FormulaTest.Formula("find(\"あい\",\"あいうあ\" , 1)", null));
        }
        [TestMethod]
        public void FIND6()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("find(\"あ\",\"あいうあ\" , 5)", null));
        }
        [TestMethod]
        public void SUBSTITUTE_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("substitute(0/0, \"abc\",\"\")", null));
        }
        [TestMethod]
        public void SUBSTITUTE_E02()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("substitute(\"abcdef\", 0/0,\"\")", null));
        }
        [TestMethod]
        public void SUBSTITUTE_E03()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("substitute(\"abcdef\", \"abc\",0/0)", null));
        }
        [TestMethod]
        public void SUBSTITUTE1()
        {
            Assert.AreEqual("def", FormulaTest.Formula("substitute(\"abcdef\", \"abc\",\"\")", null));
        }
        [TestMethod]
        public void SUBSTITUTE2()
        {
            Assert.AreEqual("abcdef", FormulaTest.Formula("substitute(\"abcdef\", \"\",\"aaa\")", null));
        }
        [TestMethod]
        public void SUBSTITUTE3()
        {
            Assert.AreEqual("", FormulaTest.Formula("substitute(\"\", \"\",\"aaa\")", null));
        }
        [TestMethod]
        public void SUBSTITUTE4()
        {
            Assert.AreEqual("123bcdef", FormulaTest.Formula("substitute(\"abcdef\", \"a\",123)", null));
        }
        [TestMethod]
        public void SUBSTITUTE5()
        {
            Assert.AreEqual("abcdf", FormulaTest.Formula("substitute(\"abcdef\", \"e\",\"\")", null));
        }
        [TestMethod]
        public void CONCATENATE_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("concatenate(0/0)", null));
        }

        [TestMethod]
        public void CONCATENATE1()
        {
            Assert.AreEqual("a", FormulaTest.Formula("concatenate(\"a\")", null));
        }
        [TestMethod]
        public void CONCATENATE2()
        {
            Assert.AreEqual("ab", FormulaTest.Formula("concatenate(\"a\",\"b\")", null));
        }
        [TestMethod]
        public void CONCATENATE3()
        {
            Assert.AreEqual("abc", FormulaTest.Formula("concatenate(\"a\",\"b\",\"c\")", null));
        }
        [TestMethod]
        public void CONCATENATE4()
        {
            Assert.AreEqual("ac", FormulaTest.Formula("concatenate(\"a\",,\"c\")", null));
        }
        [TestMethod]
        public void Clean_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula(@"clean(0/0)", null));
        }
        [TestMethod]
        public void Clean1()
        {
            Assert.AreEqual("a", FormulaTest.Formula(@"clean(""a
"")", null));
        }
        [TestMethod]
        public void Clean2()
        {
            Assert.AreEqual("ab", FormulaTest.Formula(@"clean(""a
b"")", null));
        }
        [TestMethod]
        public void Clean3()
        {
            Assert.AreEqual("a b", FormulaTest.Formula(@"clean(""a b"")", null));
        }
        [TestMethod]
        public void Clean4()
        {
            Assert.AreEqual("ab", FormulaTest.Formula("clean(\"a\tb\")", null));
        }
        [TestMethod]
        public void Upper_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("upper(0/0)", null));
        }
        [TestMethod]
        public void Upper1()
        {
            Assert.AreEqual("AB", FormulaTest.Formula("upper(\"aB\")", null));
        }
        [TestMethod]
        public void Upper2()
        {
            Assert.AreEqual("ＡＢ", FormulaTest.Formula("upper(\"ａｂ\")", null));
        }
        [TestMethod]
        public void Upper3()
        {
            Assert.AreEqual("ぁＢ", FormulaTest.Formula("upper(\"ぁｂ\")", null));
        }
        [TestMethod]
        public void lower_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("lower(0/0)", null));
        }
        [TestMethod]
        public void lower1()
        {
            Assert.AreEqual("ab", FormulaTest.Formula("lower(\"aB\")", null));
        }
        [TestMethod]
        public void lower2()
        {
            Assert.AreEqual("ａｂ", FormulaTest.Formula("lower(\"ＡＢ\")", null));
        }
        [TestMethod]
        public void lower3()
        {
            Assert.AreEqual("あｂ", FormulaTest.Formula("lower(\"あＢ\")", null));
        }
        [TestMethod]
        public void textj_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("textj(0/0,\"gy年M月d日\")", null));
        }
        [TestMethod]
        public void textj_E02()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("textj(date(\"2015/2/20 23:0:3\"),0/0)", null));
        }
        [TestMethod]
        public void textj1()
        {
            Assert.AreEqual("平成27年2月20日", FormulaTest.Formula("textj(date(\"2015/2/20 23:0:3\"),\"gy年M月d日\")", null));
        }
        [TestMethod]
        public void textj2()
        {
            Assert.AreEqual("昭和60/02/20-23:00:03", FormulaTest.Formula("textj(date(\"1985/2/20 23:0:3\"),\"gy/MM/dd-HH:mm:ss\")", null));
        }
        [TestMethod]
        public void textj3()
        {
            Assert.AreEqual("27/02/20-23:00:03", FormulaTest.Formula("textj(date(\"2015/2/20 23:0:3\"),\"yyyy/MM/dd-HH:mm:ss\")", null));
        }
        [TestMethod]
        public void textj4()
        {
            Assert.AreEqual("平成7年2月20日", FormulaTest.Formula("textj(date(\"1995/2/20 23:0:3\"),\"gy年M月d日\")", null));
        }
        [TestMethod]
        public void textj5()
        {
            Assert.AreEqual("平成07年02月02日", FormulaTest.Formula("textj(date(\"1995/2/2 23:0:3\"),\"gyy年MM月dd日\")", null));
        }
        [TestMethod]
        public void textj7()
        {
            Assert.AreEqual("平成07年2月02日(木曜日)", FormulaTest.Formula("textj(date(\"1995/2/2 23:0:3\"),\"gyy年MMM月dd日(dddd)\")", null));
        }
        [TestMethod]
        public void textj9()
        {
            Assert.AreEqual("平成07年2月02日 午後", FormulaTest.Formula("textj(date(\"1995/2/2 23:0:3\"),\"gyy年MMM月dd日 tt\")", null));
        }
        [TestMethod]
        public void texte_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("texte(0/0,\"gy年M月d日\")", null));
        }
        [TestMethod]
        public void texte_E02()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("texte(date(\"2015/2/20 23:0:3\"),0/0)", null));
        }
        [TestMethod]
        public void texte1()
        {
            Assert.AreEqual("西暦15年2月20日", FormulaTest.Formula("texte(date(\"2015/2/20 23:0:3\"),\"gy年M月d日\")", null));
        }
        [TestMethod]
        public void texte2()
        {
            Assert.AreEqual("西暦85/02/20-23:00:03", FormulaTest.Formula("texte(date(\"1985/2/20 23:0:3\"),\"gy/MM/dd-HH:mm:ss\")", null));
        }
        [TestMethod]
        public void texte3()
        {
            Assert.AreEqual("2015/02/20-23:00:03", FormulaTest.Formula("texte(date(\"2015/2/20 23:0:3\"),\"yyyy/MM/dd-HH:mm:ss\")", null));
        }
        [TestMethod]
        public void texte4()
        {
            Assert.AreEqual("西暦1995年2月20日", FormulaTest.Formula("texte(date(\"1995/2/20 23:0:3\"),\"gyyyy年M月d日\")", null));
        }
        [TestMethod]
        public void texte5()
        {
            Assert.AreEqual("西暦95年02月02日", FormulaTest.Formula("texte(date(\"1995/2/2 23:0:3\"),\"gyy年MM月dd日\")", null));
        }
        [TestMethod]
        public void texte7()
        {
            Assert.AreEqual("西暦95年2月02日(木)", FormulaTest.Formula("texte(date(\"1995/2/2 23:0:3\"),\"gyy年MMM月dd日(ddd)\")", null));
        }
        [TestMethod]
        public void texte8()
        {
            Assert.AreEqual("西暦95年2月02日(木曜日)", FormulaTest.Formula("texte(date(\"1995/2/2 23:0:3\"),\"gyy年MMM月dd日(dddd)\")", null));
        }
        [TestMethod]
        public void texte9()
        {
            Assert.AreEqual("1995年2月02日 午後", FormulaTest.Formula("texte(date(\"1995/2/2 23:0:3\"),\"yyyy年MMM月dd日 tt\")", null));
        }
        [TestMethod]
        public void text_E01()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("text(0/0 , \"ggge/m/d\")", null));
        }
        [TestMethod]
        public void text_E02()
        {
            Assert.AreEqual("-ERR-", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),0/0)", null));
        }
        [TestMethod]
        public void text1()
        {
            Assert.AreEqual(@"平成28/1/3", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"ggge/m/d\")", null));
        }
        [TestMethod]
        public void text2()
        {
            Assert.AreEqual(@"H28", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"ge\")", null));
        }
        [TestMethod]
        public void text3()
        {
            Assert.AreEqual(@"16", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"y\")", null));
        }
        [TestMethod]
        public void text4()
        {
            Assert.AreEqual(@"16", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"yy\")", null));
        }
        [TestMethod]
        public void text5()
        {
            Assert.AreEqual(@"2016", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"yyyy\")", null));
        }
        [TestMethod]
        public void text6()
        {
            Assert.AreEqual(@"01", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"mm\")", null));
        }
        [TestMethod]
        public void text7()
        {
            Assert.AreEqual(@"1", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"m\")", null));
        }
        [TestMethod]
        public void text8()
        {
            Assert.AreEqual(@"3", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"d\")", null));
        }
        [TestMethod]
        public void text9()
        {
            Assert.AreEqual(@"03", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"dd\")", null));
        }
        [TestMethod]
        public void text10()
        {
            Assert.AreEqual(@"1", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"h\")", null));
        }
        [TestMethod]
        public void text11()
        {
            Assert.AreEqual(@"01", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"hh\")", null));
        }
        [TestMethod]
        public void text12()
        {
            Assert.AreEqual(@"01:14", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"hh:nn\")", null));
        }
        [TestMethod]
        public void text13()
        {
            Assert.AreEqual(@"1:14", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"h:n\")", null));
        }
        [TestMethod]
        public void text14()
        {
            Assert.AreEqual(@"1:14:3", FormulaTest.Formula("text(date(\"2016/1/3 1:14:3.5678\"),\"h:n:s\")", null));
        }
        [TestMethod]
        public void text15()
        {
            Assert.AreEqual(@"1:14:02", FormulaTest.Formula("text(date(\"2016/1/3 1:14:2.5678\"),\"h:n:ss\")", null));
        }
        [TestMethod]
        public void text16()
        {
            Assert.AreEqual(@"am", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"am/pm\")", null));
        }
        [TestMethod]
        public void text17()
        {
            Assert.AreEqual(@"a", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"a/p\")", null));
        }
        [TestMethod]
        public void text18()
        {
            Assert.AreEqual(@"AM", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"AM/PM\")", null));
        }
        [TestMethod]
        public void text19()
        {
            Assert.AreEqual(@"A", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"A/P\")", null));
        }
        [TestMethod]
        public void text20()
        {
            Assert.AreEqual(@"2016/01/03 01:14:23.56", FormulaTest.Formula("text(date(\"2016/1/3 1:14:23.5678\"),\"yyyy/mm/dd hh:nn:ss.ff\")", null));
        }
        [TestMethod]
        public void text21()
        {
            Assert.AreEqual(@"平成8/1/3", FormulaTest.Formula("text(date(\"1996/1/3 1:14:23.5678\"),\"ggge/m/d\")", null));
        }


    }
}
