﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using Formula;
using Formula.Node;
using System.Text;
using System.Reflection;
using Formula.Node.Impl;
using Formula.Optimizer;
using System.Threading;
using System.Diagnostics;

namespace UnitTestFormula
{
    [TestClass]
    public class UnitTestVariableCashOptimizer
    {
        public UnitTestVariableCashOptimizer()
        {
            //DllLoader loader = DllLoader.getInstance();
            //loader.Load();
        }


        private Dictionary<string, string> getArgs() {
            Dictionary<string, string> args = new Dictionary<string, string>();
            args.Add("a", "1");
            args.Add("b", "2");
            args.Add("c", "3");
            args.Add("d", "4");
            args.Add("e", "5");
            args.Add("f", "6");
            args.Add("g", "7");
            args.Add("h", "8");
            args.Add("i", "9");
            args.Add("j", "10");
            args.Add("k", "11");
            args.Add("l", "12");
            args.Add("m", "13");
            args.Add("n", "14");
            args.Add("o", "15");
            args.Add("p", "16");
            args.Add("q", "17");
            args.Add("r", "18");
            args.Add("s", "19");
            args.Add("t", "20");
            args.Add("u", "21");
            args.Add("v", "22");
            args.Add("w", "23");
            args.Add("x", "24");
            args.Add("y", "25");
            args.Add("z", "26");

            return args;
        }

        [TestMethod]
        public void Optimize_Non_001()
        {
            this.Optimize_Non("a+b", this.getArgs(), 100000);
        }

        [TestMethod]
        public void Optimize_VarCash_001()
        {
            this.Optimize_VarCash("a+b", this.getArgs(), 100000);
        }
        [TestMethod]
        public void Optimize_Non_002()
        {
            this.Optimize_Non("a+b", this.getArgs(), 1000);
        }

        [TestMethod]
        public void Optimize_VarCash_002()
        {
            this.Optimize_VarCash("a+b", this.getArgs(), 1000);
        }
        [TestMethod]
        public void Optimize_Non_003()
        {
            this.Optimize_Non("sum(a,b,c,d)", this.getArgs(), 100000);
        }

        [TestMethod]
        public void Optimize_VarCash_003()
        {
            this.Optimize_VarCash("sum(a,b,c,d)", this.getArgs(), 100000);
        }

        private void Optimize_Non(string formula , Dictionary<string , string> args , int loopCount)
        {
            NodeTreeBuilder builder = new NodeTreeBuilder(Assembly.GetExecutingAssembly().Location);
            builder.Initalize();
            builder.analyzeFormula(formula, false);
            INode ret = builder.Tree;

            Dictionary<string, IValueNode> variableDictionary = new Dictionary<string, IValueNode>();
            //Dictionary<string, string> args = this.getArgs();
            if (args != null)
            {
                foreach (KeyValuePair<string, string> arg in args)
                {
                    WordNode node = new WordNode();
                    node.Value = arg.Value;
                    variableDictionary.Add(arg.Key, node);
                }
            }
            VariableManager manager = new VariableManager(ret);
            manager.loadVariable();
            manager.variableDictionary = variableDictionary;
            manager.setVariable();

            Stopwatch sw = new Stopwatch();
            sw.Start();
            for (int i = 0; i < loopCount; i++)
            {
                INode v = ret.eval();
            }
            sw.Stop();
            Console.WriteLine(sw.ElapsedMilliseconds);
        }

        
        private void Optimize_VarCash(string formula, Dictionary<string, string> args , int loopCount)
        {
            NodeTreeBuilder builder = new NodeTreeBuilder(Assembly.GetExecutingAssembly().Location);
            builder.Initalize();
            builder.analyzeFormula(formula, false);
            INode ret = builder.Tree;

            Dictionary<string, IValueNode> variableDictionary = new Dictionary<string, IValueNode>();
            //Dictionary<string, string> args = this.getArgs();
            if (args != null)
            {
                foreach (KeyValuePair<string, string> arg in args)
                {
                    WordNode node = new WordNode();
                    node.Value = arg.Value;
                    variableDictionary.Add(arg.Key, node);
                }
            }
            VariableManager manager = new VariableManager(ret);
            manager.loadVariable();
            manager.variableDictionary = variableDictionary;
            manager.setVariable();

            Stopwatch sw = new Stopwatch();
            sw.Start();
            VariableCashOptimizer optimizer = new VariableCashOptimizer(manager);
            for (int i = 0; i < loopCount; i++)
            {
                INode node = optimizer.Eval();
            }
            sw.Stop();
            Console.WriteLine(sw.ElapsedMilliseconds);
        }
    }
}
