﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using System.Collections.Generic;
using Formula;
using Formula.Node;
using System.Text;
using System.Reflection;
using Formula.Node.Impl;
using Formula.Optimizer;
using System.Threading;
using System.Diagnostics;

namespace UnitTestFormula
{
    [TestClass]
    public class UnitTestInnerMethodOptimizer
    {
        public UnitTestInnerMethodOptimizer()
        {
            //DllLoader loader = DllLoader.getInstance();
            //loader.Load();
        }


        private Dictionary<string, string> getArgs() {
            Dictionary<string, string> args = new Dictionary<string, string>();
            args.Add("a", "1");
            args.Add("b", "2");
            args.Add("c", "3");
            args.Add("d", "4");
            return args;
        }

        [TestMethod]
        public void innerMethodOptimizeBase001()
        {
            Assert.AreEqual(2m , FormulaTest.FormulaInnerMethodOptimizer("a+a", this.getArgs()));
        }
        [TestMethod]
        public void innerMethodOptimizeBase002()
        {
            Assert.AreEqual(5m, FormulaTest.FormulaInnerMethodOptimizer("a+a+a+a+a", this.getArgs()));
        }
        [TestMethod]
        public void innerMethodOptimizeBase003()
        {
            Assert.AreEqual(2m, FormulaTest.FormulaInnerMethodOptimizer("(a+a+a)+a-(a+a+a)+a", this.getArgs()));
        }
    }
}
