﻿using Formula;
using Formula.Node;
using Formula.Node.Impl;
using Formula.Optimizer.InnerMethodOptimizer;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace UnitTestFormula
{
    class FormulaTest
    {
        public static void _ParceStep(object sender , EventArgs e)
        {
            NodeTreeBuilder.ParceStepEventArgs ev = (NodeTreeBuilder.ParceStepEventArgs)e;
            
            NodeOriginalVisitor visitor2 = new NodeOriginalVisitor();
            Console.WriteLine("--");
            Console.WriteLine(visitor2.visit(ev.Node));
        }

        public static object FormulaInnerMethodOptimizer(string formula, Dictionary<string, string> args)
        {
            Console.WriteLine(formula);

            NodeTreeBuilder builder = new NodeTreeBuilder(Assembly.GetExecutingAssembly().Location);

            builder.OnStepParceFormula += _ParceStep;
            builder.Initalize();
            builder.analyzeFormula(formula, false);
            INode ret = builder.Tree;

            Dictionary<string, IValueNode> variableDictionary = new Dictionary<string, IValueNode>();
            if (args != null)
            {
                foreach (KeyValuePair<string, string> arg in args)
                {
                    WordNode node = new WordNode();
                    node.Value = arg.Value;
                    variableDictionary.Add(arg.Key, node);
                }
            }
            VariableManager manager = new VariableManager(ret);
            manager.loadVariable();
            manager.variableDictionary = variableDictionary;
            manager.setVariable();

            Console.WriteLine("- パース終了 -");
            NodeFormatVisitor visitor = new NodeFormatVisitor();
            Console.WriteLine(visitor.visit(ret));
            Console.WriteLine("--------------");

            

            NodeOriginalVisitor visitor1 = new NodeOriginalVisitor();
            Console.WriteLine(visitor1.visit(ret));

            while (InnerMethodOptimizer.parce(ret)) {
                Console.WriteLine(visitor1.visit(ret));
                Console.WriteLine("--------------");
            }

            Console.WriteLine(visitor1.visit(ret));
            Console.WriteLine("--------------");
            INode v = ret.eval();

            return v is ErrorNode ? "-ERR-" : ((IValueNode)v).Value == null ? null : ((IValueNode)v).Value;
        }

        public static object Formula(string formula, Dictionary<string, string> args)
        {
            Console.WriteLine(formula);

            NodeTreeBuilder builder = new NodeTreeBuilder(Assembly.GetExecutingAssembly().Location);

            builder.OnStepParceFormula += _ParceStep;
            builder.Initalize();
            builder.analyzeFormula(formula , false);
            INode ret = builder.Tree;

            Dictionary<string, IValueNode> variableDictionary = new Dictionary<string, IValueNode>();
            if (args != null)
            {
                foreach (KeyValuePair<string, string> arg in args)
                {
                    WordNode node = new WordNode();
                    node.Value = arg.Value;
                    variableDictionary.Add(arg.Key, node);
                }
            }
            VariableManager manager = new VariableManager(ret);
            manager.loadVariable();
            manager.variableDictionary = variableDictionary;
            manager.setVariable();

            Console.WriteLine("- パース終了 -");
            NodeFormatVisitor visitor = new NodeFormatVisitor();
            //visitor.Target = ret;
            Console.WriteLine(visitor.visit(ret));
            Console.WriteLine("--");
            NodeOriginalVisitor visitor1 = new NodeOriginalVisitor();
            Console.WriteLine(visitor1.visit(ret));

            INode v = ret.eval();

            return v is ErrorNode ? "-ERR-" : ((IValueNode)v).Value == null ? null : ((IValueNode)v).Value;
        }

        public static bool isError(string formula)
        {
            Console.WriteLine(formula);

            NodeTreeBuilder builder = new NodeTreeBuilder(Assembly.GetExecutingAssembly().Location);
            //builder.DllPath = Assembly.GetExecutingAssembly().Location;
            builder.Initalize();
            

            bool ret = !builder.analyzeFormula(formula , true);
            FormulaCheckVisitor.ErrorInformation e = builder.ErrorInfo;
            if (ret)
            {
                Console.WriteLine(e.ErrorMessage);
            }
            Console.WriteLine((new NodeFormatVisitor().visit( builder.Tree)));
            Console.WriteLine("--");
            Console.WriteLine((new NodeOriginalVisitor().visit(builder.Tree)));
            return ret;

        }
    }
}
