﻿/**
FormulaOperator.Variable.DateTimeNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using System;

namespace FormulaOperator.Variable
{
    public class DateTimeNode : AbstractValueNode
    {
        public override object Value
        {
            get { return this.value; }
            set { base.Value = value; }
        }
        public override string Regex
        {
            get
            {
                return @"\d+/\d+/\d+( \d+:\d+:\d+(\.\d+)?)?";
            }
        }

        public override string ToString()
        {
            return string.Format("{0}:[D:{1}-{2}] {3}"
                , this.nodeId
                , this.startPosition
                , this.endPosition
                , ((DateTime)this.Value).ToString("yyyy/MM/dd HH:mm:ss.ffff"));
        }
    }
}
