﻿/**
FormulaOperator.Operator.StringPlusNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using System.Text;
using Formula.Node;
using Formula.Node.Impl;
using System;

namespace FormulaOperator.Operator
{
    public class StringPlusNode : AbstractOperatorNode
    {
        private static string[] signature = { "&" };
        public override string[] Signature { get { return signature; } }
        public override int priority { get { return 0; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode), typeof(IValueNode) }; } }
        public override Type ReturnNode { get { return typeof(WordNode); } }
        public override bool IsPermitLeftNodeBlank { get { return false; } }
        public override string Note { get { return @"値を文字列として連結します。"; } }
        protected override INode execute()
        {
            StringBuilder ret = new StringBuilder();
            //foreach (INode a in this.Args)
            for(int i = 0; i < this.Args.Count; i++)
            {
                INode a = this.Args[i];
                if (a == null) continue;
                if (a is ErrorNode) return a;
                INode r = a.eval();
                if (r is ErrorNode) return r;
                if (r is AbstractValueNode)
                {
                    ret.Append(((AbstractValueNode)r).Value.ToString());
                }
            }
            WordNode v = new WordNode();
            v.Value = ret.ToString();
            return v;
        }
 
    }
}
