﻿/**
FormulaOperator.Operator.NegativeNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaOperator.Operator
{
    public class NegativeNode : AbstractOperatorNode
    {
        private static string[] signature = { "-" };
        public override string[] Signature { get { return signature; } }
        public override int priority { get { return 2; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode), typeof(NumberNode) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override bool IsPermitLeftNodeBlank { get { return true; } }
        public override string Note { get { return @"マイナス値であることを示します"; } }
        protected override INode execute()
        {
            decimal? ret = null;

            INode l = this.getLeftNode();
            INode r = this.getRightNode();
            IValueNode lret = l == null ? null : (IValueNode)l.eval();
            IValueNode rret = r == null ? null : (IValueNode)r.eval();
            if (lret != null && lret is ErrorNode) return lret;
            if (rret != null && rret is ErrorNode) return rret;

            decimal? lvalue = lret == null ? null : lret.getDecimal();
            decimal? rvalue = rret == null ? null : rret.getDecimal();

            if (lvalue == null && rvalue == null) ret = null;
            else if (lvalue == null) ret = -1 * rvalue;
            else if (rvalue == null) ret = lvalue;
            else ret = lvalue - rvalue;
            
            NumberNode v = new NumberNode();
            v.Value = ret;
            return v;
        }

    }
}
