﻿/**
FormulaOperator.Operator.ExpoNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using System;
using FormulaOperator.Variable;
using Formula.Node.Impl;

namespace FormulaOperator.Operator
{
    public class ExpoNode : AbstractOperatorNode
    {
        private static string[] signature = { "^" };
        public override string[] Signature { get { return signature; } }
        public override int priority { get { return 1; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode), typeof(NumberNode) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override bool IsPermitLeftNodeBlank { get { return false; } }
        public override string Note { get { return @"べき乗"; } }
        protected override INode execute()
        {
            decimal? ret = null;


            INode l = this.getLeftNode();
            INode r = this.getRightNode();
            IValueNode lret = l == null ? null : (IValueNode)l.eval();
            IValueNode rret = r == null ? null : (IValueNode)r.eval();
            if (lret != null && lret is ErrorNode) return lret;
            if (rret != null && rret is ErrorNode) return rret;


            decimal? lvalue = lret == null ? null : lret.getDecimal();
            decimal? rvalue = rret == null ? null : rret.getDecimal();

            if (lvalue == null && rvalue == null) ret = null;
            else if (lvalue == null) ret = null;
            else if (rvalue == null) ret = null;
            else
            {
                ret = (decimal)Math.Pow(
                    decimal.ToDouble((decimal)lvalue)
                    , decimal.ToDouble((decimal)rvalue)
                    );
            }

            NumberNode v = new NumberNode();
            v.Value = ret;
            return v;
        }

        //decimal pow2(decimal x, decimal n)
        //{
        //    decimal ans = 1;
        //    while (n != 0)
        //    {
        //        if (n % 2 != 0)
        //        {
        //            ans *= x;
        //        }
        //        x *= x;
        //        n >>= 1m; //decimalでべき乗が大変すぎる
        //    }
        //    return ans;
        //}
    }
}
