﻿/**
FormulaOperator.Logical.LessNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaOperator.Logical
{
    public class LessNode : AbstractOperatorNode
    {
        private static string[] signature = { "<" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode), typeof(IValueNode) }; } }
        public override Type ReturnNode { get { return typeof(BoolNode); } }
        public override bool IsPermitLeftNodeBlank { get { return false; } }
        public override string Note { get { return @"左辺＜右辺のときTRUEを返します。
左辺、右辺は「ともに数値」「ともに日付」いずれかである必要があります。"; } }
        protected override INode execute()
        {
            bool ret = false;
            if (this.getLeftNode() == null || this.getLeftNode() is BlankNode
                || this.getRightNode() == null || this.getRightNode() is BlankNode)
                return new ErrorNode("左辺、あるいは右辺が不正です");
            else
            {
                IValueNode l = (IValueNode)this.getLeftNode().eval();
                IValueNode r = (IValueNode)this.getRightNode().eval();
                if (l is ErrorNode)
                    return l;
                else if (r is ErrorNode)
                    return r;
                else if(l is NumberNode && r is NumberNode)
                    ret = (decimal?)((NumberNode)l).Value < (decimal?)((NumberNode)r).Value;
                else if(l is DateTimeNode && r is DateTimeNode)
                    ret = (DateTime?)((DateTimeNode)l).Value < (DateTime?)((DateTimeNode)r).Value;
            }
            BoolNode v = new BoolNode();
            v.Value = ret;
            return v;
        }

        public override int priority
        {
            get { return -1; }
        }
    }
}
