﻿/**
FormulaMethod.String.TrimNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using System;

namespace FormulaMethod.String
{
    public class TrimNode : AbstractMethodNode
    {

        private static string[] signature = { "trim" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode)}; } }
        public override Type ReturnNode { get { return typeof(WordNode); } }
        public override string Note { get { return @"先頭と最後の非表示文字列（半角スペース・改行）を削除します
"; } }
        protected override INode execute()
        {
            //List<INode> args = new List<INode>();


            INode ret = null;

            if (this.FormatArgs.Count > 1)
                throw new ArgumentException();
            //ret = this.FormatArgs[0];
            ret = this.getArgsAlready(0);
            string s = (((AbstractValueNode)ret).Value.ToString().Trim());
            ret = new WordNode();
            ((WordNode)ret).Value = s;
            return ret;
        }



    }
}
