﻿/**
FormulaMethod.String.TextNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using System;
using System.Text.RegularExpressions;
using System.Linq;
using System.Text;
using FormulaOperator.Variable;
using System.Collections.Generic;

namespace FormulaMethod.String
{
    public class TextNode : AbstractMethodNode
    {

        private static string[] signature = { "text" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(DateTimeNode) , typeof(WordNode)}; } }
        public override Type ReturnNode { get { return typeof(WordNode); } }
        public override string Note { get { return @"日付、もしくは数値を識別子に従い、文字列に変換します。
第１引数：変換対象の日付もしくは数値
第２引数：文字列にする際の識別子

[日付]
m　   先頭に 0 を付けずに数値で月を表示します。
mm　  1桁の場合は先頭に 0 を付けて数値で月を表示します。
mmm   月を省略形で表示します (Jan ～ Dec)。
mmmm  月を完全な名前で表示します (January ～ December)。
mmmmm 月を 1 文字で表示します (J ～ D)。
d     先頭に 0 を付けずに数値で日を表示します。
dd    1桁の場合は先頭に 0 を付けて数値で日を表示します。
ddd   曜日を省略形で表示します (Sun ～ Sat)。
dddd  曜日を完全な名前で表示します (Sunday ～ Saturday)。
aaa   曜日を日本語1文字であらわします(日～土)
aaaa  曜日を日本語であらわします(日曜日～土曜日)
yy    年を 2 桁の数値で表示します。
yyyy  年を 4 桁の数値で表示します。
ggge  和暦を表示します。
h     先頭に 0 を付けずに数値で時を表示します。
hh    1桁の場合は先頭に 0 を付けて数値で時を表示します。表示形式に AM または PM が含まれている場合は、12 時間表示で時が表示されます。それ以外の場合は、24 時間表示で表示されます。
n     先頭に 0 を付けずに数値で分を表示します。
nn    1桁の場合は先頭に 0 を付けて数値で分を表示します。
s     先頭に 0 を付けずに数値で秒を表示します。
ss    1桁の場合は先頭に 0 を付けて数値で秒を表示します。秒の小数以下を表示する場合は、h:mm:ss.00 のような表示形式を使用します。
AM/PM、am/pm、A/P、a/p
      12 時間表示を使用して時刻を表示します。

[数値]
0     数値を桁数指定で置換します。足らない場合は0で埋められます。
#     数値を置換します。

例)
text(date(""2014/12/21 23:0:0"") , ""gggey年m月d日"") = 平成26年12月21日
text(date(""1985 / 2 / 20 23:0:3""),""yyyy/mm/dd-hh:MM:ss\"") = 1985/02/20-23:00:03
text(date(""1995 / 2 / 2 23:0:3""),""gggeyy年MM月dd日 am/pm"") = 平成07年2月02日 pm

text(123.456 , ""#.00000"") = 123.456000


"; } }
        protected override INode execute()
        {

            INode ret = null;

            if (this.FormatArgs.Count > 2)
                throw new ArgumentException();
            StringBuilder v = new StringBuilder();
            //string f = ((IValueNode)this.FormatArgs[1].eval()).Value.ToString();
            string f = ((IValueNode)this.getArgsAlready(1)).Value.ToString();

            //INode node = this.FormatArgs[0].eval();
            INode node = this.getArgsAlready(0);
            //日付
            if (node is DateTimeNode)
            {
                string[] months = new string[] { "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December" };
                string[] days = new string[] { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday" };
                string[] daysj = new string[] { "日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日" };
                List<string> gs = new List<string>( new string[] { "明治", "M", "大正", "T", "昭和", "S", "平成", "H" });
                System.Globalization.CultureInfo ja =
    new System.Globalization.CultureInfo("ja-JP", false);
                ja.DateTimeFormat.Calendar = new System.Globalization.JapaneseCalendar();

                //DateTime d = (DateTime)((IValueNode)this.FormatArgs[0].eval()).Value;
                DateTime d = (DateTime)((IValueNode)this.getArgsAlready(0)).Value;

                if (f.Contains("mmmmm") )
                    f = f.Replace("mmmmm", months[d.Month - 0].Substring(0 , 1));
                if (f.Contains("mmmm"))
                    f = f.Replace("mmmm", months[d.Month - 0]);
                if (f.Contains("mmm"))
                    f = f.Replace("mmmmm", months[d.Month - 0].Substring(0, 3));
                if (f.Contains("mm"))
                    f = f.Replace("mm", d.Month.ToString().PadLeft(2, '0'));
                if (f.Contains("m"))
                {
                    f = Regex.Replace(f, "(?<![aApP])m", d.Month.ToString());
                    //f = f.Replace("m", d.Month.ToString());
                }
                if (f.Contains("dddd"))
                    f = f.Replace("dddd", days[(int)d.DayOfWeek]);
                if (f.Contains("ddd"))
                    f = f.Replace("ddd", days[(int)d.DayOfWeek].Substring(0 , 3));
                if (f.Contains("dd"))
                    f = f.Replace("dd", d.Day.ToString().PadLeft(2, '0'));
                if (f.Contains("d"))
                    f = f.Replace("d", d.Day.ToString());
                if (f.Contains("ee"))
                    f = f.Replace("ee", d.ToString("yy", ja));
                if (f.Contains("e"))
                    f = f.Replace("e", Regex.Replace(d.ToString("yy", ja) , "^0*" , ""));
                if (f.Contains("aaaa"))
                    f = f.Replace("aaaa", daysj[(int)d.DayOfWeek]);
                if (f.Contains("aaa"))
                    f = f.Replace("aaa", daysj[(int)d.DayOfWeek].Substring(0, 1));
                if (f.Contains("yyyy"))
                    f = f.Replace("yyyy", d.Year.ToString());
                if (f.Contains("yy"))
                    f = f.Replace("yy", d.Year.ToString().Substring(d.Year.ToString().Length - 2 , 2));
                if (f.Contains("y"))
                    f = f.Replace("y", d.Year.ToString().Substring(d.Year.ToString().Length - 2, 2));

                if (f.Contains("ggg"))
                    f = f.Replace("ggg", d.ToString("gg", ja));
                if (f.Contains("g"))
                {
                    string t = d.ToString("gg", ja);
                    if (gs.Contains(t))
                        f = f.Replace("g", gs[gs.IndexOf(t) + 1]);
                    else
                        f = f.Replace("g", "");
                }

                if (f.Contains("hh"))
                    f = f.Replace("hh", d.Hour.ToString().PadLeft(2, '0'));
                if (f.Contains("h"))
                    f = f.Replace("h", d.Hour.ToString());
                if (f.Contains("nn"))
                    f = f.Replace("nn", d.Minute.ToString().PadLeft(2, '0'));
                if (f.Contains("n"))
                {
                    //f = Regex.Replace(f, "(?<![aApP])M", d.Minute.ToString());
                    f = f.Replace("n", d.Minute.ToString());
                }
                if (f.Contains("ss"))
                    f = f.Replace("ss", d.Second.ToString().PadLeft(2, '0'));
                if (f.Contains("s"))
                    f = f.Replace("s", d.Second.ToString());
                if(f.Contains("f") || f.Contains("F"))
                {
                    Regex r = new Regex("f+");
                    var l = from Match m in r.Matches(f)
                            select m.Value;
                    foreach (var item in l)
                        f = f.Replace(item, d.Millisecond.ToString().Substring(0, item.Length));
                }

                if (f.Contains("am/pm"))
                    f = f.Replace("am/pm", d.Hour < 12 ? "am" : "pm");
                if (f.Contains("AM/PM"))
                    f = f.Replace("AM/PM", d.Hour < 12 ? "AM" : "PM");
                if (f.Contains("a/p"))
                    f = f.Replace("a/p", d.Hour < 12 ? "a" : "p");
                if (f.Contains("A/P"))
                    f = f.Replace("A/P", d.Hour < 12 ? "A" : "P");
            }
            else if(node is NumberNode)
            {
                //decimal d = (decimal)((IValueNode)this.FormatArgs[0].eval()).Value;
                decimal d = (decimal)((IValueNode)this.getArgsAlready(0)).Value;
                f = d.ToString(f);
            }
            
            ret = new WordNode();
            ((WordNode)ret).Value = f;
            return ret;
        }



    }
}
