﻿/**
FormulaMethod.String.TextjNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using System;
using System.Text.RegularExpressions;
using System.Linq;
using System.Text;
using FormulaOperator.Variable;

namespace FormulaMethod.String
{
    public class TextJNode : AbstractMethodNode
    {

        private static string[] signature = { "textj" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(DateTimeNode) , typeof(WordNode)}; } }
        public override Type ReturnNode { get { return typeof(WordNode); } }
        public override string Note { get { return @"
日付を識別子に従い、文字列に変換します。
第１引数：変換対象の日付
第２引数：文字列にする際の識別子

例)
textj(date(""2014/12/21 23:0:0"") , ""gy年m月d日"") = 平成26年12月21日
textj(date(""1985 / 2 / 20 23:0:3""),""gy/MM/dd-HH:mm:ss\"") = 昭和60/02/20-23:00:03
textj(date(""1995 / 2 / 2 23:0:3""),""gyy年MM月dd日 tt"") = 平成07年2月02日 午後

識別子は以下のものが使用できます。
g       和暦
y       年の下1桁または2桁 (0～99)
yy      年の下2桁 (00～99)
M       月 (1～12)
MM      月 (01～12)
d       日にち (1～31)
dd      日にち (01～31)
dddd    曜日の完全な名前(日曜日～土曜日)
tt      午前/午後
H       時間 (0～23)
HH      時間 (00～23)
h       時間 (1～12)
hh      時間 (01～12)
m       分 (0～59)
mm      分 (00～59)
s       秒 (0～59)
ss      秒 (00～59)
f       1/10秒
ff      1/100秒
fff     1/1000秒
ffff    1/10000秒
fffff   1/100000秒
ffffff  1/1000000秒
fffffff 1/10000000秒
"; } }
        protected override INode execute()
        {

            INode ret = null;

            if (this.FormatArgs.Count > 2)
                throw new ArgumentException();
            StringBuilder v = new StringBuilder();
            //DateTime d = (DateTime)((IValueNode)this.FormatArgs[0].eval()).Value;
            //string f = ((IValueNode)this.FormatArgs[1].eval()).Value.ToString();
            DateTime d = (DateTime)((IValueNode)this.getArgsAlready(0)).Value;
            string f = ((IValueNode)this.getArgsAlready(1)).Value.ToString();

            System.Globalization.CultureInfo ci =
                new System.Globalization.CultureInfo("ja-JP", false);
            ci.DateTimeFormat.Calendar = new System.Globalization.JapaneseCalendar();

            ret = new WordNode();
            ((WordNode)ret).Value = d.ToString(f , ci);
            return ret;
        }



    }
}
