﻿/**
FormulaMethod.String.FindNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.String
{
    public class SubstituteNode : AbstractMethodNode
    {

        private static string[] signature = { "substitute" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode) , typeof(IValueNode) , typeof(IValueNode) }; } }
        public override Type ReturnNode { get { return typeof(WordNode); } }
        public override string Note { get { return @"文字列を置換します。

第一引数：対象文字列
第二引数：置換する文字列(From)
第三引数：置換する文字列(To)
"; } }
        protected override INode execute()
        {
            INode ret = null;

            if (!(this.FormatArgs.Count > 1))
                throw new ArgumentException();

            //string str = ((IValueNode)this.FormatArgs[0].eval()).Value.ToString();
            //string find = ((IValueNode)this.FormatArgs[1].eval()).Value.ToString();
            //string rep = ((IValueNode)this.FormatArgs[2].eval()).Value.ToString();

            string str = ((IValueNode)this.getArgsAlready(0)).Value.ToString();
            string find = ((IValueNode)this.getArgsAlready(1)).Value.ToString();
            string rep = ((IValueNode)this.getArgsAlready(2)).Value.ToString();

            ret = new WordNode();
            if (string.IsNullOrEmpty(find)) ((IValueNode)ret).Value = str;
            else ((IValueNode)ret).Value = str.Replace(find, rep);
            
            return ret;
        }



    }
}
