﻿/**
FormulaMethod.String.RightNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.String
{
    public class RightNode : AbstractMethodNode
    {

        private static string[] signature = { "right" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode) , typeof(NumberNode)}; } }
        public override Type ReturnNode { get { return typeof(WordNode); } }
        public override string Note { get { return @"文字列の最後から数文字を切り取ります

第１引数：対象文字列
第２引数：切り取る長さ
"; } }
        protected override INode execute()
        {
            INode ret = null;

            if (!(this.FormatArgs.Count > 1))
                throw new ArgumentException();

            //string str = ((IValueNode)this.FormatArgs[0].eval()).Value.ToString();
            string str = ((IValueNode)this.getArgsAlready(0)).Value.ToString();
            //int len = decimal.ToInt32((decimal)((IValueNode)this.FormatArgs[1].eval()).getDecimal());
            int len = decimal.ToInt32((decimal)((IValueNode)this.getArgsAlready(1)).getDecimal());

            ret = new WordNode();
            if (str.Length <= len) ((WordNode)ret).Value = str;
            else ((WordNode)ret).Value = str.Substring(str.Length - len, len);
            return ret;
        }



    }
}
