﻿/**
FormulaMethod.String.LowerNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using System;

namespace FormulaMethod.String
{
    public class LowerNode : AbstractMethodNode
    {

        private static string[] signature = { "lower" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(WordNode)}; } }
        public override Type ReturnNode { get { return typeof(WordNode); } }
        public override string Note { get { return @"小文字に変換します
"; } }
        protected override INode execute()
        {
            //List<INode> args = new List<INode>();


            INode ret = null;

            if (this.FormatArgs.Count > 1)
                throw new ArgumentException();
            //ret = this.FormatArgs[0];
            ret = this.getArgsAlready(0);
            string s = (((AbstractValueNode)ret).Value.ToString().ToLowerInvariant());
            ret = new WordNode();
            ((WordNode)ret).Value = s;
            return ret;
        }



    }
}
