﻿/**
FormulaMethod.String.LeftNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.String
{
    public class LeftNode : AbstractMethodNode
    {

        private static string[] signature = { "left" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode) , typeof(NumberNode)}; } }
        public override Type ReturnNode { get { return typeof(WordNode); } }
        public override string Note { get { return @"文字の先頭から指定文字数返します。

第１引数：対象文字列
第２引数：切り取る文字数
"; } }
        protected override INode execute()
        {
            INode ret = null;

            if (!(this.FormatArgs.Count > 1))
                throw new ArgumentException();

            //string str = ((IValueNode)this.FormatArgs[0].eval()).Value.ToString();
            string str = ((IValueNode)this.getArgsAlready(0)).Value.ToString();
            //int len = decimal.ToInt32((decimal)((IValueNode)this.FormatArgs[1].eval()).getDecimal());
            int len = decimal.ToInt32((decimal)((IValueNode)this.getArgsAlready(1)).getDecimal());

            ret = new WordNode();
            if (str.Length > len) ((WordNode)ret).Value = str.Substring(0, len);
            else ((WordNode)ret).Value = str;
            return ret;
        }



    }
}
