﻿/**
FormulaMethod.String.FindNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.String
{
    public class FindNode : AbstractMethodNode
    {

        private static string[] signature = { "find" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode) , typeof(IValueNode) , typeof(NumberNode) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"文字列を文字列で検索します。

第１引数：検索される文字列
第２引数：検索する文字列
第３引数：検索開始位置（省略可）
"; } }
        protected override INode execute()
        {
            INode ret = null;

            if (!(this.FormatArgs.Count > 1))
                throw new ArgumentException();

            //string find = ((IValueNode)this.FormatArgs[0].eval()).Value.ToString();
            string find = ((IValueNode)this.getArgsAlready(0)).Value.ToString();

            //string str = ((IValueNode)this.FormatArgs[1].eval()).Value.ToString();
            string str = ((IValueNode)this.getArgsAlready(1)).Value.ToString();
            //int st = this.FormatArgs.Count <= 1 ? 0 : decimal.ToInt32((decimal)((IValueNode)this.FormatArgs[2].eval()).getDecimal()) - 1;
            int st = this.FormatArgs.Count <= 1 ? 0 : decimal.ToInt32((decimal)((IValueNode)this.getArgsAlready(2)).getDecimal()) - 1;
            int index = str.Substring(st).IndexOf(find);
            
            ret = new NumberNode();

            if (str.Length <= st) throw new ArgumentException("開始位置が不正です");
            else if (index < 0) ((IValueNode)ret).Value = 0m;
            else ((IValueNode)ret).Value = new decimal( index + st + 1);
            return ret;
        }



    }
}
