﻿/**
FormulaMethod.String.ConcatenateNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using FormulaOperator.Variable;
using System;
using System.Text;

namespace FormulaMethod.String
{
    public class ConcatenateNode : AbstractMethodNode
    {

        private static string[] signature = { "concatenate" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode[])}; } }
        public override Type ReturnNode { get { return typeof(IValueNode); } }
        public override string Note { get { return @"引数すべてを文字列として連結します。
"; } }
        protected override INode execute()
        {
            StringBuilder value = new StringBuilder();
            //foreach (INode node in this.FormatArgs)
            for (int i = 0; i < this.FormatArgs.Count;i++)
            {
                INode node = this.getArgsAlready(i);
                object a = ((IValueNode)node).Value;
                if (a != null)
                    value.Append(a);
            }
            WordNode ret = new WordNode();
            ((WordNode)ret).Value = value.ToString();
            return ret;

        }



    }
}
