﻿/**
FormulaMethod.String.CleanNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/
using Formula.Node;
using Formula.Node.Impl;
using System;
using System.Text.RegularExpressions;
using System.Linq;
using System.Text;

namespace FormulaMethod.String
{
    public class CleanNode : AbstractMethodNode
    {

        private static string[] signature = { "clean" };
        public override string[] Signature{get{return signature;}}
        public override Type[] ArgCheckList { get { return new Type[] { typeof(IValueNode)}; } }
        public override Type ReturnNode { get { return typeof(WordNode); } }
        public override string Note { get { return @"改行やタブなど、印刷できない文字を取り除きます。
"; } }
        protected override INode execute()
        {

            INode ret = null;

            if (this.FormatArgs.Count > 1)
                throw new ArgumentException();
            StringBuilder v = new StringBuilder();
            char[] removeChars = new char[] { '\r', '\n' , '\t'};
            //if (((IValueNode)this.FormatArgs[0].eval()).Value != null)
            if (((IValueNode)this.getArgsAlready(0)).Value != null)
                //v.Append(Regex.Replace(((IValueNode)this.FormatArgs[0].eval()).Value.ToString() , @"\p{Cc}" , ""));
                v.Append(Regex.Replace(((IValueNode)this.getArgsAlready(0)).Value.ToString(), @"\p{Cc}", ""));
            ret = new WordNode();
            ((WordNode)ret).Value = v.ToString();
            return ret;
        }



    }
}
