﻿/**
FormulaMethod.Math.RoundUpNode

Copyright (c) 2015 Shigeyuki Horimoto

This software is released under the MIT License.
http://opensource.org/licenses/mit-license.php
*/

using Formula.Node;
using FormulaOperator.Variable;
using System;

namespace FormulaMethod.Math
{
    public class RoundUpNode : AbstractMethodNode
    {
        private static string[] signature = { "roundup" };
        public override string[] Signature { get { return signature; } }
        public override Type[] ArgCheckList { get { return new Type[] { typeof(NumberNode), typeof(NumberNode) }; } }
        public override Type ReturnNode { get { return typeof(NumberNode); } }
        public override string Note { get { return @"第一引数を第二引数の桁で切り上げします。

例)
roundup(456.456 , -4) = 10000
roundup(456.456 , -3) = 1000
roundup(456.456 , -2) = 500
roundup(456.456 , -1) = 460
roundup(456.456 , 0) = 457
roundup(456.456 , 1) = 456.5
roundup(456.456 , 2) = 456.46
roundup(456.456 , 3) = 456.456
roundup(456.456 , 4) = 456.456

roundup(-456.456 , -4) = -10000
roundup(-456.456 , -3) = -1000
roundup(-456.456 , -2) = -500
roundup(-456.456 , -1) = -460
roundup(-456.456 , 0) = -457
roundup(-456.456 , 1) = -456.5
roundup(-456.456 , 2) = -456.46
roundup(-456.456 , 3) = -456.456
roundup(-456.456 , 4) = -456.456
"; } }
        protected override INode execute()
        {

            decimal value = 0m;
            //decimal? tmp = ((IValueNode)this.FormatArgs[0].eval()).getDecimal();
            //decimal? keta = this.FormatArgs.Count <= 1 ? 0m : ((IValueNode)this.FormatArgs[1].eval()).getDecimal();
            decimal? tmp = ((IValueNode)this.getArgsAlready(0)).getDecimal();
            decimal? keta = this.FormatArgs.Count <= 1 ? 0m : ((IValueNode)this.getArgsAlready(1)).getDecimal();

            double k = System.Math.Abs(System.Math.Pow(10, (double)keta));
            decimal tmp2 = System.Math.Abs((decimal)tmp * (decimal)k);
            tmp2 = System.Math.Ceiling((decimal)tmp2);// +(tmp < 0 ? -1 : 0);
            value = ((decimal)tmp2) / (decimal)k * (tmp < 0 ? -1 : 1);

            NumberNode ret = new NumberNode();
            ret.Value = value;

            return ret;
        }

    }
}
